/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/core/SimpleCSSValuesImpl.as
 * org.apache.flex.core.SimpleCSSValuesImpl
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.core.SimpleCSSValuesImpl');

goog.require('org.apache.flex.events.EventDispatcher');
goog.require('org.apache.flex.events.ValueChangeEvent');
goog.require('org.apache.flex.utils.CSSUtils');
goog.require('org.apache.flex.core.IChild');
goog.require('org.apache.flex.core.IDocument');
goog.require('org.apache.flex.core.IStyleableObject');
goog.require('org.apache.flex.core.IValuesImpl');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.events.EventDispatcher}
 * @implements {org.apache.flex.core.IValuesImpl}
 */
org.apache.flex.core.SimpleCSSValuesImpl = function() {
  org.apache.flex.core.SimpleCSSValuesImpl.base(this, 'constructor');
};
goog.inherits(org.apache.flex.core.SimpleCSSValuesImpl, org.apache.flex.events.EventDispatcher);


/**
 * @private
 * @type {Object}
 */
org.apache.flex.core.SimpleCSSValuesImpl.prototype.mainClass;


/**
 * @private
 * @type {Object}
 */
org.apache.flex.core.SimpleCSSValuesImpl.prototype.conditionCombiners;


/**
 * @export
 * @param {Object} mainClass
 */
org.apache.flex.core.SimpleCSSValuesImpl.prototype.init = function(mainClass) {
  var /** @type {Array} */ cssData = mainClass.cssData;
  var /** @type {Object} */ values = this.values;
  if (values == null)
    values = {};
  if (cssData) {
    var /** @type {number} */ n = cssData.length;
    var /** @type {number} */ i = 0;
    while (i < n) {
      var /** @type {number} */ numMQ = Number(cssData[i++]);
      if (numMQ > 0) {
        i += numMQ;
      }
      var /** @type {number} */ numSel = Number(cssData[i++]);
      var /** @type {Object} */ props = {};
      for (var /** @type {number} */ j = 0; j < numSel; j++) {
        var /** @type {string} */ selName = org.apache.flex.utils.Language.string(cssData[i++]);
        if (values[selName])
          props = values[selName];
        values[selName] = props;
      }
      var /** @type {number} */ numProps = Number(cssData[i++]);
      for (j = 0; j < numProps; j++) {
        var /** @type {string} */ propName = org.apache.flex.utils.Language.string(cssData[i++]);
        var /** @type {Object} */ propValue = cssData[i++];
        props[propName] = propValue;
      }
    }
  }
  this.values = values;
};


/**
 * @private
 * @param {string} mq
 * @return {boolean}
 */
org.apache.flex.core.SimpleCSSValuesImpl.prototype.isValidStaticMediaQuery = function(mq) {
  if (mq == null)
    return true;
  if (mq == "-flex-flash")
    return true;
  return false;
};


/**
 * @private
 * @param {string} s
 * @param {string} mq
 * @return {string}
 */
org.apache.flex.core.SimpleCSSValuesImpl.prototype.fixNames = function(s, mq) {
  if (mq != null)
    s = s.substr(mq.length + 1);
  if (s == "")
    return "*";
  var /** @type {Array} */ arr = s.split(" ");
  var /** @type {number} */ n = arr.length;
  for (var /** @type {number} */ i = 0; i < n; i++) {
    var /** @type {string} */ segmentName = org.apache.flex.utils.Language.string(arr[i]);
    if (segmentName.charAt(0) == "#" || segmentName.charAt(0) == ".")
      continue;
    var /** @type {number} */ c = segmentName.lastIndexOf(".");
    if (c > -1) {
      segmentName = segmentName.substr(0, c) + "::" + segmentName.substr(c + 1);
      arr[i] = segmentName;
    }
  }
  return arr.join(" ");
};


/**
 * @export
 * @type {Object}
 */
org.apache.flex.core.SimpleCSSValuesImpl.prototype.values;


/**
 *  @copy org.apache.flex.core.IValuesImpl#getValue()
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Object} thisObject
 * @param {string} valueName
 * @param {string=} state
 * @param {Object=} attrs
 * @return {*}
 */
org.apache.flex.core.SimpleCSSValuesImpl.prototype.getValue = function(thisObject, valueName, state, attrs) {
  state = typeof state !== 'undefined' ? state : null;
  attrs = typeof attrs !== 'undefined' ? attrs : null;
  var /** @type {number} */ c = valueName.indexOf("-");
  while (c != -1) {
    valueName = valueName.substr(0, c) + valueName.charAt(c + 1).toUpperCase() + valueName.substr(c + 2);
    c = valueName.indexOf("-");
  }
  var /** @type {*} */ value;
  var /** @type {Object} */ o;
  var /** @type {string} */ className;
  var /** @type {string} */ selectorName;
  if (org.apache.flex.utils.Language.is(thisObject, org.apache.flex.core.IStyleableObject)) {
    var /** @type {org.apache.flex.core.IStyleableObject} */ styleable = org.apache.flex.utils.Language.as(thisObject, org.apache.flex.core.IStyleableObject, true);
    if (styleable.style != null) {
      try {
        value = styleable.style[valueName];
      } catch (e) {
        value = undefined;
      }
      if (value == "inherit")
        return this.getInheritingValue(thisObject, valueName, state, attrs);
      if (value !== undefined)
        return value;
    }
    if (styleable.id != null) {
      o = this.values["#" + styleable.id];
      if (o) {
        value = o[valueName];
        if (value == "inherit")
          return this.getInheritingValue(thisObject, valueName, state, attrs);
        if (value !== undefined)
          return value;
      }
    }
    var /** @type {string} */ classNames = styleable.className;
    if (classNames) {
      var /** @type {Array} */ classNameList = classNames.split(" ");
      var foreachiter0_target = classNameList;
      for (var foreachiter0 in foreachiter0_target) 
      {
      className = foreachiter0_target[foreachiter0];
      {
        if (state) {
          selectorName = className + ":" + state;
          o = this.values["." + selectorName];
          if (o) {
            value = o[valueName];
            if (value == "inherit")
              return this.getInheritingValue(thisObject, valueName, state, attrs);
            if (value !== undefined)
              return value;
          }
        }
        o = this.values["." + className];
        if (o) {
          value = o[valueName];
          if (value == "inherit")
            return this.getInheritingValue(thisObject, valueName, state, attrs);
          if (value !== undefined)
            return value;
        }
      }}
      
    }
  }
  
  className = org.apache.flex.utils.Language.string(thisObject.FLEXJS_CLASS_INFO.names[0].qName);
  var /** @type {Object} */ thisInstance = thisObject;
  while (className != "Object") {
    if (state) {
      selectorName = className + ":" + state;
      o = this.values[selectorName];
      if (o) {
        value = o[valueName];
        if (value == "inherit")
          return this.getInheritingValue(thisObject, valueName, state, attrs);
        if (value !== undefined)
          return value;
      }
    }
    o = this.values[className];
    if (o) {
      value = o[valueName];
      if (value == "inherit")
        return this.getInheritingValue(thisObject, valueName, state, attrs);
      if (value !== undefined)
        return value;
    }
    
    var /** @type {Object} */ constructorAsObject = thisInstance["constructor"];
    thisInstance = constructorAsObject.superClass_;
    if (!thisInstance || !thisInstance.FLEXJS_CLASS_INFO)
      break;
    className = org.apache.flex.utils.Language.string(thisInstance.FLEXJS_CLASS_INFO.names[0].qName);
  }
  if (org.apache.flex.core.SimpleCSSValuesImpl.inheritingStyles[valueName] != null && org.apache.flex.utils.Language.is(thisObject, org.apache.flex.core.IChild)) {
    var /** @type {Object} */ parentObject = org.apache.flex.utils.Language.as(thisObject, org.apache.flex.core.IChild, true).parent;
    if (parentObject)
      return this.getValue(parentObject, valueName, state, attrs);
  }
  o = this.values["global"];
  if (o) {
    value = o[valueName];
    if (value !== undefined)
      return value;
  }
  o = this.values["*"];
  if (o) {
    return o[valueName];
  }
  return undefined;
};


/**
 * @private
 * @param {Object} thisObject
 * @param {string} valueName
 * @param {string=} state
 * @param {Object=} attrs
 * @return {*}
 */
org.apache.flex.core.SimpleCSSValuesImpl.prototype.getInheritingValue = function(thisObject, valueName, state, attrs) {
  state = typeof state !== 'undefined' ? state : null;
  attrs = typeof attrs !== 'undefined' ? attrs : null;
  var /** @type {*} */ value;
  if (org.apache.flex.utils.Language.is(thisObject, org.apache.flex.core.IChild)) {
    var /** @type {Object} */ parentObject = org.apache.flex.utils.Language.as(thisObject, org.apache.flex.core.IChild, true).parent;
    if (parentObject) {
      value = this.getValue(parentObject, valueName, state, attrs);
      if (value == "inherit" || value === undefined)
        return this.getInheritingValue(parentObject, valueName, state, attrs);
      if (value !== undefined)
        return value;
    }
    return undefined;
  }
  return "inherit";
};


/**
 *  A method that stores a value to be shared with other objects.
 *  It is global, not per instance.  Fancier implementations
 *  may store shared values per-instance.
 * 
 *  @asparam thisObject An object associated with this value.  Thiis
 *                parameter is ignored.
 *  @asparam valueName The name or key of the value being stored.
 *  @asparam The value to be stored.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Object} thisObject
 * @param {string} valueName
 * @param {*} value
 */
org.apache.flex.core.SimpleCSSValuesImpl.prototype.setValue = function(thisObject, valueName, value) {
  var /** @type {number} */ c = valueName.indexOf("-");
  while (c != -1) {
    valueName = valueName.substr(0, c) + valueName.charAt(c + 1).toUpperCase() + valueName.substr(c + 2);
    c = valueName.indexOf("-");
  }
  var /** @type {Object} */ oldValue = this.values[valueName];
  if (oldValue != value) {
    this.values[valueName] = value;
    this.dispatchEvent(new org.apache.flex.events.ValueChangeEvent(org.apache.flex.events.ValueChangeEvent.VALUE_CHANGE, false, false, oldValue, value));
  }
};


/**
 *  @copy org.apache.flex.core.IValuesImpl#newInstance()
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Object} thisObject
 * @param {string} valueName
 * @param {string=} state
 * @param {Object=} attrs
 * @return {*}
 */
org.apache.flex.core.SimpleCSSValuesImpl.prototype.newInstance = function(thisObject, valueName, state, attrs) {
  state = typeof state !== 'undefined' ? state : null;
  attrs = typeof attrs !== 'undefined' ? attrs : null;
  var /** @type {Object} */ c = this.getValue(thisObject, valueName, state, attrs);
  if (c)
    return new c();
  return null;
};


/**
 *  @copy org.apache.flex.core.IValuesImpl#getInstance()
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 *  @flexjsignorecoercion Function
 * @export
 * @param {string} valueName
 * @return {Object}
 */
org.apache.flex.core.SimpleCSSValuesImpl.prototype.getInstance = function(valueName) {
  var /** @type {Object} */ o = this.values["global"];
  o = o[valueName];
  
  var /** @type {Function} */ i = null;
  if (typeof(o) === "function")
    i = o;
  if (i) {
    o[valueName] = new i();
    var /** @type {org.apache.flex.core.IDocument} */ d = org.apache.flex.utils.Language.as(o[valueName], org.apache.flex.core.IDocument);
    if (d)
      d.setDocument(this.mainClass);
  }
  return o;
};


/**
 *  @copy org.apache.flex.core.IValuesImpl#convertColor()
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Object} value
 * @return {number}
 */
org.apache.flex.core.SimpleCSSValuesImpl.prototype.convertColor = function(value) {
  return org.apache.flex.utils.CSSUtils.toColor(value);
};


/**
 *  @copy org.apache.flex.core.IValuesImpl#parseStyles()
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {string} styles
 * @return {Object}
 */
org.apache.flex.core.SimpleCSSValuesImpl.prototype.parseStyles = function(styles) {
  var /** @type {Object} */ obj = {};
  var /** @type {Array} */ parts = styles.split(";");
  var foreachiter1_target = parts;
  for (var foreachiter1 in foreachiter1_target) 
  {
  var part = foreachiter1_target[foreachiter1];
  {
    var /** @type {Array} */ pieces = part.split(":");
    var /** @type {string} */ value = org.apache.flex.utils.Language.string(pieces[1]);
    if (value == "null")
      obj[pieces[0]] = null;
    else if (value == "true")
      obj[pieces[0]] = true;
    else if (value == "false")
      obj[pieces[0]] = false; else {
      var /** @type {number} */ n = Number(value);
      if (isNaN(n)) {
        if (value.charAt(0) == "#") {
          obj[pieces[0]] = org.apache.flex.utils.CSSUtils.toColor(value);
        } else {
          if (value.charAt(0) == "'")
            value = value.substr(1, value.length - 2);
          else if (value.charAt(0) == '"')
            value = value.substr(1, value.length - 2);
          obj[pieces[0]] = value;
        }
      }
      else
        obj[pieces[0]] = n;
    }
  }}
  
  return obj;
};


/**
 *  @copy org.apache.flex.core.IValuesImpl#addRule()
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {string} ruleName
 * @param {Object} values
 */
org.apache.flex.core.SimpleCSSValuesImpl.prototype.addRule = function(ruleName, values) {
  var /** @type {Object} */ asValues = {};
  for (var /** @type {string} */ valueName in values) {
    var /** @type {*} */ v = values[valueName];
    var /** @type {number} */ c = valueName.indexOf("-");
    while (c != -1) {
      valueName = valueName.substr(0, c) + valueName.charAt(c + 1).toUpperCase() + valueName.substr(c + 2);
      c = valueName.indexOf("-");
    }
    asValues[valueName] = v;
  }
  this.values[ruleName] = asValues;
};


/**
 * @export
 * @type {Object}
 */
org.apache.flex.core.SimpleCSSValuesImpl.inheritingStyles = {"color":1, "fontFamily":1, "fontSize":1, "fontStyle":1, "textAlign":1};


/**
 * @export
 * @type {Object}
 */
org.apache.flex.core.SimpleCSSValuesImpl.perInstanceStyles = {'backgroundColor':1, 'backgroundImage':1, 'color':1, 'fontFamily':1, 'fontWeight':1, 'fontSize':1, 'fontStyle':1};


/**
 * @export
 * @type {Object}
 */
org.apache.flex.core.SimpleCSSValuesImpl.colorStyles = {'backgroundColor':1, 'borderColor':1, 'color':1};


/**
 * @export
 * @type {Object}
 */
org.apache.flex.core.SimpleCSSValuesImpl.skipStyles = {'constructor':1};


/**
 * @asparam thisObject The object to apply styles to;
 * @asparam styles The styles.
 * @export
 * @param {org.apache.flex.core.IUIBase} thisObject
 * @param {Object} styles
 */
org.apache.flex.core.SimpleCSSValuesImpl.prototype.applyStyles = function(thisObject, styles) {
  var /** @type {Object} */ styleList = org.apache.flex.core.SimpleCSSValuesImpl.perInstanceStyles;
  var /** @type {Object} */ colorStyles = org.apache.flex.core.SimpleCSSValuesImpl.colorStyles;
  var /** @type {Object} */ skipStyles = org.apache.flex.core.SimpleCSSValuesImpl.skipStyles;
  var /** @type {Object} */ listObj = styles;
  if (styles.styleList)
    listObj = styles.styleList;
  for (var /** @type {string} */ p in listObj) {
    if (skipStyles[p])
      continue;
    var /** @type {*} */ value = styles[p];
    if (value === undefined)
      continue;
    if (typeof(value) == 'number') {
      if (colorStyles[p])
        value = '#' + value.toString(16);
      else
        value = value.toString() + 'px';
    } else if (p == 'backgroundImage') {
      if (p.indexOf('url') !== 0)
        value = 'url(' + value + ')';
    }
    thisObject.element.style[p] = value;
  }
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.core.SimpleCSSValuesImpl.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'SimpleCSSValuesImpl', qName: 'org.apache.flex.core.SimpleCSSValuesImpl'}], interfaces: [org.apache.flex.core.IValuesImpl] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.core.SimpleCSSValuesImpl', org.apache.flex.core.SimpleCSSValuesImpl);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.core.SimpleCSSValuesImpl.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'values': { type: 'Object'}
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'SimpleCSSValuesImpl': { type: '', declaredBy: 'org.apache.flex.core.SimpleCSSValuesImpl'},
        'init': { type: 'void', declaredBy: 'org.apache.flex.core.SimpleCSSValuesImpl'},
        'getValue': { type: '*', declaredBy: 'org.apache.flex.core.SimpleCSSValuesImpl'},
        'setValue': { type: 'void', declaredBy: 'org.apache.flex.core.SimpleCSSValuesImpl'},
        'newInstance': { type: '*', declaredBy: 'org.apache.flex.core.SimpleCSSValuesImpl'},
        'getInstance': { type: 'Object', declaredBy: 'org.apache.flex.core.SimpleCSSValuesImpl'},
        'convertColor': { type: 'uint', declaredBy: 'org.apache.flex.core.SimpleCSSValuesImpl'},
        'parseStyles': { type: 'Object', declaredBy: 'org.apache.flex.core.SimpleCSSValuesImpl'},
        'addRule': { type: 'void', declaredBy: 'org.apache.flex.core.SimpleCSSValuesImpl'},
        'applyStyles': { type: 'void', declaredBy: 'org.apache.flex.core.SimpleCSSValuesImpl'}
      };
    }
  };
};