/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/core/ParentDocumentBead.as
 * org.apache.flex.core.ParentDocumentBead
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.core.ParentDocumentBead');

goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.events.EventDispatcher');
goog.require('org.apache.flex.core.IBead');
goog.require('org.apache.flex.core.IMXMLDocument');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.events.EventDispatcher}
 * @implements {org.apache.flex.core.IBead}
 */
org.apache.flex.core.ParentDocumentBead = function() {
  org.apache.flex.core.ParentDocumentBead.base(this, 'constructor');
};
goog.inherits(org.apache.flex.core.ParentDocumentBead, org.apache.flex.events.EventDispatcher);


/**
 * @private
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.core.ParentDocumentBead.prototype._strand;


/**
 * @private
 * @type {string}
 */
org.apache.flex.core.ParentDocumentBead.prototype._id;


Object.defineProperties(org.apache.flex.core.ParentDocumentBead.prototype, /** @lends {org.apache.flex.core.ParentDocumentBead.prototype} */ {
/** @export */
strand: {
set: /** @this {org.apache.flex.core.ParentDocumentBead} */ function(value) {
  this._strand = value;
}},
/** @export */
id: {
get: /** @this {org.apache.flex.core.ParentDocumentBead} */ function() {
  return this._id;
},
set: /** @this {org.apache.flex.core.ParentDocumentBead} */ function(value) {
  if (this._id != value) {
    this._id = value;
    this.dispatchEvent(new org.apache.flex.events.Event("idChanged"));
  }
}},
/** @export */
parentDocument: {
get: /** @this {org.apache.flex.core.ParentDocumentBead} */ function() {
  var /** @type {Object} */ child = this._strand;
  child = child.parent;
  while (child) {
    if (org.apache.flex.utils.Language.is(child, org.apache.flex.core.IMXMLDocument)) {
      var /** @type {org.apache.flex.core.IMXMLDocument} */ doc = org.apache.flex.utils.Language.as(child, org.apache.flex.core.IMXMLDocument);
      if (doc.MXMLDescriptor != null)
        return doc;
    }
    child = child.parent;
  }
  return null;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.core.ParentDocumentBead.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'ParentDocumentBead', qName: 'org.apache.flex.core.ParentDocumentBead'}], interfaces: [org.apache.flex.core.IBead] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.core.ParentDocumentBead', org.apache.flex.core.ParentDocumentBead);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.core.ParentDocumentBead.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.core.ParentDocumentBead'},
        'id': { type: 'String', declaredBy: 'org.apache.flex.core.ParentDocumentBead'},
        'parentDocument': { type: 'Object', declaredBy: 'org.apache.flex.core.ParentDocumentBead', metadata: function () { return [ { name: 'Bindable', args: [ { key: '', value: 'parentDocumentChange'}]}]; }}
      };
    },
    methods: function () {
      return {
        'ParentDocumentBead': { type: '', declaredBy: 'org.apache.flex.core.ParentDocumentBead'}
      };
    }
  };
};