/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/collections/parsers/JSONInputParser.as
 * org.apache.flex.collections.parsers.JSONInputParser
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.collections.parsers.JSONInputParser');

goog.require('org.apache.flex.collections.parsers.IInputParser');
goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 * @implements {org.apache.flex.collections.parsers.IInputParser}
 */
org.apache.flex.collections.parsers.JSONInputParser = function() {
};


/**
 *  @copy org.apache.flex.net.IInputParser#parseItems
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {string} s
 * @return {Array}
 */
org.apache.flex.collections.parsers.JSONInputParser.prototype.parseItems = function(s) {
  var /** @type {number} */ c = s.indexOf("[");
  if (c != -1) {
    var /** @type {number} */ c2 = s.lastIndexOf("]");
    s = s.substring(c + 1, c2);
  }
  return s.split("},");
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.collections.parsers.JSONInputParser.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'JSONInputParser', qName: 'org.apache.flex.collections.parsers.JSONInputParser'}], interfaces: [org.apache.flex.collections.parsers.IInputParser] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.collections.parsers.JSONInputParser', org.apache.flex.collections.parsers.JSONInputParser);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.collections.parsers.JSONInputParser.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'parseItems': { type: 'Array', declaredBy: 'org.apache.flex.collections.parsers.JSONInputParser'}
      };
    }
  };
};