/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/collections/HierarchicalData.as
 * org.apache.flex.collections.HierarchicalData
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.collections.HierarchicalData');

goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.events.EventDispatcher');
goog.require('org.apache.flex.collections.IHierarchicalData');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *
 *  @asparam value The data used to populate the HierarchicalData instance.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.events.EventDispatcher}
 * @implements {org.apache.flex.collections.IHierarchicalData}
 * @param {Object=} value
 */
org.apache.flex.collections.HierarchicalData = function(value) {
  value = typeof value !== 'undefined' ? value : null;
  org.apache.flex.collections.HierarchicalData.base(this, 'constructor');
  this.source = value;
};
goog.inherits(org.apache.flex.collections.HierarchicalData, org.apache.flex.events.EventDispatcher);


/**
 * @private
 * @type {string}
 */
org.apache.flex.collections.HierarchicalData.prototype._childrenField = "children";


/**
 * @private
 * @type {Object}
 */
org.apache.flex.collections.HierarchicalData.prototype._source;


/**
 * @inheritDoc
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Object} node
 * @return {boolean}
 */
org.apache.flex.collections.HierarchicalData.prototype.canHaveChildren = function(node) {
  if (node == null)
    return false;
  var /** @type {boolean} */ branch = false;
  if (org.apache.flex.utils.Language.is(node, Object)) {
    try {
      if (node[this.childrenField] != undefined) {
        branch = true;
      }
    } catch (e) {
    }
  }
  return branch;
};


/**
 *  @inheritDoc
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Object} node
 * @return {Object}
 */
org.apache.flex.collections.HierarchicalData.prototype.getChildren = function(node) {
  if (node == null)
    return null;
  var /** @type {*} */ children;
  if (org.apache.flex.utils.Language.is(node, Object)) {
    try {
      children = node[this.childrenField];
    } catch (e) {
    }
  }
  if (children === undefined)
    return null;
  return children;
};


/**
 *  @inheritDoc
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Object} node
 * @return {boolean}
 */
org.apache.flex.collections.HierarchicalData.prototype.hasChildren = function(node) {
  if (node == null)
    return false;
  var /** @type {Object} */ children = this.getChildren(node);
  try {
    if (children.length > 0)
      return true;
  } catch (e) {
  }
  return false;
};


/**
 *  @inheritDoc
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Object} node
 * @return {Object}
 */
org.apache.flex.collections.HierarchicalData.prototype.getData = function(node) {
  return Object(node);
};


/**
 * @inheritDoc
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @return {Object}
 */
org.apache.flex.collections.HierarchicalData.prototype.getRoot = function() {
  return this.source;
};


Object.defineProperties(org.apache.flex.collections.HierarchicalData.prototype, /** @lends {org.apache.flex.collections.HierarchicalData.prototype} */ {
/** @export */
childrenField: {
get: /** @this {org.apache.flex.collections.HierarchicalData} */ function() {
  return this._childrenField;
},
set: /** @this {org.apache.flex.collections.HierarchicalData} */ function(value) {
  this._childrenField = value;
}},
/** @export */
source: {
get: /** @this {org.apache.flex.collections.HierarchicalData} */ function() {
  return this._source;
},
set: /** @this {org.apache.flex.collections.HierarchicalData} */ function(value) {
  this._source = value;
  this.dispatchEvent(new org.apache.flex.events.Event("collectionChanged"));
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.collections.HierarchicalData.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'HierarchicalData', qName: 'org.apache.flex.collections.HierarchicalData'}], interfaces: [org.apache.flex.collections.IHierarchicalData] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.collections.HierarchicalData', org.apache.flex.collections.HierarchicalData);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.collections.HierarchicalData.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'childrenField': { type: 'String', declaredBy: 'org.apache.flex.collections.HierarchicalData'},
        'source': { type: 'Object', declaredBy: 'org.apache.flex.collections.HierarchicalData'}
      };
    },
    methods: function () {
      return {
        'HierarchicalData': { type: '', declaredBy: 'org.apache.flex.collections.HierarchicalData'},
        'canHaveChildren': { type: 'Boolean', declaredBy: 'org.apache.flex.collections.HierarchicalData'},
        'getChildren': { type: 'Object', declaredBy: 'org.apache.flex.collections.HierarchicalData'},
        'hasChildren': { type: 'Boolean', declaredBy: 'org.apache.flex.collections.HierarchicalData'},
        'getData': { type: 'Object', declaredBy: 'org.apache.flex.collections.HierarchicalData'},
        'getRoot': { type: 'Object', declaredBy: 'org.apache.flex.collections.HierarchicalData'}
      };
    }
  };
};