/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/utils/Timer.as
 * org.apache.flex.utils.Timer
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.utils.Timer');

goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.events.EventDispatcher');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 * 
 *  @asparam delay The number of milliseconds 
 *  to wait before dispatching the event.
 *  @asparam repeatCount The number of times to dispatch
 *  the event.  If 0, keep dispatching forever.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.events.EventDispatcher}
 * @param {number} delay
 * @param {number=} repeatCount
 */
org.apache.flex.utils.Timer = function(delay, repeatCount) {
  org.apache.flex.utils.Timer.base(this, 'constructor');
  repeatCount = typeof repeatCount !== 'undefined' ? repeatCount : 0;
  this.delay = delay;
  this.repeatCount = repeatCount;
};
goog.inherits(org.apache.flex.utils.Timer, org.apache.flex.events.EventDispatcher);


/**
 * @export
 * @const
 * @type {string}
 */
org.apache.flex.utils.Timer.TIMER = "timer";


/**
 * @export
 * @type {number}
 */
org.apache.flex.utils.Timer.prototype.delay;


/**
 * @export
 * @type {number}
 */
org.apache.flex.utils.Timer.prototype.repeatCount;


/**
 * @private
 * @type {number}
 */
org.apache.flex.utils.Timer.prototype.currentCount = 0;


/**
 * @private
 * @type {number}
 */
org.apache.flex.utils.Timer.prototype.timerInterval = -1;


/**
 * @export
 */
org.apache.flex.utils.Timer.prototype.reset = function() {
  this.stop();
  this.currentCount = 0;
};


/**
 * @export
 */
org.apache.flex.utils.Timer.prototype.stop = function() {
  clearInterval(this.timerInterval);
  this.timerInterval = -1;
};


/**
 * @export
 */
org.apache.flex.utils.Timer.prototype.start = function() {
  this.timerInterval = setInterval(org.apache.flex.utils.Language.closure(this.timerHandler, this, 'timerHandler'), this.delay);
};


/**
 * @private
 */
org.apache.flex.utils.Timer.prototype.timerHandler = function() {
  this.currentCount++;
  if (this.repeatCount > 0 && this.currentCount >= this.repeatCount) {
    this.stop();
  }
  this.dispatchEvent(new org.apache.flex.events.Event('timer'));
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.utils.Timer.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'Timer', qName: 'org.apache.flex.utils.Timer'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.utils.Timer', org.apache.flex.utils.Timer);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.utils.Timer.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'delay': { type: 'Number'},
        'repeatCount': { type: 'int'}
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'Timer': { type: '', declaredBy: 'org.apache.flex.utils.Timer'},
        'reset': { type: 'void', declaredBy: 'org.apache.flex.utils.Timer'},
        'stop': { type: 'void', declaredBy: 'org.apache.flex.utils.Timer'},
        'start': { type: 'void', declaredBy: 'org.apache.flex.utils.Timer'}
      };
    }
  };
};