/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/utils/EffectTimer.as
 * org.apache.flex.utils.EffectTimer
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.utils.EffectTimer');

goog.require('org.apache.flex.core.ValuesManager');
goog.require('org.apache.flex.events.EventDispatcher');
goog.require('org.apache.flex.events.ValueEvent');
goog.require('org.apache.flex.core.IEffectTimer');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 * 
 *  @asparam delay The number of milliseconds 
 *  to wait before dispatching the event.
 *  @asparam repeatCount The number of times to dispatch
 *  the event.  If 0, keep dispatching forever.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.events.EventDispatcher}
 * @implements {org.apache.flex.core.IEffectTimer}
 */
org.apache.flex.utils.EffectTimer = function() {
  org.apache.flex.utils.EffectTimer.base(this, 'constructor');
  this.interval = Number(org.apache.flex.core.ValuesManager.valuesImpl.getValue(this, "effectTimerInterval"));
  
};
goog.inherits(org.apache.flex.utils.EffectTimer, org.apache.flex.events.EventDispatcher);


/**
 * @private
 * @type {number}
 */
org.apache.flex.utils.EffectTimer.prototype.interval;


/**
 * @private
 * @type {number}
 */
org.apache.flex.utils.EffectTimer.prototype.timerInterval;


/**
 * @export
 * @return {number}
 */
org.apache.flex.utils.EffectTimer.prototype.start = function() {
  
  this.timerInterval = setInterval(org.apache.flex.utils.Language.closure(this.timerHandler, this, 'timerHandler'), this.interval);
  var /** @type {Date} */ d = new Date();
  return d.getTime();
};


/**
 * @export
 */
org.apache.flex.utils.EffectTimer.prototype.stop = function() {
  
  clearInterval(this.timerInterval);
  this.timerInterval = -1;
};


/**
 * @private
 */
org.apache.flex.utils.EffectTimer.prototype.timerHandler = function() {
  var /** @type {Date} */ d = new Date();
  this.dispatchEvent(new org.apache.flex.events.ValueEvent('update', false, false, d.getTime()));
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.utils.EffectTimer.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'EffectTimer', qName: 'org.apache.flex.utils.EffectTimer'}], interfaces: [org.apache.flex.core.IEffectTimer] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.utils.EffectTimer', org.apache.flex.utils.EffectTimer);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.utils.EffectTimer.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'EffectTimer': { type: '', declaredBy: 'org.apache.flex.utils.EffectTimer'},
        'start': { type: 'int', declaredBy: 'org.apache.flex.utils.EffectTimer'},
        'stop': { type: 'void', declaredBy: 'org.apache.flex.utils.EffectTimer'}
      };
    },
    metadata: function () { return [ ]; }
  };
};