/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/utils/ColorUtil.as
 * org.apache.flex.utils.ColorUtil
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.utils.ColorUtil');
goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 */
org.apache.flex.utils.ColorUtil = function() {
};


/**
 *  Performs a linear brightness adjustment of an RGB color.
 *
 *  <p>The same amount is added to the red, green, and blue channels
 *  of an RGB color.
 *  Each color channel is limited to the range 0 through 255.</p>
 *
 *  @asparam rgb Original RGB color.
 *
 *  @asparam brite Amount to be added to each color channel.
 *  The range for this parameter is -255 to 255;
 *  -255 produces black while 255 produces white.
 *  If this parameter is 0, the RGB color returned
 *  is the same as the original color.
 *
 *  @asreturn New RGB color.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @export
 * @param {number} rgb
 * @param {number} brite
 * @return {number}
 */
org.apache.flex.utils.ColorUtil.adjustBrightness = function(rgb, brite) {
  var /** @type {number} */ r = Math.max(Math.min(((rgb >> 16) & 0xFF) + brite, 255), 0);
  var /** @type {number} */ g = Math.max(Math.min(((rgb >> 8) & 0xFF) + brite, 255), 0);
  var /** @type {number} */ b = Math.max(Math.min((rgb & 0xFF) + brite, 255), 0);
  return (r << 16) | (g << 8) | b;
};


/**
 *  Performs a scaled brightness adjustment of an RGB color.
 *
 *  @asparam rgb Original RGB color.
 *
 *  @asparam brite The percentage to brighten or darken the original color.
 *  If positive, the original color is brightened toward white
 *  by this percentage. If negative, it is darkened toward black
 *  by this percentage.
 *  The range for this parameter is -100 to 100;
 *  -100 produces black while 100 produces white.
 *  If this parameter is 0, the RGB color returned
 *  is the same as the original color.
 *
 *  @asreturn New RGB color.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @export
 * @param {number} rgb
 * @param {number} brite
 * @return {number}
 */
org.apache.flex.utils.ColorUtil.adjustBrightness2 = function(rgb, brite) {
  var /** @type {number} */ r;
  var /** @type {number} */ g;
  var /** @type {number} */ b;
  if (brite == 0)
    return rgb;
  if (brite < 0) {
    brite = (100 + brite) / 100;
    r = ((rgb >> 16) & 0xFF) * brite;
    g = ((rgb >> 8) & 0xFF) * brite;
    b = (rgb & 0xFF) * brite;
  } else {
    brite /= 100;
    r = ((rgb >> 16) & 0xFF);
    g = ((rgb >> 8) & 0xFF);
    b = (rgb & 0xFF);
    r += ((0xFF - r) * brite);
    g += ((0xFF - g) * brite);
    b += ((0xFF - b) * brite);
    r = Math.min(r, 255);
    g = Math.min(g, 255);
    b = Math.min(b, 255);
  }
  return (r << 16) | (g << 8) | b;
};


/**
 *  Performs an RGB multiplication of two RGB colors.
 *  
 *  <p>This always results in a darker number than either
 *  original color unless one of them is white,
 *  in which case the other color is returned.</p>
 *
 *  @asparam rgb1 First RGB color.
 *
 *  @asparam rgb2 Second RGB color.
 *
 *  @asreturn RGB multiplication of the two colors.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @export
 * @param {number} rgb1
 * @param {number} rgb2
 * @return {number}
 */
org.apache.flex.utils.ColorUtil.rgbMultiply = function(rgb1, rgb2) {
  var /** @type {number} */ r1 = (rgb1 >> 16) & 0xFF;
  var /** @type {number} */ g1 = (rgb1 >> 8) & 0xFF;
  var /** @type {number} */ b1 = rgb1 & 0xFF;
  var /** @type {number} */ r2 = (rgb2 >> 16) & 0xFF;
  var /** @type {number} */ g2 = (rgb2 >> 8) & 0xFF;
  var /** @type {number} */ b2 = rgb2 & 0xFF;
  return ((r1 * r2 / 255) << 16) | ((g1 * g2 / 255) << 8) | (b1 * b2 / 255);
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.utils.ColorUtil.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'ColorUtil', qName: 'org.apache.flex.utils.ColorUtil'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.utils.ColorUtil', org.apache.flex.utils.ColorUtil);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.utils.ColorUtil.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
      };
    }
  };
};