/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/svg/Rect.as
 * org.apache.flex.svg.Rect
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.svg.Rect');

goog.require('org.apache.flex.svg.GraphicShape');
goog.require('org.apache.flex.graphics.IRect');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.7
 * @constructor
 * @extends {org.apache.flex.svg.GraphicShape}
 * @implements {org.apache.flex.graphics.IRect}
 * @param {number=} x
 * @param {number=} y
 * @param {number=} width
 * @param {number=} height
 * @param {number=} rx
 * @param {number=} ry
 */
org.apache.flex.svg.Rect = function(x, y, width, height, rx, ry) {
  org.apache.flex.svg.Rect.base(this, 'constructor');
  x = typeof x !== 'undefined' ? x : 0;
  y = typeof y !== 'undefined' ? y : 0;
  width = typeof width !== 'undefined' ? width : 0;
  height = typeof height !== 'undefined' ? height : 0;
  rx = typeof rx !== 'undefined' ? rx : NaN;
  ry = typeof ry !== 'undefined' ? ry : NaN;
  this.x = x;
  this.y = y;
  this.width = width;
  this.height = height;
  this.rx = rx;
  this.ry = ry;
};
goog.inherits(org.apache.flex.svg.Rect, org.apache.flex.svg.GraphicShape);


/**
 * @private
 * @type {org.apache.flex.core.WrappedHTMLElement}
 */
org.apache.flex.svg.Rect.prototype._rect;


/**
 * @private
 * @type {number}
 */
org.apache.flex.svg.Rect.prototype._rx;


/**
 * @private
 * @type {number}
 */
org.apache.flex.svg.Rect.prototype._ry;


/**
 *  Draw the rectangle.
 *  @asparam xp The x position of the top-left corner of the rectangle.
 *  @asparam yp The y position of the top-left corner.
 *  @asparam width The width of the rectangle.
 *  @asparam height The height of the rectangle.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 *  @flexjsignorecoercion org.apache.flex.core.WrappedHTMLElement
 * @export
 * @param {number} xp
 * @param {number} yp
 * @param {number} width
 * @param {number} height
 */
org.apache.flex.svg.Rect.prototype.drawRect = function(xp, yp, width, height) {
  
  var /** @type {string} */ style = this.getStyleStr();
  if (this._rect == null) {
    this._rect = document.createElementNS('http://www.w3.org/2000/svg', 'rect');
    this._rect.flexjs_wrapper = this;
    this.element.appendChild(this._rect);
  }
  this._rect.setAttribute('style', style);
  if (this.stroke) {
    this._rect.setAttribute('x', this.stroke.weight / 2);
    this._rect.setAttribute('y', this.stroke.weight / 2);
  } else {
    this._rect.setAttribute('x', 0);
    this._rect.setAttribute('y', 0);
  }
  this._rect.setAttribute('width', width);
  this._rect.setAttribute('height', height);
  this.resize(this.x, this.y, this._rect['getBBox']());
};


/**
 * @protected
 * @override
 */
org.apache.flex.svg.Rect.prototype.draw = function() {
  this.drawRect(0, 0, this.width, this.height);
};


Object.defineProperties(org.apache.flex.svg.Rect.prototype, /** @lends {org.apache.flex.svg.Rect.prototype} */ {
/** @export */
rx: {
get: /** @this {org.apache.flex.svg.Rect} */ function() {
  return this._rx;
},
set: /** @this {org.apache.flex.svg.Rect} */ function(value) {
  this._rx = value;
}},
/** @export */
ry: {
get: /** @this {org.apache.flex.svg.Rect} */ function() {
  return this._ry;
},
set: /** @this {org.apache.flex.svg.Rect} */ function(value) {
  this._ry = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.svg.Rect.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'Rect', qName: 'org.apache.flex.svg.Rect'}], interfaces: [org.apache.flex.graphics.IRect] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.svg.Rect', org.apache.flex.svg.Rect);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.svg.Rect.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'rx': { type: 'Number', declaredBy: 'org.apache.flex.svg.Rect'},
        'ry': { type: 'Number', declaredBy: 'org.apache.flex.svg.Rect'}
      };
    },
    methods: function () {
      return {
        'Rect': { type: '', declaredBy: 'org.apache.flex.svg.Rect'},
        'drawRect': { type: 'void', declaredBy: 'org.apache.flex.svg.Rect'}
      };
    }
  };
};