/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/svg/Circle.as
 * org.apache.flex.svg.Circle
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.svg.Circle');

goog.require('org.apache.flex.svg.GraphicShape');
goog.require('org.apache.flex.graphics.ICircle');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.7
 * @constructor
 * @extends {org.apache.flex.svg.GraphicShape}
 * @implements {org.apache.flex.graphics.ICircle}
 * @param {number=} cx
 * @param {number=} cy
 * @param {number=} r
 */
org.apache.flex.svg.Circle = function(cx, cy, r) {
  org.apache.flex.svg.Circle.base(this, 'constructor');
  cx = typeof cx !== 'undefined' ? cx : 0;
  cy = typeof cy !== 'undefined' ? cy : 0;
  r = typeof r !== 'undefined' ? r : 0;
  this.x = cx;
  this.y = cy;
  this.radius = r;
};
goog.inherits(org.apache.flex.svg.Circle, org.apache.flex.svg.GraphicShape);


/**
 * @private
 * @type {number}
 */
org.apache.flex.svg.Circle.prototype._radius;


/**
 * @private
 * @type {org.apache.flex.core.WrappedHTMLElement}
 */
org.apache.flex.svg.Circle.prototype._circle;


/**
 *  Draw the circle.
 *  @asparam cx The x location of the center of the circle
 *  @asparam cy The y location of the center of the circle.
 *  @asparam radius The radius of the circle.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 *  @flexjsignorecoercion org.apache.flex.core.WrappedHTMLElement
 *  @flexjsignorecoercion SVGCircleElement
 * @export
 * @param {number} cx
 * @param {number} cy
 * @param {*} radius
 */
org.apache.flex.svg.Circle.prototype.drawCircle = function(cx, cy, radius) {
  
  var /** @type {string} */ style = this.getStyleStr();
  if (this._circle == null) {
    this._circle = document.createElementNS('http://www.w3.org/2000/svg', 'circle');
    this._circle.flexjs_wrapper = this;
    this.element.appendChild(this._circle);
  }
  this._circle.setAttribute('style', style);
  if (this.stroke) {
    this._circle.setAttribute('cx', radius + this.stroke.weight);
    this._circle.setAttribute('cy', radius + this.stroke.weight);
  } else {
    this._circle.setAttribute('cx', radius);
    this._circle.setAttribute('cy', radius);
  }
  this._circle.setAttribute('r', radius);
  this.resize(this.x - radius, this.y - radius, this._circle.getBBox());
};


/**
 * @protected
 * @override
 */
org.apache.flex.svg.Circle.prototype.draw = function() {
  this.drawCircle(0, 0, this.radius);
};


Object.defineProperties(org.apache.flex.svg.Circle.prototype, /** @lends {org.apache.flex.svg.Circle.prototype} */ {
/** @export */
radius: {
get: /** @this {org.apache.flex.svg.Circle} */ function() {
  return this._radius;
},
set: /** @this {org.apache.flex.svg.Circle} */ function(value) {
  this._radius = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.svg.Circle.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'Circle', qName: 'org.apache.flex.svg.Circle'}], interfaces: [org.apache.flex.graphics.ICircle] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.svg.Circle', org.apache.flex.svg.Circle);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.svg.Circle.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'radius': { type: 'Number', declaredBy: 'org.apache.flex.svg.Circle'}
      };
    },
    methods: function () {
      return {
        'Circle': { type: '', declaredBy: 'org.apache.flex.svg.Circle'},
        'drawCircle': { type: 'void', declaredBy: 'org.apache.flex.svg.Circle'}
      };
    }
  };
};