/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/mobile/models/ViewManagerModel.as
 * org.apache.flex.mobile.models.ViewManagerModel
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.mobile.models.ViewManagerModel');

goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.events.EventDispatcher');
goog.require('org.apache.flex.core.IBeadModel');
goog.require('org.apache.flex.utils.Language');



/**
 * Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.events.EventDispatcher}
 * @implements {org.apache.flex.core.IBeadModel}
 */
org.apache.flex.mobile.models.ViewManagerModel = function() {
  org.apache.flex.mobile.models.ViewManagerModel.base(this, 'constructor');
  this._views = new Array();
};
goog.inherits(org.apache.flex.mobile.models.ViewManagerModel, org.apache.flex.events.EventDispatcher);


/**
 * @private
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.mobile.models.ViewManagerModel.prototype._strand;


/**
 * @export
 * @type {number}
 */
org.apache.flex.mobile.models.ViewManagerModel.prototype.contentX = 0;


/**
 * @export
 * @type {number}
 */
org.apache.flex.mobile.models.ViewManagerModel.prototype.contentY = 0;


/**
 * @export
 * @type {number}
 */
org.apache.flex.mobile.models.ViewManagerModel.prototype.contentWidth = 0;


/**
 * @export
 * @type {number}
 */
org.apache.flex.mobile.models.ViewManagerModel.prototype.contentHeight = 0;


/**
 * @private
 * @type {Array}
 */
org.apache.flex.mobile.models.ViewManagerModel.prototype._views;


/**
 * Pushes a view onto the top/end of the stack of views. This view becomes
 * the active view. Mostly used by the StackedViewManager.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {Object} value
 */
org.apache.flex.mobile.models.ViewManagerModel.prototype.pushView = function(value) {
  this._views.push(value);
  this._selectedIndex = this._views.length - 1;
  this.dispatchEvent(new org.apache.flex.events.Event("viewPushed"));
};


/**
 * Removes the most recently added view. The next view in the stack becomes the
 * active view. Mostly used by StackedViewManager.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @return {Object}
 */
org.apache.flex.mobile.models.ViewManagerModel.prototype.popView = function() {
  if (this._views.length > 1) {
    var /** @type {Object} */ discard = this._views.pop();
    this._selectedIndex = this._views.length - 1;
    this.dispatchEvent(new org.apache.flex.events.Event("viewPopped"));
  }
  return this._views[this._views.length - 1];
};


/**
 * @private
 * @type {number}
 */
org.apache.flex.mobile.models.ViewManagerModel.prototype._selectedIndex = -1;


/**
 * @private
 * @type {string}
 */
org.apache.flex.mobile.models.ViewManagerModel.prototype._title;


/**
 * @private
 * @type {Array}
 */
org.apache.flex.mobile.models.ViewManagerModel.prototype._navigationBarItems;


/**
 * @private
 * @type {org.apache.flex.mobile.chrome.NavigationBar}
 */
org.apache.flex.mobile.models.ViewManagerModel.prototype._navigationBar;


/**
 * @private
 * @type {Array}
 */
org.apache.flex.mobile.models.ViewManagerModel.prototype._toolBarItems;


/**
 * @private
 * @type {org.apache.flex.mobile.chrome.ToolBar}
 */
org.apache.flex.mobile.models.ViewManagerModel.prototype._toolBar;


/**
 * @private
 * @type {org.apache.flex.mobile.chrome.TabBar}
 */
org.apache.flex.mobile.models.ViewManagerModel.prototype._tabBar;


Object.defineProperties(org.apache.flex.mobile.models.ViewManagerModel.prototype, /** @lends {org.apache.flex.mobile.models.ViewManagerModel.prototype} */ {
/** @export */
strand: {
set: /** @this {org.apache.flex.mobile.models.ViewManagerModel} */ function(value) {
  this._strand = value;
}},
/** @export */
views: {
get: /** @this {org.apache.flex.mobile.models.ViewManagerModel} */ function() {
  return this._views;
},
set: /** @this {org.apache.flex.mobile.models.ViewManagerModel} */ function(value) {
  if (value != this._views) {
    this._views = value;
    this._selectedIndex = value.length - 1;
    this.dispatchEvent(new org.apache.flex.events.Event("viewsChanged"));
  }
}},
/** @export */
selectedIndex: {
get: /** @this {org.apache.flex.mobile.models.ViewManagerModel} */ function() {
  return this._selectedIndex;
},
set: /** @this {org.apache.flex.mobile.models.ViewManagerModel} */ function(value) {
  if (value != this._selectedIndex) {
    this._selectedIndex = value;
    this.dispatchEvent(new org.apache.flex.events.Event("selectedIndexChanged"));
  }
}},
/** @export */
title: {
get: /** @this {org.apache.flex.mobile.models.ViewManagerModel} */ function() {
  return this._title;
},
set: /** @this {org.apache.flex.mobile.models.ViewManagerModel} */ function(value) {
  this._title = value;
}},
/** @export */
navigationBarItems: {
get: /** @this {org.apache.flex.mobile.models.ViewManagerModel} */ function() {
  return this._navigationBarItems;
},
set: /** @this {org.apache.flex.mobile.models.ViewManagerModel} */ function(value) {
  this._navigationBarItems = value;
}},
/** @export */
navigationBar: {
get: /** @this {org.apache.flex.mobile.models.ViewManagerModel} */ function() {
  return this._navigationBar;
},
set: /** @this {org.apache.flex.mobile.models.ViewManagerModel} */ function(value) {
  this._navigationBar = value;
}},
/** @export */
toolBarItems: {
get: /** @this {org.apache.flex.mobile.models.ViewManagerModel} */ function() {
  return this._toolBarItems;
},
set: /** @this {org.apache.flex.mobile.models.ViewManagerModel} */ function(value) {
  this._toolBarItems = value;
}},
/** @export */
toolBar: {
get: /** @this {org.apache.flex.mobile.models.ViewManagerModel} */ function() {
  return this._toolBar;
},
set: /** @this {org.apache.flex.mobile.models.ViewManagerModel} */ function(value) {
  this._toolBar = value;
}},
/** @export */
tabBar: {
get: /** @this {org.apache.flex.mobile.models.ViewManagerModel} */ function() {
  return this._tabBar;
},
set: /** @this {org.apache.flex.mobile.models.ViewManagerModel} */ function(value) {
  this._tabBar = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.mobile.models.ViewManagerModel.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'ViewManagerModel', qName: 'org.apache.flex.mobile.models.ViewManagerModel'}], interfaces: [org.apache.flex.core.IBeadModel] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.mobile.models.ViewManagerModel', org.apache.flex.mobile.models.ViewManagerModel);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.mobile.models.ViewManagerModel.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'contentX': { type: 'Number'},
        'contentY': { type: 'Number'},
        'contentWidth': { type: 'Number'},
        'contentHeight': { type: 'Number'}
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.mobile.models.ViewManagerModel'},
        'views': { type: 'Array', declaredBy: 'org.apache.flex.mobile.models.ViewManagerModel'},
        'selectedIndex': { type: 'Number', declaredBy: 'org.apache.flex.mobile.models.ViewManagerModel'},
        'title': { type: 'String', declaredBy: 'org.apache.flex.mobile.models.ViewManagerModel'},
        'navigationBarItems': { type: 'Array', declaredBy: 'org.apache.flex.mobile.models.ViewManagerModel'},
        'navigationBar': { type: 'NavigationBar', declaredBy: 'org.apache.flex.mobile.models.ViewManagerModel'},
        'toolBarItems': { type: 'Array', declaredBy: 'org.apache.flex.mobile.models.ViewManagerModel'},
        'toolBar': { type: 'ToolBar', declaredBy: 'org.apache.flex.mobile.models.ViewManagerModel'},
        'tabBar': { type: 'TabBar', declaredBy: 'org.apache.flex.mobile.models.ViewManagerModel'}
      };
    },
    methods: function () {
      return {
        'ViewManagerModel': { type: '', declaredBy: 'org.apache.flex.mobile.models.ViewManagerModel'},
        'pushView': { type: 'void', declaredBy: 'org.apache.flex.mobile.models.ViewManagerModel'},
        'popView': { type: 'Object', declaredBy: 'org.apache.flex.mobile.models.ViewManagerModel'}
      };
    }
  };
};