/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/mobile/beads/ToggleSwitchView.as
 * org.apache.flex.mobile.beads.ToggleSwitchView
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.mobile.beads.ToggleSwitchView');

goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.graphics.SolidColor');
goog.require('org.apache.flex.graphics.SolidColorStroke');
goog.require('org.apache.flex.svg.Rect');
goog.require('org.apache.flex.core.IBeadView');
goog.require('org.apache.flex.core.IToggleButtonModel');
goog.require('org.apache.flex.core.IUIBase');
goog.require('org.apache.flex.utils.Language');



/**
 * Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @implements {org.apache.flex.core.IBeadView}
 */
org.apache.flex.mobile.beads.ToggleSwitchView = function() {
  ;
};


/**
 * @export
 * @type {org.apache.flex.svg.Rect}
 */
org.apache.flex.mobile.beads.ToggleSwitchView.prototype.boundingBox;


/**
 * @export
 * @type {org.apache.flex.svg.Rect}
 */
org.apache.flex.mobile.beads.ToggleSwitchView.prototype.actualSwitch;


/**
 * @private
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.mobile.beads.ToggleSwitchView.prototype._strand;


/**
 * @asprivate
 * @protected
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.mobile.beads.ToggleSwitchView.prototype.toggleChangedHandler = function(event) {
  this.layoutChromeElements();
};


/**
 * @asprivate
 * @protected
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.mobile.beads.ToggleSwitchView.prototype.sizeChangedHandler = function(event) {
  this.layoutChromeElements();
};


/**
 * @asprivate
 * @protected
 */
org.apache.flex.mobile.beads.ToggleSwitchView.prototype.layoutChromeElements = function() {
  this.sizeViewsToFitContentArea();
};


/**
 * @asprivate
 * @protected
 */
org.apache.flex.mobile.beads.ToggleSwitchView.prototype.sizeViewsToFitContentArea = function() {
  var /** @type {org.apache.flex.core.IToggleButtonModel} */ model = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.core.IToggleButtonModel), org.apache.flex.core.IToggleButtonModel);
  this.boundingBox.x = 0;
  this.boundingBox.y = 0;
  this.boundingBox.setWidthAndHeight(this.host.width, this.host.height, false);
  this.actualSwitch.y = 2;
  this.actualSwitch.setWidthAndHeight(this.host.width / 2 - 2, this.host.height - 4, false);
  var /** @type {org.apache.flex.graphics.SolidColor} */ fill = new org.apache.flex.graphics.SolidColor();
  fill.alpha = 2.0;
  var /** @type {org.apache.flex.graphics.SolidColor} */ switchFill = new org.apache.flex.graphics.SolidColor();
  switchFill.alpha = 1.0;
  switchFill.color = 0xFFFFFF;
  this.actualSwitch.fill = switchFill;
  var /** @type {org.apache.flex.graphics.SolidColorStroke} */ border = new org.apache.flex.graphics.SolidColorStroke();
  border.alpha = 1.0;
  border.color = 0x333333;
  border.weight = 1.0;
  this.boundingBox.stroke = border;
  this.actualSwitch.stroke = border;
  if (model.selected) {
    this.actualSwitch.x = this.host.width / 2;
    fill.color = 0x00DD00;
    this.boundingBox.fill = fill;
  } else {
    this.actualSwitch.x = 2;
    fill.color = 0xFFFFFF;
    this.boundingBox.fill = fill;
  }
  
  this.boundingBox.drawRect(0, 0, this.boundingBox.width, this.boundingBox.height);
  this.actualSwitch.drawRect(this.actualSwitch.x, this.actualSwitch.y, this.actualSwitch.width, this.actualSwitch.height);
};


Object.defineProperties(org.apache.flex.mobile.beads.ToggleSwitchView.prototype, /** @lends {org.apache.flex.mobile.beads.ToggleSwitchView.prototype} */ {
/** @export */
host: {
get: /** @this {org.apache.flex.mobile.beads.ToggleSwitchView} */ function() {
  return org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.IUIBase);
},
set: /** @this {org.apache.flex.mobile.beads.ToggleSwitchView} */ function(value) {
}},
/** @export */
strand: {
get: /** @this {org.apache.flex.mobile.beads.ToggleSwitchView} */ function() {
  return this._strand;
},
set: /** @this {org.apache.flex.mobile.beads.ToggleSwitchView} */ function(value) {
  this._strand = value;
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.UIBase, true).addEventListener("sizeChanged", org.apache.flex.utils.Language.closure(this.sizeChangedHandler, this, 'sizeChangedHandler'));
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.UIBase, true).addEventListener("widthChanged", org.apache.flex.utils.Language.closure(this.sizeChangedHandler, this, 'sizeChangedHandler'));
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.UIBase, true).addEventListener("heightChanged", org.apache.flex.utils.Language.closure(this.sizeChangedHandler, this, 'sizeChangedHandler'));
  var /** @type {org.apache.flex.core.IToggleButtonModel} */ model = org.apache.flex.utils.Language.as(value.getBeadByType(org.apache.flex.core.IToggleButtonModel), org.apache.flex.core.IToggleButtonModel);
  model.addEventListener("selectedChange", org.apache.flex.utils.Language.closure(this.toggleChangedHandler, this, 'toggleChangedHandler'));
  this.boundingBox = new org.apache.flex.svg.Rect();
  org.apache.flex.utils.Language.as(this.host, org.apache.flex.core.UIBase, true).addElement(this.boundingBox, false);
  this.actualSwitch = new org.apache.flex.svg.Rect();
  org.apache.flex.utils.Language.as(this.host, org.apache.flex.core.UIBase, true).addElement(this.actualSwitch, false);
  this.layoutChromeElements();
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.mobile.beads.ToggleSwitchView.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'ToggleSwitchView', qName: 'org.apache.flex.mobile.beads.ToggleSwitchView'}], interfaces: [org.apache.flex.core.IBeadView] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.mobile.beads.ToggleSwitchView', org.apache.flex.mobile.beads.ToggleSwitchView);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.mobile.beads.ToggleSwitchView.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'boundingBox': { type: 'Rect'},
        'actualSwitch': { type: 'Rect'}
      };
    },
    accessors: function () {
      return {
        'host': { type: 'IUIBase', declaredBy: 'org.apache.flex.mobile.beads.ToggleSwitchView'},
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.mobile.beads.ToggleSwitchView'}
      };
    },
    methods: function () {
      return {
        'ToggleSwitchView': { type: '', declaredBy: 'org.apache.flex.mobile.beads.ToggleSwitchView'}
      };
    }
  };
};