/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/mobile/beads/DatePickerView.as
 * org.apache.flex.mobile.beads.DatePickerView
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.mobile.beads.DatePickerView');

goog.require('org.apache.flex.core.BeadViewBase');
goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.html.RangeStepper');
goog.require('org.apache.flex.html.beads.RangeStepperView');
goog.require('org.apache.flex.html.beads.models.RangeModelExtended');
goog.require('org.apache.flex.core.IBeadView');
goog.require('org.apache.flex.core.IDateChooserModel');
goog.require('org.apache.flex.events.IEventDispatcher');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.core.BeadViewBase}
 * @implements {org.apache.flex.core.IBeadView}
 */
org.apache.flex.mobile.beads.DatePickerView = function() {
  org.apache.flex.mobile.beads.DatePickerView.base(this, 'constructor');
};
goog.inherits(org.apache.flex.mobile.beads.DatePickerView, org.apache.flex.core.BeadViewBase);


/**
 * @private
 * @type {org.apache.flex.html.RangeStepper}
 */
org.apache.flex.mobile.beads.DatePickerView.prototype._monthStepper;


/**
 * @private
 * @type {org.apache.flex.html.RangeStepper}
 */
org.apache.flex.mobile.beads.DatePickerView.prototype._dayStepper;


/**
 * @private
 * @type {org.apache.flex.html.RangeStepper}
 */
org.apache.flex.mobile.beads.DatePickerView.prototype._yearStepper;


/**
 * @private
 * @param {org.apache.flex.html.beads.models.RangeModelExtended} model
 * @param {number} index
 * @return {string}
 */
org.apache.flex.mobile.beads.DatePickerView.prototype.monthValue = function(model, index) {
  var /** @type {org.apache.flex.core.IDateChooserModel} */ dayModel = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.core.IDateChooserModel), org.apache.flex.core.IDateChooserModel);
  return String(dayModel.monthNames[index]);
};


/**
 * @private
 * @param {org.apache.flex.html.beads.models.RangeModelExtended} model
 * @param {number} index
 * @return {string}
 */
org.apache.flex.mobile.beads.DatePickerView.prototype.dayValue = function(model, index) {
  return String(index);
};


/**
 * @private
 * @param {org.apache.flex.html.beads.models.RangeModelExtended} model
 * @param {number} index
 * @return {string}
 */
org.apache.flex.mobile.beads.DatePickerView.prototype.yearValue = function(model, index) {
  return String(index);
};


/**
 * @private
 * @param {boolean} state
 */
org.apache.flex.mobile.beads.DatePickerView.prototype.setupListeners = function(state) {
  if (state) {
    org.apache.flex.utils.Language.as(this._monthStepper.model, org.apache.flex.events.IEventDispatcher).addEventListener("valueChange", org.apache.flex.utils.Language.closure(this.handleStepperChange, this, 'handleStepperChange'));
    org.apache.flex.utils.Language.as(this._dayStepper.model, org.apache.flex.events.IEventDispatcher).addEventListener("valueChange", org.apache.flex.utils.Language.closure(this.handleStepperChange, this, 'handleStepperChange'));
    org.apache.flex.utils.Language.as(this._yearStepper.model, org.apache.flex.events.IEventDispatcher).addEventListener("valueChange", org.apache.flex.utils.Language.closure(this.handleStepperChange, this, 'handleStepperChange'));
  } else {
    org.apache.flex.utils.Language.as(this._monthStepper.model, org.apache.flex.events.IEventDispatcher).removeEventListener("valueChange", org.apache.flex.utils.Language.closure(this.handleStepperChange, this, 'handleStepperChange'));
    org.apache.flex.utils.Language.as(this._dayStepper.model, org.apache.flex.events.IEventDispatcher).removeEventListener("valueChange", org.apache.flex.utils.Language.closure(this.handleStepperChange, this, 'handleStepperChange'));
    org.apache.flex.utils.Language.as(this._yearStepper.model, org.apache.flex.events.IEventDispatcher).removeEventListener("valueChange", org.apache.flex.utils.Language.closure(this.handleStepperChange, this, 'handleStepperChange'));
  }
};


/**
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.mobile.beads.DatePickerView.prototype.sizeChangeHandler = function(event) {
  this._monthStepper.x = 0;
  this._monthStepper.y = 0;
  this._dayStepper.x = this._monthStepper.width - 1;
  this._dayStepper.y = 0;
  this._yearStepper.x = this._monthStepper.width + this._dayStepper.width - 2;
  this._yearStepper.y = 0;
};


/**
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.mobile.beads.DatePickerView.prototype.handleStepperChange = function(event) {
  var /** @type {org.apache.flex.core.IDateChooserModel} */ model = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.core.IDateChooserModel), org.apache.flex.core.IDateChooserModel);
  var /** @type {number} */ newMonth = this._monthStepper.value;
  var /** @type {number} */ newDay = this._dayStepper.value;
  var /** @type {number} */ newYear = this._yearStepper.value;
  var /** @type {Date} */ newDate = new Date(newYear, newMonth, newDay);
  var /** @type {Date} */ oldDate = model.selectedDate;
  if (newDate.getFullYear() != newYear || newDate.getDate() != newDay || newDate.getMonth() != newMonth) {
    this.setupListeners(false);
    this._monthStepper.value = oldDate.getMonth();
    this._dayStepper.value = oldDate.getDate();
    this._yearStepper.value = oldDate.getFullYear();
    this.setupListeners(true);
  } else {
    model.selectedDate = newDate;
  }
};


Object.defineProperties(org.apache.flex.mobile.beads.DatePickerView.prototype, /** @lends {org.apache.flex.mobile.beads.DatePickerView.prototype} */ {
/** @export */
strand: {
set: /** @this {org.apache.flex.mobile.beads.DatePickerView} */ function(value) {
  org.apache.flex.utils.Language.superSetter(org.apache.flex.mobile.beads.DatePickerView, this, 'strand', value);
  this._strand = value;
  var /** @type {org.apache.flex.core.UIBase} */ host = org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.UIBase);
  var /** @type {org.apache.flex.core.IDateChooserModel} */ model = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.core.IDateChooserModel), org.apache.flex.core.IDateChooserModel);
  var /** @type {Date} */ today = model.selectedDate;
  var /** @type {number} */ third = org.apache.flex.utils.Language._int(host.width / 3.0);
  this._monthStepper = new org.apache.flex.html.RangeStepper();
  this._monthStepper.className = host.className + "_Month";
  this._monthStepper.addBead(new org.apache.flex.html.beads.models.RangeModelExtended());
  this._monthStepper.addBead(new org.apache.flex.html.beads.RangeStepperView());
  org.apache.flex.utils.Language.as(this._monthStepper.model, org.apache.flex.html.beads.models.RangeModelExtended).labelFunction = org.apache.flex.utils.Language.closure(this.monthValue, this, 'monthValue');
  org.apache.flex.utils.Language.as(this._monthStepper.model, org.apache.flex.html.beads.models.RangeModelExtended).minimum = 0;
  org.apache.flex.utils.Language.as(this._monthStepper.model, org.apache.flex.html.beads.models.RangeModelExtended).maximum = 11;
  org.apache.flex.utils.Language.as(this._monthStepper.model, org.apache.flex.html.beads.models.RangeModelExtended).value = today.getMonth();
  this._monthStepper.setWidthAndHeight(third, host.height);
  host.addElement(this._monthStepper);
  this._dayStepper = new org.apache.flex.html.RangeStepper();
  this._dayStepper.className = host.className + "_Day";
  this._dayStepper.addBead(new org.apache.flex.html.beads.models.RangeModelExtended());
  this._dayStepper.addBead(new org.apache.flex.html.beads.RangeStepperView());
  org.apache.flex.utils.Language.as(this._dayStepper.model, org.apache.flex.html.beads.models.RangeModelExtended).labelFunction = org.apache.flex.utils.Language.closure(this.dayValue, this, 'dayValue');
  org.apache.flex.utils.Language.as(this._dayStepper.model, org.apache.flex.html.beads.models.RangeModelExtended).minimum = 1;
  org.apache.flex.utils.Language.as(this._dayStepper.model, org.apache.flex.html.beads.models.RangeModelExtended).maximum = 31;
  org.apache.flex.utils.Language.as(this._dayStepper.model, org.apache.flex.html.beads.models.RangeModelExtended).value = today.getDate();
  this._dayStepper.setWidthAndHeight(third, host.height);
  host.addElement(this._dayStepper);
  this._yearStepper = new org.apache.flex.html.RangeStepper();
  this._yearStepper.className = host.className + "_Year";
  this._yearStepper.addBead(new org.apache.flex.html.beads.models.RangeModelExtended());
  this._yearStepper.addBead(new org.apache.flex.html.beads.RangeStepperView());
  org.apache.flex.utils.Language.as(this._yearStepper.model, org.apache.flex.html.beads.models.RangeModelExtended).labelFunction = org.apache.flex.utils.Language.closure(this.yearValue, this, 'yearValue');
  org.apache.flex.utils.Language.as(this._yearStepper.model, org.apache.flex.html.beads.models.RangeModelExtended).minimum = 1970;
  org.apache.flex.utils.Language.as(this._yearStepper.model, org.apache.flex.html.beads.models.RangeModelExtended).maximum = 2025;
  org.apache.flex.utils.Language.as(this._yearStepper.model, org.apache.flex.html.beads.models.RangeModelExtended).value = today.getFullYear();
  this._yearStepper.setWidthAndHeight(third, host.height);
  host.addElement(this._yearStepper);
  this.setupListeners(true);
  this.sizeChangeHandler(null);
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.mobile.beads.DatePickerView.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'DatePickerView', qName: 'org.apache.flex.mobile.beads.DatePickerView'}], interfaces: [org.apache.flex.core.IBeadView] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.mobile.beads.DatePickerView', org.apache.flex.mobile.beads.DatePickerView);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.mobile.beads.DatePickerView.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.mobile.beads.DatePickerView'}
      };
    },
    methods: function () {
      return {
        'DatePickerView': { type: '', declaredBy: 'org.apache.flex.mobile.beads.DatePickerView'}
      };
    }
  };
};