/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/mobile/ViewManagerBase.as
 * org.apache.flex.mobile.ViewManagerBase
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.mobile.ViewManagerBase');

goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.mobile.models.ViewManagerModel');
goog.require('org.apache.flex.mobile.IViewManager');
goog.require('org.apache.flex.mobile.IViewManagerView');
goog.require('org.apache.flex.utils.Language');



/**
 * Constructor.
 * @constructor
 * @extends {org.apache.flex.core.UIBase}
 * @implements {org.apache.flex.mobile.IViewManager}
 */
org.apache.flex.mobile.ViewManagerBase = function() {
  org.apache.flex.mobile.ViewManagerBase.base(this, 'constructor');
  this.percentWidth = 100;
  this.percentHeight = 100;
  this.model.addEventListener("selectedIndexChanged", org.apache.flex.utils.Language.closure(this.changeView, this, 'changeView'));
};
goog.inherits(org.apache.flex.mobile.ViewManagerBase, org.apache.flex.core.UIBase);


/**
 * @asprivate
 * @export
 * @return {string}
 */
org.apache.flex.mobile.ViewManagerBase.prototype.toString = function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.mobile.models.ViewManagerModel, true).title;
};


/**
 * @asprivate
 * @export
 * @override
 */
org.apache.flex.mobile.ViewManagerBase.prototype.addedToParent = function() {
  org.apache.flex.mobile.ViewManagerBase.base(this, 'addedToParent');
  var /** @type {number} */ n = org.apache.flex.utils.Language.as(this.model, org.apache.flex.mobile.models.ViewManagerModel, true).views.length;
  if (n > 0) {
    for (var /** @type {number} */ i = 0; i < n; i++) {
      var /** @type {org.apache.flex.mobile.IViewManagerView} */ view = org.apache.flex.utils.Language.as(org.apache.flex.utils.Language.as(this.model, org.apache.flex.mobile.models.ViewManagerModel, true).views[i], org.apache.flex.mobile.IViewManagerView);
      view.viewManager = this;
      if (i == 0) {
        this.addElement(view, true);
      }
    }
    org.apache.flex.utils.Language.as(this.model, org.apache.flex.mobile.models.ViewManagerModel, true).selectedIndex = 0;
  }
};


/**
 * @asprivate
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.mobile.ViewManagerBase.prototype.changeView = function(event) {
  var /** @type {number} */ index = org.apache.flex.utils.Language.as(this.model, org.apache.flex.mobile.models.ViewManagerModel, true).selectedIndex;
  if (this._currentView) {
    this.removeElement(this._currentView);
  }
  this._currentView = this.views[index];
  this.addElement(this._currentView);
  this.dispatchEvent(new org.apache.flex.events.Event("viewChanged"));
};


/**
 * @private
 * @type {org.apache.flex.mobile.IViewManagerView}
 */
org.apache.flex.mobile.ViewManagerBase.prototype._currentView;


/**
 * @private
 * @type {org.apache.flex.mobile.IViewManager}
 */
org.apache.flex.mobile.ViewManagerBase.prototype._viewManager;


Object.defineProperties(org.apache.flex.mobile.ViewManagerBase.prototype, /** @lends {org.apache.flex.mobile.ViewManagerBase.prototype} */ {
/** @export */
title: {
get: /** @this {org.apache.flex.mobile.ViewManagerBase} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.mobile.models.ViewManagerModel, true).title;
},
set: /** @this {org.apache.flex.mobile.ViewManagerBase} */ function(value) {
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.mobile.models.ViewManagerModel, true).title = value;
}},
/** @export */
hasNavigationBar: {
get: /** @this {org.apache.flex.mobile.ViewManagerBase} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.mobile.models.ViewManagerModel, true).navigationBarItems != null;
}},
/** @export */
navigationBarItems: {
get: /** @this {org.apache.flex.mobile.ViewManagerBase} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.mobile.models.ViewManagerModel, true).navigationBarItems;
},
set: /** @this {org.apache.flex.mobile.ViewManagerBase} */ function(value) {
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.mobile.models.ViewManagerModel, true).navigationBarItems = value;
}},
/** @export */
navigationBar: {
get: /** @this {org.apache.flex.mobile.ViewManagerBase} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.mobile.models.ViewManagerModel, true).navigationBar;
}},
/** @export */
views: {
get: /** @this {org.apache.flex.mobile.ViewManagerBase} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.mobile.models.ViewManagerModel, true).views;
},
set: /** @this {org.apache.flex.mobile.ViewManagerBase} */ function(value) {
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.mobile.models.ViewManagerModel, true).views = value;
}},
/** @export */
selectedView: {
get: /** @this {org.apache.flex.mobile.ViewManagerBase} */ function() {
  return this._currentView;
}},
/** @export */
viewManager: {
get: /** @this {org.apache.flex.mobile.ViewManagerBase} */ function() {
  return this._viewManager;
},
set: /** @this {org.apache.flex.mobile.ViewManagerBase} */ function(value) {
  this._viewManager = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.mobile.ViewManagerBase.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'ViewManagerBase', qName: 'org.apache.flex.mobile.ViewManagerBase'}], interfaces: [org.apache.flex.mobile.IViewManager] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.mobile.ViewManagerBase', org.apache.flex.mobile.ViewManagerBase);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.mobile.ViewManagerBase.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'title': { type: 'String', declaredBy: 'org.apache.flex.mobile.ViewManagerBase'},
        'hasNavigationBar': { type: 'Boolean', declaredBy: 'org.apache.flex.mobile.ViewManagerBase'},
        'navigationBarItems': { type: 'Array', declaredBy: 'org.apache.flex.mobile.ViewManagerBase'},
        'navigationBar': { type: 'NavigationBar', declaredBy: 'org.apache.flex.mobile.ViewManagerBase'},
        'views': { type: 'Array', declaredBy: 'org.apache.flex.mobile.ViewManagerBase'},
        'selectedView': { type: 'IViewManagerView', declaredBy: 'org.apache.flex.mobile.ViewManagerBase'},
        'viewManager': { type: 'IViewManager', declaredBy: 'org.apache.flex.mobile.ViewManagerBase'}
      };
    },
    methods: function () {
      return {
        'ViewManagerBase': { type: '', declaredBy: 'org.apache.flex.mobile.ViewManagerBase'},
        'toString': { type: 'String', declaredBy: 'org.apache.flex.mobile.ViewManagerBase'},
        'addedToParent': { type: 'void', declaredBy: 'org.apache.flex.mobile.ViewManagerBase'}
      };
    },
    metadata: function () { return [ ]; }
  };
};