/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/beads/models/DateChooserModel.as
 * org.apache.flex.html.beads.models.DateChooserModel
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.beads.models.DateChooserModel');

goog.require('org.apache.flex.events.Event');
goog.require('org.apache.flex.events.EventDispatcher');
goog.require('org.apache.flex.core.IDateChooserModel');
goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 * @extends {org.apache.flex.events.EventDispatcher}
 * @implements {org.apache.flex.core.IDateChooserModel}
 */
org.apache.flex.html.beads.models.DateChooserModel = function() {
  org.apache.flex.html.beads.models.DateChooserModel.base(this, 'constructor');
  
  this._dayNames = ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
  this._monthNames = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
  var /** @type {Date} */ today = new Date();
  this.displayedYear = today.getFullYear();
  this.displayedMonth = today.getMonth();
};
goog.inherits(org.apache.flex.html.beads.models.DateChooserModel, org.apache.flex.events.EventDispatcher);


/**
 * @private
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.html.beads.models.DateChooserModel.prototype._strand;


/**
 * @private
 * @type {Array}
 */
org.apache.flex.html.beads.models.DateChooserModel.prototype._dayNames;


/**
 * @private
 * @type {Array}
 */
org.apache.flex.html.beads.models.DateChooserModel.prototype._monthNames;


/**
 * @private
 * @type {number}
 */
org.apache.flex.html.beads.models.DateChooserModel.prototype._displayedYear;


/**
 * @private
 * @type {number}
 */
org.apache.flex.html.beads.models.DateChooserModel.prototype._displayedMonth;


/**
 * @private
 * @type {number}
 */
org.apache.flex.html.beads.models.DateChooserModel.prototype._firstDayOfWeek = 0;


/**
 * @private
 * @type {Date}
 */
org.apache.flex.html.beads.models.DateChooserModel.prototype._selectedDate;


Object.defineProperties(org.apache.flex.html.beads.models.DateChooserModel.prototype, /** @lends {org.apache.flex.html.beads.models.DateChooserModel.prototype} */ {
/** @export */
strand: {
set: /** @this {org.apache.flex.html.beads.models.DateChooserModel} */ function(value) {
  this._strand = value;
}},
/** @export */
dayNames: {
get: /** @this {org.apache.flex.html.beads.models.DateChooserModel} */ function() {
  return this._dayNames;
},
set: /** @this {org.apache.flex.html.beads.models.DateChooserModel} */ function(value) {
  this._dayNames = value;
  this.dispatchEvent(new org.apache.flex.events.Event("dayNamesChanged"));
}},
/** @export */
monthNames: {
get: /** @this {org.apache.flex.html.beads.models.DateChooserModel} */ function() {
  return this._monthNames;
},
set: /** @this {org.apache.flex.html.beads.models.DateChooserModel} */ function(value) {
  this._monthNames = value;
  this.dispatchEvent(new org.apache.flex.events.Event("monthNames"));
}},
/** @export */
displayedYear: {
get: /** @this {org.apache.flex.html.beads.models.DateChooserModel} */ function() {
  return this._displayedYear;
},
set: /** @this {org.apache.flex.html.beads.models.DateChooserModel} */ function(value) {
  if (value != this._displayedYear) {
    this._displayedYear = value;
    this.dispatchEvent(new org.apache.flex.events.Event("displayedYearChanged"));
  }
}},
/** @export */
displayedMonth: {
get: /** @this {org.apache.flex.html.beads.models.DateChooserModel} */ function() {
  return this._displayedMonth;
},
set: /** @this {org.apache.flex.html.beads.models.DateChooserModel} */ function(value) {
  if (this._displayedMonth != value) {
    this._displayedMonth = value;
    this.dispatchEvent(new org.apache.flex.events.Event("displayedMonthChanged"));
  }
}},
/** @export */
firstDayOfWeek: {
get: /** @this {org.apache.flex.html.beads.models.DateChooserModel} */ function() {
  return this._firstDayOfWeek;
},
set: /** @this {org.apache.flex.html.beads.models.DateChooserModel} */ function(value) {
  if (value != this._firstDayOfWeek) {
    this._firstDayOfWeek = value;
    this.dispatchEvent(new org.apache.flex.events.Event("firstDayOfWeekChanged"));
  }
}},
/** @export */
selectedDate: {
get: /** @this {org.apache.flex.html.beads.models.DateChooserModel} */ function() {
  return this._selectedDate;
},
set: /** @this {org.apache.flex.html.beads.models.DateChooserModel} */ function(value) {
  if (value != this._selectedDate) {
    this._selectedDate = value;
    this.dispatchEvent(new org.apache.flex.events.Event("selectedDateChanged"));
    this.displayedMonth = value.getMonth();
    this.displayedYear = value.getFullYear();
  }
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.beads.models.DateChooserModel.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'DateChooserModel', qName: 'org.apache.flex.html.beads.models.DateChooserModel'}], interfaces: [org.apache.flex.core.IDateChooserModel] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.beads.models.DateChooserModel', org.apache.flex.html.beads.models.DateChooserModel);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.beads.models.DateChooserModel.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.html.beads.models.DateChooserModel'},
        'dayNames': { type: 'Array', declaredBy: 'org.apache.flex.html.beads.models.DateChooserModel'},
        'monthNames': { type: 'Array', declaredBy: 'org.apache.flex.html.beads.models.DateChooserModel'},
        'displayedYear': { type: 'Number', declaredBy: 'org.apache.flex.html.beads.models.DateChooserModel'},
        'displayedMonth': { type: 'Number', declaredBy: 'org.apache.flex.html.beads.models.DateChooserModel'},
        'firstDayOfWeek': { type: 'Number', declaredBy: 'org.apache.flex.html.beads.models.DateChooserModel'},
        'selectedDate': { type: 'Date', declaredBy: 'org.apache.flex.html.beads.models.DateChooserModel'}
      };
    },
    methods: function () {
      return {
        'DateChooserModel': { type: '', declaredBy: 'org.apache.flex.html.beads.models.DateChooserModel'}
      };
    }
  };
};