/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/beads/layouts/TileLayout.as
 * org.apache.flex.html.beads.layouts.TileLayout
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.beads.layouts.TileLayout');

goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.core.IBeadLayout');
goog.require('org.apache.flex.core.ILayoutHost');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @implements {org.apache.flex.core.IBeadLayout}
 */
org.apache.flex.html.beads.layouts.TileLayout = function() {

this._columnWidth = Number.NaN;
this._rowHeight = Number.NaN;
};


/**
 * @private
 * @type {org.apache.flex.core.IStrand}
 */
org.apache.flex.html.beads.layouts.TileLayout.prototype._strand;


/**
 * @private
 * @type {number}
 */
org.apache.flex.html.beads.layouts.TileLayout.prototype._numColumns = 4;


/**
 * @private
 * @type {number}
 */
org.apache.flex.html.beads.layouts.TileLayout.prototype._columnWidth;


/**
 * @private
 * @type {number}
 */
org.apache.flex.html.beads.layouts.TileLayout.prototype._rowHeight;


/**
 * @copy org.apache.flex.core.IBeadLayout#layout
 * @export
 * @return {boolean}
 */
org.apache.flex.html.beads.layouts.TileLayout.prototype.layout = function() {
  
  var /** @type {Array} */ children;
  var /** @type {number} */ i;
  var /** @type {number} */ n;
  var /** @type {org.apache.flex.core.UIBase} */ child;
  var /** @type {number} */ xpos;
  var /** @type {number} */ ypos;
  var /** @type {number} */ useWidth;
  var /** @type {number} */ useHeight;
  var /** @type {org.apache.flex.core.UIBase} */ host = org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.UIBase);
  var /** @type {org.apache.flex.core.ILayoutHost} */ viewBead = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.core.ILayoutHost), org.apache.flex.core.ILayoutHost);
  var /** @type {org.apache.flex.core.IParentIUIBase} */ contentView = viewBead.contentView;
  children = contentView.internalChildren();
  n = children.length;
  if (n === 0)
    return false;
  viewBead.contentView.width = host.width;
  var /** @type {number} */ realN = n;
  for (i = 0; i < n; i++) {
    child = children[i].flexjs_wrapper;
    if (!child.visible)
      realN--;
  }
  xpos = 0;
  ypos = 0;
  useWidth = this.columnWidth;
  useHeight = this.rowHeight;
  if (isNaN(useWidth))
    useWidth = Math.floor(host.width / this.numColumns);
  if (isNaN(useHeight)) {
    var /** @type {number} */ numRows = Math.floor(realN / this.numColumns);
    useHeight = Math.floor(host.height / numRows);
  }
  for (i = 0; i < n; i++) {
    child = children[i].flexjs_wrapper;
    if (!child.visible)
      continue;
    child.setDisplayStyleForLayout('inline-block');
    child.width = useWidth;
    child.height = useHeight;
  }
  return true;
};


Object.defineProperties(org.apache.flex.html.beads.layouts.TileLayout.prototype, /** @lends {org.apache.flex.html.beads.layouts.TileLayout.prototype} */ {
/** @export */
strand: {
set: /** @this {org.apache.flex.html.beads.layouts.TileLayout} */ function(value) {
  this._strand = value;
}},
/** @export */
numColumns: {
get: /** @this {org.apache.flex.html.beads.layouts.TileLayout} */ function() {
  return this._numColumns;
},
set: /** @this {org.apache.flex.html.beads.layouts.TileLayout} */ function(value) {
  this._numColumns = value;
}},
/** @export */
columnWidth: {
get: /** @this {org.apache.flex.html.beads.layouts.TileLayout} */ function() {
  return this._columnWidth;
},
set: /** @this {org.apache.flex.html.beads.layouts.TileLayout} */ function(value) {
  this._columnWidth = value;
}},
/** @export */
rowHeight: {
get: /** @this {org.apache.flex.html.beads.layouts.TileLayout} */ function() {
  return this._rowHeight;
},
set: /** @this {org.apache.flex.html.beads.layouts.TileLayout} */ function(value) {
  this._rowHeight = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.beads.layouts.TileLayout.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'TileLayout', qName: 'org.apache.flex.html.beads.layouts.TileLayout'}], interfaces: [org.apache.flex.core.IBeadLayout] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.beads.layouts.TileLayout', org.apache.flex.html.beads.layouts.TileLayout);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.beads.layouts.TileLayout.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.html.beads.layouts.TileLayout'},
        'numColumns': { type: 'Number', declaredBy: 'org.apache.flex.html.beads.layouts.TileLayout'},
        'columnWidth': { type: 'Number', declaredBy: 'org.apache.flex.html.beads.layouts.TileLayout'},
        'rowHeight': { type: 'Number', declaredBy: 'org.apache.flex.html.beads.layouts.TileLayout'}
      };
    },
    methods: function () {
      return {
        'TileLayout': { type: '', declaredBy: 'org.apache.flex.html.beads.layouts.TileLayout'},
        'layout': { type: 'Boolean', declaredBy: 'org.apache.flex.html.beads.layouts.TileLayout'}
      };
    }
  };
};