/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/beads/SpinnerView.as
 * org.apache.flex.html.beads.SpinnerView
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.beads.SpinnerView');

goog.require('org.apache.flex.core.BeadViewBase');
goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.html.beads.controllers.SpinnerMouseController');
goog.require('org.apache.flex.html.supportClasses.SpinnerButton');
goog.require('org.apache.flex.core.IBeadView');
goog.require('org.apache.flex.html.beads.ISpinnerView');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.core.BeadViewBase}
 * @implements {org.apache.flex.html.beads.ISpinnerView}
 * @implements {org.apache.flex.core.IBeadView}
 */
org.apache.flex.html.beads.SpinnerView = function() {
  org.apache.flex.html.beads.SpinnerView.base(this, 'constructor');
};
goog.inherits(org.apache.flex.html.beads.SpinnerView, org.apache.flex.core.BeadViewBase);


/**
 * @private
 * @type {org.apache.flex.core.IRangeModel}
 */
org.apache.flex.html.beads.SpinnerView.prototype.rangeModel;


Object.defineProperties(org.apache.flex.html.beads.SpinnerView.prototype, /** @lends {org.apache.flex.html.beads.SpinnerView.prototype} */ {
/** @export */
strand: {
set: /** @this {org.apache.flex.html.beads.SpinnerView} */ function(value) {
  org.apache.flex.utils.Language.superSetter(org.apache.flex.html.beads.SpinnerView, this, 'strand', value);
  
  var /** @type {org.apache.flex.core.UIBase} */ host = org.apache.flex.utils.Language.as(value, org.apache.flex.core.UIBase);
  this._increment = new org.apache.flex.html.supportClasses.SpinnerButton();
  this._increment.text = '▲';
  host.addElement(this._increment);
  this._decrement = new org.apache.flex.html.supportClasses.SpinnerButton();
  this._decrement.text = '▼';
  host.addElement(this._decrement);
  this.controller = new org.apache.flex.html.beads.controllers.SpinnerMouseController();
  host.addBead(this.controller);
}},
/** @export */
decrement: {
get: /** @this {org.apache.flex.html.beads.SpinnerView} */ function() {
  return this._decrement;
}},
/** @export */
increment: {
get: /** @this {org.apache.flex.html.beads.SpinnerView} */ function() {
  return this._increment;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.beads.SpinnerView.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'SpinnerView', qName: 'org.apache.flex.html.beads.SpinnerView'}], interfaces: [org.apache.flex.html.beads.ISpinnerView, org.apache.flex.core.IBeadView] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.beads.SpinnerView', org.apache.flex.html.beads.SpinnerView);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.beads.SpinnerView.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.html.beads.SpinnerView'},
        'decrement': { type: 'SpinnerButton', declaredBy: 'org.apache.flex.html.beads.SpinnerView'},
        'increment': { type: 'SpinnerButton', declaredBy: 'org.apache.flex.html.beads.SpinnerView'}
      };
    },
    methods: function () {
      return {
        'SpinnerView': { type: '', declaredBy: 'org.apache.flex.html.beads.SpinnerView'}
      };
    }
  };
};