/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/beads/DateFieldView.as
 * org.apache.flex.html.beads.DateFieldView
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.beads.DateFieldView');

goog.require('org.apache.flex.core.BeadViewBase');
goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.geom.Point');
goog.require('org.apache.flex.html.DateChooser');
goog.require('org.apache.flex.html.TextButton');
goog.require('org.apache.flex.html.TextInput');
goog.require('org.apache.flex.utils.PointUtils');
goog.require('org.apache.flex.utils.UIUtils');
goog.require('org.apache.flex.core.IBeadView');
goog.require('org.apache.flex.core.IDateChooserModel');
goog.require('org.apache.flex.core.IFormatBead');
goog.require('org.apache.flex.events.IEventDispatcher');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.core.BeadViewBase}
 * @implements {org.apache.flex.core.IBeadView}
 */
org.apache.flex.html.beads.DateFieldView = function() {
  org.apache.flex.html.beads.DateFieldView.base(this, 'constructor');
};
goog.inherits(org.apache.flex.html.beads.DateFieldView, org.apache.flex.core.BeadViewBase);


/**
 * @private
 * @type {org.apache.flex.html.TextInput}
 */
org.apache.flex.html.beads.DateFieldView.prototype._textInput;


/**
 * @private
 * @type {org.apache.flex.html.TextButton}
 */
org.apache.flex.html.beads.DateFieldView.prototype._button;


/**
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.beads.DateFieldView.prototype.handleBeadsAdded = function(event) {
  var /** @type {org.apache.flex.core.IFormatBead} */ formatter = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.core.IFormatBead), org.apache.flex.core.IFormatBead);
  formatter.addEventListener("formatChanged", org.apache.flex.utils.Language.closure(this.handleFormatChanged, this, 'handleFormatChanged'));
};


/**
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.html.beads.DateFieldView.prototype.handleFormatChanged = function(event) {
  var /** @type {org.apache.flex.core.IFormatBead} */ formatter = org.apache.flex.utils.Language.as(event.target, org.apache.flex.core.IFormatBead);
  this._textInput.text = formatter.formattedString;
};


/**
 * @private
 * @type {org.apache.flex.html.DateChooser}
 */
org.apache.flex.html.beads.DateFieldView.prototype._popUp;


/**
 * @private
 * @type {boolean}
 */
org.apache.flex.html.beads.DateFieldView.prototype._popUpVisible;


Object.defineProperties(org.apache.flex.html.beads.DateFieldView.prototype, /** @lends {org.apache.flex.html.beads.DateFieldView.prototype} */ {
/** @export */
menuButton: {
get: /** @this {org.apache.flex.html.beads.DateFieldView} */ function() {
  return this._button;
}},
/** @export */
textInput: {
get: /** @this {org.apache.flex.html.beads.DateFieldView} */ function() {
  return this._textInput;
}},
/** @export */
strand: {
set: /** @this {org.apache.flex.html.beads.DateFieldView} */ function(value) {
  org.apache.flex.utils.Language.superSetter(org.apache.flex.html.beads.DateFieldView, this, 'strand', value);
  this._textInput = new org.apache.flex.html.TextInput();
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.UIBase, true).addElement(this._textInput);
  this._textInput.width = 100;
  this._textInput.height = 18;
  this._button = new org.apache.flex.html.TextButton();
  this._button.text = "M";
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.UIBase, true).addElement(this._button);
  this._button.x = this._textInput.width;
  this._button.y = this._textInput.y;
  org.apache.flex.utils.Language.as(this._strand, org.apache.flex.events.IEventDispatcher, true).addEventListener("beadsAdded", org.apache.flex.utils.Language.closure(this.handleBeadsAdded, this, 'handleBeadsAdded'));
}},
/** @export */
popUp: {
get: /** @this {org.apache.flex.html.beads.DateFieldView} */ function() {
  return this._popUp;
}},
/** @export */
popUpVisible: {
get: /** @this {org.apache.flex.html.beads.DateFieldView} */ function() {
  return this._popUpVisible;
},
set: /** @this {org.apache.flex.html.beads.DateFieldView} */ function(value) {
  if (value != this._popUpVisible) {
    this._popUpVisible = value;
    if (value) {
      if (!this._popUp) {
        this._popUp = new org.apache.flex.html.DateChooser();
        this._popUp.width = 210;
        this._popUp.height = 220;
      }
      var /** @type {org.apache.flex.core.IDateChooserModel} */ model = org.apache.flex.utils.Language.as(this._strand.getBeadByType(org.apache.flex.core.IDateChooserModel), org.apache.flex.core.IDateChooserModel);
      this._popUp.selectedDate = model.selectedDate;
      var /** @type {org.apache.flex.core.IPopUpHost} */ host = org.apache.flex.utils.UIUtils.findPopUpHost(org.apache.flex.utils.Language.as(this._strand, org.apache.flex.core.UIBase, true));
      var /** @type {org.apache.flex.geom.Point} */ point = new org.apache.flex.geom.Point(this._button.x, this._button.y + this._button.height);
      var /** @type {org.apache.flex.geom.Point} */ p2 = org.apache.flex.utils.PointUtils.localToGlobal(point, this._strand);
      var /** @type {org.apache.flex.geom.Point} */ p3 = org.apache.flex.utils.PointUtils.globalToLocal(p2, host);
      this._popUp.x = p3.x;
      this._popUp.y = p3.y;
      host.addElement(this._popUp);
    } else {
      org.apache.flex.utils.UIUtils.removePopUp(this._popUp);
    }
  }
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.beads.DateFieldView.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'DateFieldView', qName: 'org.apache.flex.html.beads.DateFieldView'}], interfaces: [org.apache.flex.core.IBeadView] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.beads.DateFieldView', org.apache.flex.html.beads.DateFieldView);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.beads.DateFieldView.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'menuButton': { type: 'TextButton', declaredBy: 'org.apache.flex.html.beads.DateFieldView'},
        'textInput': { type: 'TextInput', declaredBy: 'org.apache.flex.html.beads.DateFieldView'},
        'strand': { type: 'IStrand', declaredBy: 'org.apache.flex.html.beads.DateFieldView'},
        'popUp': { type: 'DateChooser', declaredBy: 'org.apache.flex.html.beads.DateFieldView'},
        'popUpVisible': { type: 'Boolean', declaredBy: 'org.apache.flex.html.beads.DateFieldView'}
      };
    },
    methods: function () {
      return {
        'DateFieldView': { type: '', declaredBy: 'org.apache.flex.html.beads.DateFieldView'}
      };
    }
  };
};