/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/html/ImageAndTextButton.as
 * org.apache.flex.html.ImageAndTextButton
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.html.ImageAndTextButton');

goog.require('org.apache.flex.html.TextButton');
goog.require('org.apache.flex.html.beads.models.ImageAndTextModel');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.html.TextButton}
 */
org.apache.flex.html.ImageAndTextButton = function() {
  org.apache.flex.html.ImageAndTextButton.base(this, 'constructor');
};
goog.inherits(org.apache.flex.html.ImageAndTextButton, org.apache.flex.html.TextButton);


/**
 * @flexjsignorecoercion org.apache.flex.core.WrappedHTMLElement
 * @protected
 * @override
 */
org.apache.flex.html.ImageAndTextButton.prototype.createElement = function() {
  this.element = document.createElement('button');
  this.element.setAttribute('type', 'button');
  this.positioner = this.element;
  this.positioner.style.position = 'relative';
  this.element.flexjs_wrapper = this;
  return this.element;
};


/**
 * @protected
 */
org.apache.flex.html.ImageAndTextButton.prototype.setInnerHTML = function() {
  var /** @type {string} */ inner = '';
  if (this.image != null)
    inner += "<img src='" + this.image + "'/>";
  inner += '&nbsp;';
  inner += this.text;
  this.element.innerHTML = inner;
};


Object.defineProperties(org.apache.flex.html.ImageAndTextButton.prototype, /** @lends {org.apache.flex.html.ImageAndTextButton.prototype} */ {
/** @export */
text: {
get: /** @this {org.apache.flex.html.ImageAndTextButton} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.html.beads.models.ImageAndTextModel, true).text;
},
set: /** @this {org.apache.flex.html.ImageAndTextButton} */ function(value) {
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.html.beads.models.ImageAndTextModel, true).text = value;
  this.setInnerHTML();
}},
/** @export */
image: {
get: /** @this {org.apache.flex.html.ImageAndTextButton} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.html.beads.models.ImageAndTextModel, true).image;
},
set: /** @this {org.apache.flex.html.ImageAndTextButton} */ function(value) {
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.html.beads.models.ImageAndTextModel, true).image = value;
  this.setInnerHTML();
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.html.ImageAndTextButton.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'ImageAndTextButton', qName: 'org.apache.flex.html.ImageAndTextButton'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.html.ImageAndTextButton', org.apache.flex.html.ImageAndTextButton);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.html.ImageAndTextButton.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'text': { type: 'String', declaredBy: 'org.apache.flex.html.ImageAndTextButton'},
        'image': { type: 'String', declaredBy: 'org.apache.flex.html.ImageAndTextButton'}
      };
    },
    methods: function () {
      return {
        'ImageAndTextButton': { type: '', declaredBy: 'org.apache.flex.html.ImageAndTextButton'}
      };
    }
  };
};