/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/graphics/SolidColorStroke.as
 * org.apache.flex.graphics.SolidColorStroke
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.graphics.SolidColorStroke');

goog.require('org.apache.flex.utils.CSSUtils');
goog.require('org.apache.flex.graphics.IStroke');
goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 * @implements {org.apache.flex.graphics.IStroke}
 * @param {number=} color
 * @param {number=} weight
 * @param {number=} alpha
 */
org.apache.flex.graphics.SolidColorStroke = function(color, weight, alpha) {
  color = typeof color !== 'undefined' ? color : 0x000000;
  weight = typeof weight !== 'undefined' ? weight : 1;
  alpha = typeof alpha !== 'undefined' ? alpha : 1.0;
  this._color = Number(isNaN(color) ? 0 : color);
  this._weight = isNaN(weight) ? 1 : weight;
  this._alpha = isNaN(alpha) ? 1 : alpha;
  
  this._lineCap = "butt";
};


/**
 * @private
 * @type {number}
 */
org.apache.flex.graphics.SolidColorStroke.prototype._alpha = 1.0;


/**
 * @private
 * @type {number}
 */
org.apache.flex.graphics.SolidColorStroke.prototype._color = 0x000000;


/**
 * @private
 * @type {number}
 */
org.apache.flex.graphics.SolidColorStroke.prototype._weight = 1;


/**
 * addStrokeAttrib()
 * 
 * @asparam value The IGraphicShape object on which the stroke must be added.
 * @asreturn {string}
 * @export
 * @param {org.apache.flex.graphics.IGraphicShape} value
 * @return {string}
 */
org.apache.flex.graphics.SolidColorStroke.prototype.addStrokeAttrib = function(value) {
  var /** @type {Array} */ att = ['stroke:' + org.apache.flex.utils.CSSUtils.attributeFromColor(this.color), 'stroke-width:' + this.weight, 'stroke-opacity:' + this.alpha, 'stroke-linecap:' + this.lineCap, 'stroke-linejoin:' + this.lineJoin, 'stroke-miterlimit:' + this.miterLimit];
  if (this.lineDash && this.lineDash.length)
    att.push('stroke-dasharray:' + this.lineDash.join(","));
  return att.join(";");
};


/**
 * @private
 * @type {string}
 */
org.apache.flex.graphics.SolidColorStroke.prototype._lineCap;


/**
 * @private
 * @type {string}
 */
org.apache.flex.graphics.SolidColorStroke.prototype._lineJoin = "miter";


/**
 * @private
 * @type {number}
 */
org.apache.flex.graphics.SolidColorStroke.prototype._miterLimit = 4;


/**
 * @private
 * @type {Array}
 */
org.apache.flex.graphics.SolidColorStroke.prototype._lineDash;


/**
 * @export
 * @param {number=} weight
 * @param {number=} color
 * @param {number=} alpha
 * @param {string=} caps
 * @param {string=} joints
 * @param {number=} miterLimit
 */
org.apache.flex.graphics.SolidColorStroke.prototype.setLineStyle = function(weight, color, alpha, caps, joints, miterLimit) {
  weight = typeof weight !== 'undefined' ? weight : NaN;
  color = typeof color !== 'undefined' ? color : 0;
  alpha = typeof alpha !== 'undefined' ? alpha : NaN;
  caps = typeof caps !== 'undefined' ? caps : null;
  joints = typeof joints !== 'undefined' ? joints : null;
  miterLimit = typeof miterLimit !== 'undefined' ? miterLimit : NaN;
  if (!isNaN(weight))
    this._weight = weight;
  this._color = color;
  if (!isNaN(alpha))
    this._alpha = alpha;
  if (caps)
    this._lineCap = caps;
  if (joints)
    this._lineJoin = joints;
  if (!isNaN(miterLimit))
    this._miterLimit = miterLimit;
};


Object.defineProperties(org.apache.flex.graphics.SolidColorStroke.prototype, /** @lends {org.apache.flex.graphics.SolidColorStroke.prototype} */ {
/** @export */
alpha: {
get: /** @this {org.apache.flex.graphics.SolidColorStroke} */ function() {
  return this._alpha;
},
set: /** @this {org.apache.flex.graphics.SolidColorStroke} */ function(value) {
  var /** @type {number} */ oldValue = this._alpha;
  if (value != oldValue) {
    this._alpha = value;
  }
}},
/** @export */
color: {
get: /** @this {org.apache.flex.graphics.SolidColorStroke} */ function() {
  return this._color;
},
set: /** @this {org.apache.flex.graphics.SolidColorStroke} */ function(value) {
  var /** @type {number} */ oldValue = this._color;
  if (value != oldValue) {
    this._color = value;
  }
}},
/** @export */
weight: {
get: /** @this {org.apache.flex.graphics.SolidColorStroke} */ function() {
  return this._weight;
},
set: /** @this {org.apache.flex.graphics.SolidColorStroke} */ function(value) {
  this._weight = value;
}},
/** @export */
lineCap: {
get: /** @this {org.apache.flex.graphics.SolidColorStroke} */ function() {
  return this._lineCap;
},
set: /** @this {org.apache.flex.graphics.SolidColorStroke} */ function(val) {
  
  this._lineCap = val;
}},
/** @export */
lineJoin: {
get: /** @this {org.apache.flex.graphics.SolidColorStroke} */ function() {
  return this._lineJoin;
},
set: /** @this {org.apache.flex.graphics.SolidColorStroke} */ function(val) {
  this._lineJoin = val;
}},
/** @export */
miterLimit: {
get: /** @this {org.apache.flex.graphics.SolidColorStroke} */ function() {
  return this._miterLimit;
},
set: /** @this {org.apache.flex.graphics.SolidColorStroke} */ function(val) {
  this._miterLimit = val;
}},
/** @export */
lineDash: {
get: /** @this {org.apache.flex.graphics.SolidColorStroke} */ function() {
  return this._lineDash;
},
set: /** @this {org.apache.flex.graphics.SolidColorStroke} */ function(val) {
  this._lineDash = val;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.graphics.SolidColorStroke.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'SolidColorStroke', qName: 'org.apache.flex.graphics.SolidColorStroke'}], interfaces: [org.apache.flex.graphics.IStroke] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.graphics.SolidColorStroke', org.apache.flex.graphics.SolidColorStroke);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.graphics.SolidColorStroke.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'alpha': { type: 'Number', declaredBy: 'org.apache.flex.graphics.SolidColorStroke'},
        'color': { type: 'uint', declaredBy: 'org.apache.flex.graphics.SolidColorStroke'},
        'weight': { type: 'Number', declaredBy: 'org.apache.flex.graphics.SolidColorStroke'},
        'lineCap': { type: 'String', declaredBy: 'org.apache.flex.graphics.SolidColorStroke'},
        'lineJoin': { type: 'String', declaredBy: 'org.apache.flex.graphics.SolidColorStroke'},
        'miterLimit': { type: 'Number', declaredBy: 'org.apache.flex.graphics.SolidColorStroke'},
        'lineDash': { type: 'Array', declaredBy: 'org.apache.flex.graphics.SolidColorStroke'}
      };
    },
    methods: function () {
      return {
        'SolidColorStroke': { type: '', declaredBy: 'org.apache.flex.graphics.SolidColorStroke'},
        'addStrokeAttrib': { type: 'String', declaredBy: 'org.apache.flex.graphics.SolidColorStroke'},
        'setLineStyle': { type: 'void', declaredBy: 'org.apache.flex.graphics.SolidColorStroke'}
      };
    }
  };
};