/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/graphics/GradientEntry.as
 * org.apache.flex.graphics.GradientEntry
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.graphics.GradientEntry');

goog.require('org.apache.flex.utils.Language');



/**
 * @constructor
 * @param {number=} alpha
 * @param {number=} color
 * @param {number=} ratio
 */
org.apache.flex.graphics.GradientEntry = function(alpha, color, ratio) {
  alpha = typeof alpha !== 'undefined' ? alpha : 1.0;
  color = typeof color !== 'undefined' ? color : 0x000000;
  ratio = typeof ratio !== 'undefined' ? ratio : 1.0;
  this._alpha = alpha;
  this._color = color;
  this._ratio = ratio;
};


/**
 * @private
 * @type {number}
 */
org.apache.flex.graphics.GradientEntry.prototype._alpha = 1.0;


/**
 * @private
 * @type {number}
 */
org.apache.flex.graphics.GradientEntry.prototype._color = 0x000000;


/**
 * @private
 * @type {number}
 */
org.apache.flex.graphics.GradientEntry.prototype._ratio = 0x000000;


/**
 * Begin drawing the fill on the given shape's graphic object
 * @export
 * @param {org.apache.flex.graphics.IGraphicShape} s
 */
org.apache.flex.graphics.GradientEntry.prototype.begin = function(s) {
  
};


/**
 * End the fill
 * @export
 * @param {org.apache.flex.graphics.IGraphicShape} s
 */
org.apache.flex.graphics.GradientEntry.prototype.end = function(s) {
  
};


Object.defineProperties(org.apache.flex.graphics.GradientEntry.prototype, /** @lends {org.apache.flex.graphics.GradientEntry.prototype} */ {
/** @export */
alpha: {
get: /** @this {org.apache.flex.graphics.GradientEntry} */ function() {
  return this._alpha;
},
set: /** @this {org.apache.flex.graphics.GradientEntry} */ function(value) {
  var /** @type {number} */ oldValue = this._alpha;
  if (value != oldValue) {
    this._alpha = value;
  }
}},
/** @export */
color: {
get: /** @this {org.apache.flex.graphics.GradientEntry} */ function() {
  return this._color;
},
set: /** @this {org.apache.flex.graphics.GradientEntry} */ function(value) {
  var /** @type {number} */ oldValue = this._color;
  if (value != oldValue) {
    this._color = value;
  }
}},
/** @export */
ratio: {
get: /** @this {org.apache.flex.graphics.GradientEntry} */ function() {
  return this._ratio;
},
set: /** @this {org.apache.flex.graphics.GradientEntry} */ function(value) {
  this._ratio = value;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.graphics.GradientEntry.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'GradientEntry', qName: 'org.apache.flex.graphics.GradientEntry'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.graphics.GradientEntry', org.apache.flex.graphics.GradientEntry);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.graphics.GradientEntry.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'alpha': { type: 'Number', declaredBy: 'org.apache.flex.graphics.GradientEntry'},
        'color': { type: 'uint', declaredBy: 'org.apache.flex.graphics.GradientEntry'},
        'ratio': { type: 'Number', declaredBy: 'org.apache.flex.graphics.GradientEntry'}
      };
    },
    methods: function () {
      return {
        'GradientEntry': { type: '', declaredBy: 'org.apache.flex.graphics.GradientEntry'},
        'begin': { type: 'void', declaredBy: 'org.apache.flex.graphics.GradientEntry'},
        'end': { type: 'void', declaredBy: 'org.apache.flex.graphics.GradientEntry'}
      };
    }
  };
};