/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/flat/DropDownList.as
 * org.apache.flex.flat.DropDownList
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.flat.DropDownList');

goog.require('goog.events');
goog.require('org.apache.flex.core.ListBase');
goog.require('org.apache.flex.html.beads.models.ArraySelectionModel');
goog.require('org.apache.flex.utils.CSSUtils');
goog.require('org.apache.flex.core.ISelectionModel');
goog.require('org.apache.flex.utils.Language');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.core.ListBase}
 */
org.apache.flex.flat.DropDownList = function() {
  org.apache.flex.flat.DropDownList.base(this, 'constructor');
  this.model = new org.apache.flex.html.beads.models.ArraySelectionModel();
};
goog.inherits(org.apache.flex.flat.DropDownList, org.apache.flex.core.ListBase);


/**
 * @private
 * @type {HTMLSpanElement}
 */
org.apache.flex.flat.DropDownList.prototype.label;


/**
 * @private
 * @type {HTMLButtonElement}
 */
org.apache.flex.flat.DropDownList.prototype.button;


/**
 * @private
 * @type {HTMLSpanElement}
 */
org.apache.flex.flat.DropDownList.prototype.caret;


/**
 * @private
 * @type {HTMLUListElement}
 */
org.apache.flex.flat.DropDownList.prototype.menu;


/**
 * @flexjsignorecoercion org.apache.flex.core.WrappedHTMLElement
 * @flexjsignorecoercion HTMLButtonElement
 * @flexjsignorecoercion HTMLDivElement
 * @flexjsignorecoercion HTMLSpanElement
 * @protected
 * @override
 */
org.apache.flex.flat.DropDownList.prototype.createElement = function() {
  var /** @type {HTMLButtonElement} */ button;
  var /** @type {HTMLDivElement} */ outer;
  var /** @type {HTMLSpanElement} */ caret;
  this.element = document.createElement('div');
  outer = this.element;
  this.button = button = document.createElement('button');
  button.className = 'dropdown-toggle-open-btn';
  if (this.className)
    button.className += ' ' + this.className;
  goog.events.listen(button, 'click', org.apache.flex.utils.Language.closure(this.buttonClicked, this, 'buttonClicked'));
  outer.appendChild(button);
  this.label = document.createElement('span');
  this.label.className = 'dropdown-label';
  button.appendChild(this.label);
  this.caret = caret = document.createElement('span');
  button.appendChild(caret);
  caret.className = 'dropdown-caret';
  this.positioner = this.element;
  this.positioner.style.position = 'relative';
  goog.events.listen(document, 'click', org.apache.flex.utils.Language.closure(this.dismissPopup, this, 'dismissPopup'));
  button.flexjs_wrapper = this;
  this.element.flexjs_wrapper = this;
  this.label.flexjs_wrapper = this;
  caret.flexjs_wrapper = this;
  return this.element;
};


/**
 * @asparam event The event.
 * @flexjsignorecoercion org.apache.flex.core.UIBase 
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.flat.DropDownList.prototype.selectChanged = function(event) {
  var /** @type {Object} */ select;
  select = event.target;
  this.selectedIndex = parseInt(select.id, 10);
  this.menu.parentNode.removeChild(this.menu);
  this.menu = null;
  this.dispatchEvent('change');
};


/**
 * @asparam event The event.
 * @private
 * @param {org.apache.flex.events.Event=} event
 */
org.apache.flex.flat.DropDownList.prototype.dismissPopup = function(event) {
  event = typeof event !== 'undefined' ? event : null;
  if (this.menu) {
    this.menu.parentNode.removeChild(this.menu);
    this.menu = null;
  }
};


/**
 * @asparam event The event.
 * @flexjsignorecoercion Array
 * @flexjsignorecoercion HTMLButtonElement
 * @flexjsignorecoercion HTMLUListElement
 * @flexjsignorecoercion HTMLLIElement
 * @flexjsignorecoercion HTMLAnchorElement
 * @private
 * @param {org.apache.flex.events.Event} event
 */
org.apache.flex.flat.DropDownList.prototype.buttonClicked = function(event) {
  var /** @type {Array} */ dp;
  var /** @type {number} */ i;
  var /** @type {HTMLButtonElement} */ button;
  var /** @type {number} */ left;
  var /** @type {number} */ n;
  var /** @type {HTMLLIElement} */ opt;
  var /** @type {Array} */ opts;
  var /** @type {HTMLDivElement} */ pn;
  var /** @type {HTMLUListElement} */ select;
  var /** @type {number} */ top;
  var /** @type {number} */ width;
  event.stopPropagation();
  if (this.menu) {
    this.dismissPopup();
    return;
  }
  button = this.element.childNodes.item(0);
  pn = org.apache.flex.utils.Language.as(this.element, HTMLDivElement);
  top = pn.offsetTop + button.offsetHeight;
  left = pn.offsetLeft;
  width = pn.offsetWidth;
  this.menu = select = document.createElement('ul');
  var /** @type {Element} */ el = org.apache.flex.utils.Language.as(this.element, Element);
  var /** @type {Object} */ cv = getComputedStyle(el);
  select.style.width = cv.width;
  goog.events.listen(select, 'click', org.apache.flex.utils.Language.closure(this.selectChanged, this, 'selectChanged'));
  select.className = 'dropdown-menu';
  var /** @type {string} */ lf = this.labelField;
  dp = this.dataProvider;
  n = dp.length;
  for (i = 0; i < n; i++) {
    opt = document.createElement('li');
    opt.style.backgroundColor = 'transparent';
    var /** @type {HTMLAnchorElement} */ ir = document.createElement('a');
    if (lf)
      ir.innerHTML = org.apache.flex.utils.Language.string(dp[i][lf]);
    else
      ir.innerHTML = org.apache.flex.utils.Language.string(dp[i]);
    ir.id = i.toString();
    if (i == this.selectedIndex)
      ir.className = 'dropdown-menu-item-renderer-selected';
    else
      ir.className = 'dropdown-menu-item-renderer';
    opt.appendChild(ir);
    select.appendChild(opt);
  }
  this.element.appendChild(select);
};


/**
 * @export
 * @override
 */
org.apache.flex.flat.DropDownList.prototype.addedToParent = function() {
  org.apache.flex.flat.DropDownList.base(this, 'addedToParent');
  var /** @type {Element} */ el = org.apache.flex.utils.Language.as(this.button, Element);
  var /** @type {Object} */ cv = getComputedStyle(el);
  var /** @type {string} */ s = org.apache.flex.utils.Language.string(cv.paddingLeft);
  var /** @type {number} */ pl = org.apache.flex.utils.CSSUtils.toNumber(s);
  s = org.apache.flex.utils.Language.string(cv.paddingRight);
  var /** @type {number} */ pr = org.apache.flex.utils.CSSUtils.toNumber(s);
  s = org.apache.flex.utils.Language.string(cv.borderLeftWidth);
  var /** @type {number} */ bl = org.apache.flex.utils.CSSUtils.toNumber(s);
  s = org.apache.flex.utils.Language.string(cv.borderRightWidth);
  var /** @type {number} */ br = org.apache.flex.utils.CSSUtils.toNumber(s);
  var /** @type {number} */ caretWidth = this.caret.offsetWidth;
  var /** @type {number} */ fluff = pl + pr + bl + br + caretWidth + 1 + 10;
  var /** @type {number} */ labelWidth = this.width - fluff;
  var /** @type {string} */ strWidth = labelWidth.toString();
  strWidth += 'px';
  this.label.style.width = strWidth;
};


Object.defineProperties(org.apache.flex.flat.DropDownList.prototype, /** @lends {org.apache.flex.flat.DropDownList.prototype} */ {
/** @export */
className: {
get: /** @this {org.apache.flex.flat.DropDownList} */ function() {
return org.apache.flex.utils.Language.superGetter(org.apache.flex.flat.DropDownList, this, 'className');
},
set: /** @this {org.apache.flex.flat.DropDownList} */ function(value) {
  org.apache.flex.utils.Language.superSetter(org.apache.flex.flat.DropDownList, this, 'className', value);
  if (this.button) {
    this.button.className = this.typeNames ? value + ' ' + 'dropdown-toggle-open-btn' + ' ' + this.typeNames : value + ' ' + 'dropdown-toggle-open-btn';
  }
}},
/** @export */
dataProvider: {
get: /** @this {org.apache.flex.flat.DropDownList} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.ISelectionModel, true).dataProvider;
},
set: /** @this {org.apache.flex.flat.DropDownList} */ function(value) {
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.ISelectionModel, true).dataProvider = value;
}},
/** @export */
labelField: {
get: /** @this {org.apache.flex.flat.DropDownList} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.ISelectionModel, true).labelField;
},
set: /** @this {org.apache.flex.flat.DropDownList} */ function(value) {
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.ISelectionModel, true).labelField = value;
}},
/** @export */
selectedIndex: {
get: /** @this {org.apache.flex.flat.DropDownList} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.ISelectionModel, true).selectedIndex;
},
set: /** @this {org.apache.flex.flat.DropDownList} */ function(value) {
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.ISelectionModel, true).selectedIndex = value;
  var /** @type {string} */ lf = this.labelField;
  if (lf)
    this.label.innerHTML = this.selectedItem[lf];
  else
    this.label.innerHTML = this.selectedItem;
}},
/** @export */
selectedItem: {
get: /** @this {org.apache.flex.flat.DropDownList} */ function() {
  return org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.ISelectionModel, true).selectedItem;
},
set: /** @this {org.apache.flex.flat.DropDownList} */ function(value) {
  org.apache.flex.utils.Language.as(this.model, org.apache.flex.core.ISelectionModel, true).selectedItem = value;
  var /** @type {string} */ lf = this.labelField;
  if (lf)
    this.label.innerHTML = this.selectedItem[lf];
  else
    this.label.innerHTML = this.selectedItem;
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.flat.DropDownList.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'DropDownList', qName: 'org.apache.flex.flat.DropDownList'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.flat.DropDownList', org.apache.flex.flat.DropDownList);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.flat.DropDownList.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'className': { type: 'String', declaredBy: 'org.apache.flex.flat.DropDownList'},
        'dataProvider': { type: 'Object', declaredBy: 'org.apache.flex.flat.DropDownList'},
        'labelField': { type: 'String', declaredBy: 'org.apache.flex.flat.DropDownList'},
        'selectedIndex': { type: 'int', declaredBy: 'org.apache.flex.flat.DropDownList', metadata: function () { return [ { name: 'Bindable', args: [ { key: '', value: 'change'}]}]; }},
        'selectedItem': { type: 'Object', declaredBy: 'org.apache.flex.flat.DropDownList', metadata: function () { return [ { name: 'Bindable', args: [ { key: '', value: 'change'}]}]; }}
      };
    },
    methods: function () {
      return {
        'DropDownList': { type: '', declaredBy: 'org.apache.flex.flat.DropDownList'},
        'addedToParent': { type: 'void', declaredBy: 'org.apache.flex.flat.DropDownList'}
      };
    }
  };
};