/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/charts/supportClasses/ChartAxisGroup.as
 * org.apache.flex.charts.supportClasses.ChartAxisGroup
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.charts.supportClasses.ChartAxisGroup');

goog.require('org.apache.flex.core.UIBase');
goog.require('org.apache.flex.html.Label');
goog.require('org.apache.flex.svg.Path');
goog.require('org.apache.flex.charts.core.IAxisGroup');
goog.require('org.apache.flex.core.IChrome');
goog.require('org.apache.flex.utils.Language');



/**
 * Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.core.UIBase}
 * @implements {org.apache.flex.charts.core.IAxisGroup}
 * @implements {org.apache.flex.core.IChrome}
 */
org.apache.flex.charts.supportClasses.ChartAxisGroup = function() {
  org.apache.flex.charts.supportClasses.ChartAxisGroup.base(this, 'constructor');
};
goog.inherits(org.apache.flex.charts.supportClasses.ChartAxisGroup, org.apache.flex.core.UIBase);


/**
 * Removes all of the items in the group.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 */
org.apache.flex.charts.supportClasses.ChartAxisGroup.prototype.removeAllElements = function() {
  
  var /** @type {Object} */ svg = this.element;
  while (svg.lastChild) {
    svg.removeChild(svg.lastChild);
  }
};


/**
 * Draws a horizontal tick label centered in the box at the given position.
 * 
 * @asparam text The label to display.
 * @asparam xpos The x position of the label's upper left corner.
 * @asparam ypos The y position of the label's upper left corner.
 * @asparam boxWith The size of the box into which the label should be drawn.
 * @asparam boxHeight The size of the box into which the label should be drawn.
 * @asparam tickFill A fill to use to display the label.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {string} text
 * @param {number} xpos
 * @param {number} ypos
 * @param {number} boxWidth
 * @param {number} boxHeight
 * @param {org.apache.flex.graphics.IFill} tickFill
 * @return {Object}
 */
org.apache.flex.charts.supportClasses.ChartAxisGroup.prototype.drawHorizontalTickLabel = function(text, xpos, ypos, boxWidth, boxHeight, tickFill) {
  var /** @type {org.apache.flex.html.Label} */ label = new org.apache.flex.html.Label();
  label.text = text;
  label.x = xpos - label.width / 2;
  label.y = ypos;
  this.addElement(label);
  return label;
};


/**
 * Draws a vertical tick label centered in the box at the given position.
 * 
 * @asparam text The label to display.
 * @asparam xpos The x position of the label's upper left corner.
 * @asparam ypos The y position of the label's upper left corner.
 * @asparam boxWith The size of the box into which the label should be drawn.
 * @asparam boxHeight The size of the box into which the label should be drawn.
 * @asparam tickFill A fill to use to display the label.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {string} text
 * @param {number} xpos
 * @param {number} ypos
 * @param {number} boxWidth
 * @param {number} boxHeight
 * @param {org.apache.flex.graphics.IFill} tickFill
 * @return {Object}
 */
org.apache.flex.charts.supportClasses.ChartAxisGroup.prototype.drawVerticalTickLabel = function(text, xpos, ypos, boxWidth, boxHeight, tickFill) {
  var /** @type {org.apache.flex.html.Label} */ label = new org.apache.flex.html.Label();
  label.text = text;
  label.x = xpos;
  label.y = ypos - label.height / 2;
  this.addElement(label);
  return label;
};


/**
 * Draws an set of tick marks are determined in the marks path.
 * 
 * @asparam originX The upper left corner of the space into which the tick marks are drawn.
 * @asparam originY The upper left corner of the space into which the tick marks are drawn.
 * @asparam width The size of the box into which the tick marks are drawn.
 * @asparam height The size of the box into which the tick marks are drawn.
 * @asparam tickStroke The stroke to use to display the tick marks.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {number} originX
 * @param {number} originY
 * @param {number} width
 * @param {number} height
 * @param {string} marks
 * @param {org.apache.flex.graphics.IStroke} tickStroke
 */
org.apache.flex.charts.supportClasses.ChartAxisGroup.prototype.drawTickMarks = function(originX, originY, width, height, marks, tickStroke) {
  var /** @type {org.apache.flex.svg.Path} */ tickPath = new org.apache.flex.svg.Path();
  tickPath.x = 0;
  tickPath.y = 0;
  tickPath.width = this.width;
  tickPath.height = this.height;
  this.addElement(tickPath);
  tickPath.stroke = tickStroke;
  tickPath.drawStringPath(0, 0, marks);
};


/**
 * Draws the axis line at the given position.
 * 
 * @asparam originX The upper left corner of the space into which the axis line is drawn.
 * @asparam originY The upper left corner of the space into which the axis line is drawn.
 * @asparam width The size of the box into which the line is drawn.
 * @asparam height The size of the box into which the line is drawn.
 * @asparam lineStroke The stroke to use to display the line.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @export
 * @param {number} originX
 * @param {number} originY
 * @param {number} width
 * @param {number} height
 * @param {org.apache.flex.graphics.IStroke} lineStroke
 */
org.apache.flex.charts.supportClasses.ChartAxisGroup.prototype.drawAxisLine = function(originX, originY, width, height, lineStroke) {
  var /** @type {org.apache.flex.svg.Path} */ axisPath = new org.apache.flex.svg.Path();
  axisPath.x = 0;
  axisPath.y = 0;
  axisPath.width = this.width;
  axisPath.height = this.height;
  this.addElement(axisPath);
  axisPath.stroke = lineStroke;
  var /** @type {string} */ pathLine = "M " + originX + " " + originY + " l " + width + " " + height;
  axisPath.drawStringPath(0, 0, pathLine);
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.charts.supportClasses.ChartAxisGroup.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'ChartAxisGroup', qName: 'org.apache.flex.charts.supportClasses.ChartAxisGroup'}], interfaces: [org.apache.flex.charts.core.IAxisGroup, org.apache.flex.core.IChrome] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.charts.supportClasses.ChartAxisGroup', org.apache.flex.charts.supportClasses.ChartAxisGroup);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.charts.supportClasses.ChartAxisGroup.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'ChartAxisGroup': { type: '', declaredBy: 'org.apache.flex.charts.supportClasses.ChartAxisGroup'},
        'removeAllElements': { type: 'void', declaredBy: 'org.apache.flex.charts.supportClasses.ChartAxisGroup'},
        'drawHorizontalTickLabel': { type: 'Object', declaredBy: 'org.apache.flex.charts.supportClasses.ChartAxisGroup'},
        'drawVerticalTickLabel': { type: 'Object', declaredBy: 'org.apache.flex.charts.supportClasses.ChartAxisGroup'},
        'drawTickMarks': { type: 'void', declaredBy: 'org.apache.flex.charts.supportClasses.ChartAxisGroup'},
        'drawAxisLine': { type: 'void', declaredBy: 'org.apache.flex.charts.supportClasses.ChartAxisGroup'}
      };
    }
  };
};