/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from org/apache/flex/charts/optimized/SVGWedgeItemRenderer.as
 * org.apache.flex.charts.optimized.SVGWedgeItemRenderer
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.flex.charts.optimized.SVGWedgeItemRenderer');

goog.require('org.apache.flex.html.supportClasses.DataItemRenderer');
goog.require('org.apache.flex.svg.CompoundGraphic');
goog.require('org.apache.flex.charts.supportClasses.IWedgeItemRenderer');
goog.require('org.apache.flex.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion FlexJS 0.0
 * @constructor
 * @extends {org.apache.flex.html.supportClasses.DataItemRenderer}
 * @implements {org.apache.flex.charts.supportClasses.IWedgeItemRenderer}
 */
org.apache.flex.charts.optimized.SVGWedgeItemRenderer = function() {
  org.apache.flex.charts.optimized.SVGWedgeItemRenderer.base(this, 'constructor');
};
goog.inherits(org.apache.flex.charts.optimized.SVGWedgeItemRenderer, org.apache.flex.html.supportClasses.DataItemRenderer);


/**
 * @private
 * @type {org.apache.flex.charts.core.IChartSeries}
 */
org.apache.flex.charts.optimized.SVGWedgeItemRenderer.prototype._series;


/**
 * @private
 * @type {number}
 */
org.apache.flex.charts.optimized.SVGWedgeItemRenderer.prototype._centerX;


/**
 * @private
 * @type {number}
 */
org.apache.flex.charts.optimized.SVGWedgeItemRenderer.prototype._centerY;


/**
 * @private
 * @type {number}
 */
org.apache.flex.charts.optimized.SVGWedgeItemRenderer.prototype._startAngle;


/**
 * @private
 * @type {number}
 */
org.apache.flex.charts.optimized.SVGWedgeItemRenderer.prototype._arc;


/**
 * @private
 * @type {number}
 */
org.apache.flex.charts.optimized.SVGWedgeItemRenderer.prototype._radius;


/**
 * @private
 * @type {org.apache.flex.graphics.IFill}
 */
org.apache.flex.charts.optimized.SVGWedgeItemRenderer.prototype._fill;


/**
 * @private
 * @type {org.apache.flex.graphics.IStroke}
 */
org.apache.flex.charts.optimized.SVGWedgeItemRenderer.prototype._stroke;


/**
 * @asprivate
 * @private
 */
org.apache.flex.charts.optimized.SVGWedgeItemRenderer.prototype.drawWedgeInternal = function() {
  if (!isNaN(this.centerX) && !isNaN(this.centerY) && !isNaN(this.startAngle) && !isNaN(this.arc) && !isNaN(this.radius)) {
    this.drawWedge(this.centerX, this.centerY, this.startAngle, this.arc, this.radius, this.radius, false);
  }
};


/**
 * @asprivate
 * 
 * Draw a wedge of a circle
 * @asparam graphics      the graphics object to draw into
 * @asparam x             the x center of the circle
 * @asparam y             the y center of the circle
 * @asparam startAngle    start angle (radians)
 * @asparam arc           sweep angle (radians)
 * @asparam radius        radius of the circle
 * @asparam yRadius       vertical radius (or radius if none given)
 * @asparam continueFlag  if true, uses a moveTo call to start drawing at the start point of the circle; else continues drawing using only lineTo and curveTo
 * 
 * @export
 * @param {number} x
 * @param {number} y
 * @param {number} startAngle
 * @param {number} arc
 * @param {number} radius
 * @param {number=} yRadius
 * @param {boolean=} continueFlag
 */
org.apache.flex.charts.optimized.SVGWedgeItemRenderer.prototype.drawWedge = function(x, y, startAngle, arc, radius, yRadius, continueFlag) {
  yRadius = typeof yRadius !== 'undefined' ? yRadius : NaN;
  continueFlag = typeof continueFlag !== 'undefined' ? continueFlag : false;
  var /** @type {org.apache.flex.svg.CompoundGraphic} */ graphicsContainer = org.apache.flex.utils.Language.as(this.itemRendererParent, org.apache.flex.svg.CompoundGraphic);
  var /** @type {number} */ x1 = x + radius * Math.cos(startAngle);
  var /** @type {number} */ y1 = y + radius * Math.sin(startAngle);
  var /** @type {number} */ x2 = x + radius * Math.cos(startAngle + arc);
  var /** @type {number} */ y2 = y + radius * Math.sin(startAngle + arc);
  var /** @type {string} */ pathString = 'M' + x + ' ' + y + ' L' + x1 + ' ' + y1 + ' A' + radius + ' ' + radius + ' 0 0 1 ' + x2 + ' ' + y2 + ' z';
  graphicsContainer.fill = this.fill;
  graphicsContainer.stroke = this.stroke;
  graphicsContainer.drawStringPath(pathString);
};


Object.defineProperties(org.apache.flex.charts.optimized.SVGWedgeItemRenderer.prototype, /** @lends {org.apache.flex.charts.optimized.SVGWedgeItemRenderer.prototype} */ {
/** @export */
series: {
get: /** @this {org.apache.flex.charts.optimized.SVGWedgeItemRenderer} */ function() {
  return this._series;
},
set: /** @this {org.apache.flex.charts.optimized.SVGWedgeItemRenderer} */ function(value) {
  this._series = value;
}},
/** @export */
centerX: {
get: /** @this {org.apache.flex.charts.optimized.SVGWedgeItemRenderer} */ function() {
  return this._centerX;
},
set: /** @this {org.apache.flex.charts.optimized.SVGWedgeItemRenderer} */ function(value) {
  this._centerX = value;
  this.drawWedgeInternal();
}},
/** @export */
centerY: {
get: /** @this {org.apache.flex.charts.optimized.SVGWedgeItemRenderer} */ function() {
  return this._centerY;
},
set: /** @this {org.apache.flex.charts.optimized.SVGWedgeItemRenderer} */ function(value) {
  this._centerY = value;
  this.drawWedgeInternal();
}},
/** @export */
startAngle: {
get: /** @this {org.apache.flex.charts.optimized.SVGWedgeItemRenderer} */ function() {
  return this._startAngle;
},
set: /** @this {org.apache.flex.charts.optimized.SVGWedgeItemRenderer} */ function(value) {
  this._startAngle = value;
  this.drawWedgeInternal();
}},
/** @export */
arc: {
get: /** @this {org.apache.flex.charts.optimized.SVGWedgeItemRenderer} */ function() {
  return this._arc;
},
set: /** @this {org.apache.flex.charts.optimized.SVGWedgeItemRenderer} */ function(value) {
  this._arc = value;
  this.drawWedgeInternal();
}},
/** @export */
radius: {
get: /** @this {org.apache.flex.charts.optimized.SVGWedgeItemRenderer} */ function() {
  return this._radius;
},
set: /** @this {org.apache.flex.charts.optimized.SVGWedgeItemRenderer} */ function(value) {
  this._radius = value;
  this.drawWedgeInternal();
}},
/** @export */
fill: {
get: /** @this {org.apache.flex.charts.optimized.SVGWedgeItemRenderer} */ function() {
  return this._fill;
},
set: /** @this {org.apache.flex.charts.optimized.SVGWedgeItemRenderer} */ function(value) {
  this._fill = value;
}},
/** @export */
stroke: {
get: /** @this {org.apache.flex.charts.optimized.SVGWedgeItemRenderer} */ function() {
  return this._stroke;
},
set: /** @this {org.apache.flex.charts.optimized.SVGWedgeItemRenderer} */ function(value) {
  this._stroke = value;
}},
/** @export */
xField: {
get: /** @this {org.apache.flex.charts.optimized.SVGWedgeItemRenderer} */ function() {
  return null;
},
set: /** @this {org.apache.flex.charts.optimized.SVGWedgeItemRenderer} */ function(value) {
}},
/** @export */
yField: {
get: /** @this {org.apache.flex.charts.optimized.SVGWedgeItemRenderer} */ function() {
  return null;
},
set: /** @this {org.apache.flex.charts.optimized.SVGWedgeItemRenderer} */ function(value) {
}}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.flex.charts.optimized.SVGWedgeItemRenderer.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'SVGWedgeItemRenderer', qName: 'org.apache.flex.charts.optimized.SVGWedgeItemRenderer'}], interfaces: [org.apache.flex.charts.supportClasses.IWedgeItemRenderer] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.flex.charts.optimized.SVGWedgeItemRenderer', org.apache.flex.charts.optimized.SVGWedgeItemRenderer);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.flex.charts.optimized.SVGWedgeItemRenderer.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
        'series': { type: 'IChartSeries', declaredBy: 'org.apache.flex.charts.optimized.SVGWedgeItemRenderer'},
        'centerX': { type: 'Number', declaredBy: 'org.apache.flex.charts.optimized.SVGWedgeItemRenderer'},
        'centerY': { type: 'Number', declaredBy: 'org.apache.flex.charts.optimized.SVGWedgeItemRenderer'},
        'startAngle': { type: 'Number', declaredBy: 'org.apache.flex.charts.optimized.SVGWedgeItemRenderer'},
        'arc': { type: 'Number', declaredBy: 'org.apache.flex.charts.optimized.SVGWedgeItemRenderer'},
        'radius': { type: 'Number', declaredBy: 'org.apache.flex.charts.optimized.SVGWedgeItemRenderer'},
        'fill': { type: 'IFill', declaredBy: 'org.apache.flex.charts.optimized.SVGWedgeItemRenderer'},
        'stroke': { type: 'IStroke', declaredBy: 'org.apache.flex.charts.optimized.SVGWedgeItemRenderer'},
        'xField': { type: 'String', declaredBy: 'org.apache.flex.charts.optimized.SVGWedgeItemRenderer'},
        'yField': { type: 'String', declaredBy: 'org.apache.flex.charts.optimized.SVGWedgeItemRenderer'}
      };
    },
    methods: function () {
      return {
        'SVGWedgeItemRenderer': { type: '', declaredBy: 'org.apache.flex.charts.optimized.SVGWedgeItemRenderer'},
        'drawWedge': { type: 'void', declaredBy: 'org.apache.flex.charts.optimized.SVGWedgeItemRenderer'}
      };
    }
  };
};