/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from google/maps/geometry/spherical.as
 * google.maps.geometry.spherical
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('google.maps.geometry.spherical');



/**
 * @see [google_maps_api_v3_11]
 * @constructor
 */
google.maps.geometry.spherical = function() {
};


/**
 * @asparam from [(google.maps.LatLng|null)] 
 * @asparam distance [number] 
 * @asparam heading [number] 
 * @asparam opt_radius [(number|undefined)] 
 * @see [google_maps_api_v3_11]
 * @asreturns {(google.maps.LatLng|null)} 
 * @export
 * @param {google.maps.LatLng} from
 * @param {number} distance
 * @param {number} heading
 * @param {number=} opt_radius
 * @return {google.maps.LatLng}
 */
google.maps.geometry.spherical.computeOffset = function(from, distance, heading, opt_radius) {
  opt_radius = typeof opt_radius !== 'undefined' ? opt_radius : 0;
  return null;
};


/**
 * @asparam from [(google.maps.LatLng|null)] 
 * @asparam to [(google.maps.LatLng|null)] 
 * @asparam opt_radius [(number|undefined)] 
 * @see [google_maps_api_v3_11]
 * @asreturns {number} 
 * @export
 * @param {google.maps.LatLng} from
 * @param {google.maps.LatLng} to
 * @param {number=} opt_radius
 * @return {number}
 */
google.maps.geometry.spherical.computeDistanceBetween = function(from, to, opt_radius) {
  opt_radius = typeof opt_radius !== 'undefined' ? opt_radius : 0;
  return 0;
};


/**
 * @asparam to [(google.maps.LatLng|null)] 
 * @asparam distance [number] 
 * @asparam heading [number] 
 * @asparam opt_radius [(number|undefined)] 
 * @see [google_maps_api_v3_11]
 * @asreturns {(google.maps.LatLng|null)} 
 * @export
 * @param {google.maps.LatLng} to
 * @param {number} distance
 * @param {number} heading
 * @param {number=} opt_radius
 * @return {google.maps.LatLng}
 */
google.maps.geometry.spherical.computeOffsetOrigin = function(to, distance, heading, opt_radius) {
  opt_radius = typeof opt_radius !== 'undefined' ? opt_radius : 0;
  return null;
};


/**
 * @asparam from [(google.maps.LatLng|null)] 
 * @asparam to [(google.maps.LatLng|null)] 
 * @asparam fraction [number] 
 * @see [google_maps_api_v3_11]
 * @asreturns {(google.maps.LatLng|null)} 
 * @export
 * @param {google.maps.LatLng} from
 * @param {google.maps.LatLng} to
 * @param {number} fraction
 * @return {google.maps.LatLng}
 */
google.maps.geometry.spherical.interpolate = function(from, to, fraction) {
  return null;
};


/**
 * @asparam path [(Array<(google.maps.LatLng|null)>|google.maps.MVCArray|null)] 
 * @asparam opt_radius [(number|undefined)] 
 * @see [google_maps_api_v3_11]
 * @asreturns {number} 
 * @export
 * @param {Object} path
 * @param {number=} opt_radius
 * @return {number}
 */
google.maps.geometry.spherical.computeLength = function(path, opt_radius) {
  opt_radius = typeof opt_radius !== 'undefined' ? opt_radius : 0;
  return 0;
};


/**
 * @asparam loop [(Array<(google.maps.LatLng|null)>|google.maps.MVCArray|null)] 
 * @asparam opt_radius [(number|undefined)] 
 * @see [google_maps_api_v3_11]
 * @asreturns {number} 
 * @export
 * @param {Object} loop
 * @param {number=} opt_radius
 * @return {number}
 */
google.maps.geometry.spherical.computeSignedArea = function(loop, opt_radius) {
  opt_radius = typeof opt_radius !== 'undefined' ? opt_radius : 0;
  return 0;
};


/**
 * @asparam from [(google.maps.LatLng|null)] 
 * @asparam to [(google.maps.LatLng|null)] 
 * @see [google_maps_api_v3_11]
 * @asreturns {number} 
 * @export
 * @param {google.maps.LatLng} from
 * @param {google.maps.LatLng} to
 * @return {number}
 */
google.maps.geometry.spherical.computeHeading = function(from, to) {
  return 0;
};


/**
 * @asparam path [(Array<(google.maps.LatLng|null)>|google.maps.MVCArray|null)] 
 * @asparam opt_radius [(number|undefined)] 
 * @see [google_maps_api_v3_11]
 * @asreturns {number} 
 * @export
 * @param {Object} path
 * @param {number=} opt_radius
 * @return {number}
 */
google.maps.geometry.spherical.computeArea = function(path, opt_radius) {
  opt_radius = typeof opt_radius !== 'undefined' ? opt_radius : 0;
  return 0;
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
google.maps.geometry.spherical.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'spherical', qName: 'google.maps.geometry.spherical'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('google.maps.geometry.spherical', google.maps.geometry.spherical);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
google.maps.geometry.spherical.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'spherical': { type: 'void', declaredBy: 'google.maps.geometry.spherical'}
      };
    }
  };
};