/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from google/maps/event.as
 * google.maps.event
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('google.maps.event');



/**
 * @see [google_maps_api_v3_11]
 * @constructor
 */
google.maps.event = function() {
};


/**
 * @asparam instance [(Object|null)] 
 * @asparam eventName [string] 
 * @asparam var_args [*] 
 * @see [google_maps_api_v3_11]
 * @asreturns {undefined} 
 * @export
 * @param {Object} instance
 * @param {string} eventName
 * @param {...} var_args
 * @return {Object}
 */
google.maps.event.trigger = function(instance, eventName, var_args) {
  var_args = Array.prototype.slice.call(arguments, 2);
  return null;
};


/**
 * @asparam instance [(Object|null)] 
 * @see [google_maps_api_v3_11]
 * @asreturns {undefined} 
 * @export
 * @param {Object} instance
 * @return {Object}
 */
google.maps.event.clearInstanceListeners = function(instance) {
  return null;
};


/**
 * @asparam instance [(Object|null)] 
 * @asparam eventName [string] 
 * @asparam handler [Function] 
 * @asparam opt_capture [(boolean|undefined)] 
 * @see [google_maps_api_v3_11]
 * @asreturns {(google.maps.MapsEventListener|null)} 
 * @export
 * @param {Object} instance
 * @param {string} eventName
 * @param {Function} handler
 * @param {boolean=} opt_capture
 * @return {google.maps.MapsEventListener}
 */
google.maps.event.addDomListenerOnce = function(instance, eventName, handler, opt_capture) {
  opt_capture = typeof opt_capture !== 'undefined' ? opt_capture : false;
  return null;
};


/**
 * @asparam listener [(google.maps.MapsEventListener|null)] 
 * @see [google_maps_api_v3_11]
 * @asreturns {undefined} 
 * @export
 * @param {google.maps.MapsEventListener} listener
 * @return {Object}
 */
google.maps.event.removeListener = function(listener) {
  return null;
};


/**
 * @asparam instance [(Object|null)] 
 * @asparam eventName [string] 
 * @asparam handler [Function] 
 * @see [google_maps_api_v3_11]
 * @asreturns {(google.maps.MapsEventListener|null)} 
 * @export
 * @param {Object} instance
 * @param {string} eventName
 * @param {Function} handler
 * @return {google.maps.MapsEventListener}
 */
google.maps.event.addListener = function(instance, eventName, handler) {
  return null;
};


/**
 * @asparam instance [(Object|null)] 
 * @asparam eventName [string] 
 * @asparam handler [Function] 
 * @see [google_maps_api_v3_11]
 * @asreturns {(google.maps.MapsEventListener|null)} 
 * @export
 * @param {Object} instance
 * @param {string} eventName
 * @param {Function} handler
 * @return {google.maps.MapsEventListener}
 */
google.maps.event.addListenerOnce = function(instance, eventName, handler) {
  return null;
};


/**
 * @asparam instance [(Object|null)] 
 * @asparam eventName [string] 
 * @see [google_maps_api_v3_11]
 * @asreturns {undefined} 
 * @export
 * @param {Object} instance
 * @param {string} eventName
 * @return {Object}
 */
google.maps.event.clearListeners = function(instance, eventName) {
  return null;
};


/**
 * @asparam instance [(Object|null)] 
 * @asparam eventName [string] 
 * @asparam handler [Function] 
 * @asparam opt_capture [(boolean|undefined)] 
 * @see [google_maps_api_v3_11]
 * @asreturns {(google.maps.MapsEventListener|null)} 
 * @export
 * @param {Object} instance
 * @param {string} eventName
 * @param {Function} handler
 * @param {boolean=} opt_capture
 * @return {google.maps.MapsEventListener}
 */
google.maps.event.addDomListener = function(instance, eventName, handler, opt_capture) {
  opt_capture = typeof opt_capture !== 'undefined' ? opt_capture : false;
  return null;
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
google.maps.event.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'event', qName: 'google.maps.event'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('google.maps.event', google.maps.event);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
google.maps.event.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'event': { type: 'void', declaredBy: 'google.maps.event'}
      };
    }
  };
};