/**
 * * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Generated by Apache Flex Cross-Compiler from google/maps/Map.as
 * google.maps.Map
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('google.maps.Map');



/**
 * @asparam mapDiv [(Node|null)] 
 * @asparam opt_opts [(Object<?,string>|google.maps.MapOptions|null|undefined)] 
 * @see [google_maps_api_v3_11]
 * @constructor
 * @extends {google.maps.MVCObject}
 * @param {Object} mapDiv
 * @param {Object=} opt_opts
 */
google.maps.Map = function(mapDiv, opt_opts) {
  opt_opts = typeof opt_opts !== 'undefined' ? opt_opts : null;
  google.maps.Map.base(this, 'constructor');
};
goog.inherits(google.maps.Map, google.maps.MVCObject);


/**
 * @export
 * @type {Array}
 */
google.maps.Map.prototype.controls;


/**
 * @export
 * @type {google.maps.MapTypeRegistry}
 */
google.maps.Map.prototype.mapTypes;


/**
 * @export
 * @type {google.maps.MVCArray}
 */
google.maps.Map.prototype.overlayMapTypes;


/**
 * @see [google_maps_api_v3_11]
 * @asreturns {(google.maps.LatLng|null)} 
 * @export
 * @return {google.maps.LatLng}
 */
google.maps.Map.prototype.getCenter = function() {
  return null;
};


/**
 * @see [google_maps_api_v3_11]
 * @asreturns {number} 
 * @export
 * @return {number}
 */
google.maps.Map.prototype.getTilt = function() {
  return 0;
};


/**
 * @see [google_maps_api_v3_11]
 * @asreturns {(Node|null)} 
 * @export
 * @return {Object}
 */
google.maps.Map.prototype.getDiv = function() {
  return null;
};


/**
 * @see [google_maps_api_v3_11]
 * @asreturns {(google.maps.Projection|null)} 
 * @export
 * @return {Object}
 */
google.maps.Map.prototype.getProjection = function() {
  return null;
};


/**
 * @see [google_maps_api_v3_11]
 * @asreturns {number} 
 * @export
 * @return {number}
 */
google.maps.Map.prototype.getHeading = function() {
  return 0;
};


/**
 * @see [google_maps_api_v3_11]
 * @asreturns {(google.maps.MapTypeId|null|string)} 
 * @export
 * @return {Object}
 */
google.maps.Map.prototype.getMapTypeId = function() {
  return null;
};


/**
 * @see [google_maps_api_v3_11]
 * @asreturns {(google.maps.StreetViewPanorama|null)} 
 * @export
 * @return {google.maps.StreetViewPanorama}
 */
google.maps.Map.prototype.getStreetView = function() {
  return null;
};


/**
 * @asparam x [number] 
 * @asparam y [number] 
 * @see [google_maps_api_v3_11]
 * @asreturns {undefined} 
 * @export
 * @param {number} x
 * @param {number} y
 * @return {Object}
 */
google.maps.Map.prototype.panBy = function(x, y) {
  return null;
};


/**
 * @asparam panorama [(google.maps.StreetViewPanorama|null)] 
 * @see [google_maps_api_v3_11]
 * @asreturns {undefined} 
 * @export
 * @param {google.maps.StreetViewPanorama} panorama
 * @return {Object}
 */
google.maps.Map.prototype.setStreetView = function(panorama) {
  return null;
};


/**
 * @asparam bounds [(google.maps.LatLngBounds|null)] 
 * @see [google_maps_api_v3_11]
 * @asreturns {undefined} 
 * @export
 * @param {google.maps.LatLngBounds} bounds
 * @return {Object}
 */
google.maps.Map.prototype.fitBounds = function(bounds) {
  return null;
};


/**
 * @asparam options [(Object<?,string>|google.maps.MapOptions|null)] 
 * @see [google_maps_api_v3_11]
 * @asreturns {undefined} 
 * @export
 * @param {Object} options
 * @return {Object}
 */
google.maps.Map.prototype.setOptions = function(options) {
  return null;
};


/**
 * @asparam zoom [number] 
 * @see [google_maps_api_v3_11]
 * @asreturns {undefined} 
 * @export
 * @param {number} zoom
 * @return {Object}
 */
google.maps.Map.prototype.setZoom = function(zoom) {
  return null;
};


/**
 * @asparam tilt [number] 
 * @see [google_maps_api_v3_11]
 * @asreturns {undefined} 
 * @export
 * @param {number} tilt
 * @return {Object}
 */
google.maps.Map.prototype.setTilt = function(tilt) {
  return null;
};


/**
 * @asparam mapTypeId [(google.maps.MapTypeId|null|string)] 
 * @see [google_maps_api_v3_11]
 * @asreturns {undefined} 
 * @export
 * @param {Object} mapTypeId
 * @return {Object}
 */
google.maps.Map.prototype.setMapTypeId = function(mapTypeId) {
  return null;
};


/**
 * @see [google_maps_api_v3_11]
 * @asreturns {(google.maps.LatLngBounds|null)} 
 * @export
 * @return {google.maps.LatLngBounds}
 */
google.maps.Map.prototype.getBounds = function() {
  return null;
};


/**
 * @see [google_maps_api_v3_11]
 * @asreturns {number} 
 * @export
 * @return {number}
 */
google.maps.Map.prototype.getZoom = function() {
  return 0;
};


/**
 * @asparam latLng [(google.maps.LatLng|null)] 
 * @see [google_maps_api_v3_11]
 * @asreturns {undefined} 
 * @export
 * @param {google.maps.LatLng} latLng
 * @return {Object}
 */
google.maps.Map.prototype.panTo = function(latLng) {
  return null;
};


/**
 * @asparam latLngBounds [(google.maps.LatLngBounds|null)] 
 * @see [google_maps_api_v3_11]
 * @asreturns {undefined} 
 * @export
 * @param {google.maps.LatLngBounds} latLngBounds
 * @return {Object}
 */
google.maps.Map.prototype.panToBounds = function(latLngBounds) {
  return null;
};


/**
 * @asparam heading [number] 
 * @see [google_maps_api_v3_11]
 * @asreturns {undefined} 
 * @export
 * @param {number} heading
 * @return {Object}
 */
google.maps.Map.prototype.setHeading = function(heading) {
  return null;
};


/**
 * @asparam latlng [(google.maps.LatLng|null)] 
 * @see [google_maps_api_v3_11]
 * @asreturns {undefined} 
 * @export
 * @param {google.maps.LatLng} latlng
 * @return {Object}
 */
google.maps.Map.prototype.setCenter = function(latlng) {
  return null;
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
google.maps.Map.prototype.FLEXJS_CLASS_INFO = { names: [{ name: 'Map', qName: 'google.maps.Map'}] };


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('google.maps.Map', google.maps.Map);



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
google.maps.Map.prototype.FLEXJS_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'controls': { type: 'Array'},
        'mapTypes': { type: 'google.maps.MapTypeRegistry'},
        'overlayMapTypes': { type: 'google.maps.MVCArray'}
      };
    },
    accessors: function () {
      return {
      };
    },
    methods: function () {
      return {
        'Map': { type: '', declaredBy: 'google.maps.Map'},
        'getCenter': { type: 'google.maps.LatLng', declaredBy: 'google.maps.Map'},
        'getTilt': { type: 'Number', declaredBy: 'google.maps.Map'},
        'getDiv': { type: 'Object', declaredBy: 'google.maps.Map'},
        'getProjection': { type: 'Object', declaredBy: 'google.maps.Map'},
        'getHeading': { type: 'Number', declaredBy: 'google.maps.Map'},
        'getMapTypeId': { type: 'Object', declaredBy: 'google.maps.Map'},
        'getStreetView': { type: 'google.maps.StreetViewPanorama', declaredBy: 'google.maps.Map'},
        'panBy': { type: 'Object', declaredBy: 'google.maps.Map'},
        'setStreetView': { type: 'Object', declaredBy: 'google.maps.Map'},
        'fitBounds': { type: 'Object', declaredBy: 'google.maps.Map'},
        'setOptions': { type: 'Object', declaredBy: 'google.maps.Map'},
        'setZoom': { type: 'Object', declaredBy: 'google.maps.Map'},
        'setTilt': { type: 'Object', declaredBy: 'google.maps.Map'},
        'setMapTypeId': { type: 'Object', declaredBy: 'google.maps.Map'},
        'getBounds': { type: 'google.maps.LatLngBounds', declaredBy: 'google.maps.Map'},
        'getZoom': { type: 'Number', declaredBy: 'google.maps.Map'},
        'panTo': { type: 'Object', declaredBy: 'google.maps.Map'},
        'panToBounds': { type: 'Object', declaredBy: 'google.maps.Map'},
        'setHeading': { type: 'Object', declaredBy: 'google.maps.Map'},
        'setCenter': { type: 'Object', declaredBy: 'google.maps.Map'}
      };
    }
  };
};