/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.targets;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.flex.compiler.config.RSLSettings;
import org.apache.flex.compiler.projects.ICompilerProject;
import org.apache.flex.compiler.targets.ITargetSettings;
import org.apache.flex.compiler.units.ICompilationUnit;
import org.apache.flex.compiler.workspaces.IWorkspace;

public class LinkageChecker {
    private ICompilerProject project;
    private ITargetSettings targetSettings;
    private Set<String> externs;

    public LinkageChecker(ICompilerProject project, ITargetSettings targetSettings) {
        this.project = project;
        this.targetSettings = targetSettings;
    }

    public boolean isExternal(ICompilationUnit cu) throws InterruptedException {
        List<String> qnames;
        if (this.externs == null) {
            this.initExterns();
        }
        return !(qnames = cu.getQualifiedNames()).isEmpty() && this.externs.contains(qnames.get(0));
    }

    public void initExterns() throws InterruptedException {
        if (this.externs != null) {
            return;
        }
        HashSet<String> foundExterns = new HashSet<String>(4096);
        foundExterns.addAll(this.targetSettings.getExterns());
        IWorkspace w = this.project.getWorkspace();
        ArrayList<File> libraries = new ArrayList<File>(this.targetSettings.getExternalLibraryPath().size() + this.targetSettings.getRuntimeSharedLibraryPath().size());
        libraries.addAll(this.targetSettings.getExternalLibraryPath());
        for (RSLSettings settings : this.targetSettings.getRuntimeSharedLibraryPath()) {
            libraries.add(settings.getLibraryFile());
        }
        for (File library : libraries) {
            Collection<ICompilationUnit> units = null;
            units = w.getCompilationUnits(library.getAbsolutePath(), this.project);
            for (ICompilationUnit unit : units) {
                ICompilationUnit.UnitType type = unit.getCompilationUnitType();
                if (type == ICompilationUnit.UnitType.EMBED_UNIT) continue;
                foundExterns.addAll(unit.getQualifiedNames());
            }
        }
        foundExterns.removeAll(this.targetSettings.getIncludeClasses());
        this.externs = foundExterns;
    }
}

