/** @fileoverview Auto-generated Externs files
 * @externs
 */
/**
 * A Tween instance tweens properties for a single target. Instance methods can be chained for easy construction and sequencing:
 * 
 * <h4>Example</h4>
 * 
 * target.alpha = 1;
 * createjs.createjs.Tween.get(target)
 * .wait(500)
 * .to({alpha:0, visible:false}, 1000)
 * .call(handleComplete);
 * function handleComplete() {
 * //Tween complete
 * }
 * 
 * Multiple tweens can point to the same instance, however if they affect the same properties there could be unexpected
 * behaviour. To stop all tweens on an object, use {{#crossLink "Tween/removeTweens"}}{{/crossLink}} or pass `override:true`
 * in the props argument.
 * 
 * createjs.createjs.Tween.get(target, {override:true}).to({x:100});
 * 
 * Subscribe to the {{#crossLink "Tween/change:event"}}{{/crossLink}} event to get notified when a property of the
 * target is changed.
 * 
 * createjs.createjs.Tween.get(target, {override:true}).to({x:100}).addEventListener("change", handleChange);
 * function handleChange(event) {
 * // The tween changed.
 * }
 * 
 * See the Tween {{#crossLink "Tween/get"}}{{/crossLink}} method for additional param documentation.
 *
 * @see [Tween]
 * @param {(Object|null)} target The target object that will have its properties tweened.
 * @param {Object=} opt_props The configuration properties to apply to this tween instance (ex. `{loop:true, paused:true}`. All properties default to false. Supported props are:<UL> <LI> loop: sets the loop property on this tween.</LI> <LI> useTicks: uses ticks for all durations instead of milliseconds.</LI> <LI> ignoreGlobalPause: sets the {{#crossLink "Tween/ignoreGlobalPause:property"}}{{/crossLink}} property on this tween.</LI> <LI> override: if true, `createjs.Tween.removeTweens(target)` will be called to remove any other tweens with the same target. <LI> paused: indicates whether to start the tween paused.</LI> <LI> position: indicates the initial position for this tween.</LI> <LI> onChange: specifies a listener for the "change" event.</LI> </UL>
 * @param {Object=} opt_pluginData An object containing data for use by installed plugins. See individual plugins' documentation for details.
 * @constructor
 * @extends createjs.EventDispatcher
 */
createjs.Tween = function (target, opt_props, opt_pluginData) {}

    /**
     * Advances all tweens. This typically uses the {{#crossLink "Ticker"}}{{/crossLink}} class, but you can call it
     * manually if you prefer to use your own "heartbeat" implementation.
     *
     * @param {(number|null)} delta The change in time in milliseconds since the last tick. Required unless all tweens have `useTicks` set to true.
     * @param {(boolean|null)} paused Indicates whether a global pause is in effect. Tweens with {{#crossLink "Tween/ignoreGlobalPause:property"}}{{/crossLink}} will ignore this, but all others will pause if this is `true`.
     * @see [Tween]
     */
createjs.Tween.tick = function (delta, paused) {  }

    /**
     * Stop and remove all existing tweens.
     *
     * @see [Tween]
     */
createjs.Tween.removeAllTweens = function () {  }

    /**
     * Returns a new tween instance. This is functionally identical to using "new Tween(...)", but looks cleaner
     * with the chained syntax of TweenJS.
     * <h4>Example</h4>
     * 
     * var tween = createjs.createjs.Tween.get(target);
     *
     * @param {(Object|null)} target The target object that will have its properties tweened.
     * @param {Object=} opt_props The configuration properties to apply to this tween instance (ex. `{loop:true, paused:true}`). All properties default to `false`. Supported props are: <UL> <LI> loop: sets the loop property on this tween.</LI> <LI> useTicks: uses ticks for all durations instead of milliseconds.</LI> <LI> ignoreGlobalPause: sets the {{#crossLink "Tween/ignoreGlobalPause:property"}}{{/crossLink}} property on this tween.</LI> <LI> override: if true, `createjs.createjs.Tween.removeTweens(target)` will be called to remove any other tweens with the same target. <LI> paused: indicates whether to start the tween paused.</LI> <LI> position: indicates the initial position for this tween.</LI> <LI> onChange: specifies a listener for the {{#crossLink "Tween/change:event"}}{{/crossLink}} event.</LI> </UL>
     * @param {Object=} opt_pluginData An object containing data for use by installed plugins. See individual plugins' documentation for details.
     * @param {boolean=} opt_override If true, any previous tweens on the same target will be removed. This is the same as calling `createjs.Tween.removeTweens(target)`.
     * @see [Tween]
     * @returns {(Tween|null)} A reference to the created tween. Additional chained tweens, method calls, or callbacks can be applied to the returned tween instance.
     */
createjs.Tween.get = function (target, opt_props, opt_pluginData, opt_override) {  return null; }

    /**
     * Handle events that result from Tween being used as an event handler. This is included to allow Tween to handle
     * {{#crossLink "Ticker/tick:event"}}{{/crossLink}} events from the createjs {{#crossLink "Ticker"}}{{/crossLink}}.
     * No other events are handled in createjs.Tween.
     *
     * @param {(Object|null)} event An event object passed in by the {{#crossLink "EventDispatcher"}}{{/crossLink}}. Will usually be of type "tick".
     * @see [Tween]
     */
createjs.Tween.handleEvent = function (event) {  }

    /**
     * Indicates whether there are any active tweens (and how many) on the target object (if specified) or in general.
     *
     * @param {Object=} opt_target The target to check for active tweens. If not specified, the return value will indicate if there are any active tweens on any target.
     * @see [Tween]
     * @returns {(boolean|null)} If there are active tweens.
     */
createjs.Tween.hasActiveTweens = function (opt_target) {  return null; }

    /**
     * Installs a plugin, which can modify how certain properties are handled when tweened. See the {{#crossLink "CSSPlugin"}}{{/crossLink}}
     * for an example of how to write TweenJS plugins.
     *
     * @param {(Object|null)} plugin The plugin class to install
     * @param {(Array|null)} properties An array of properties that the plugin will handle.
     * @see [Tween]
     */
createjs.Tween.installPlugin = function (plugin, properties) {  }

    /**
     * Removes all existing tweens for a target. This is called automatically by new tweens if the `override`
     * property is `true`.
     *
     * @param {(Object|null)} target The target object to remove existing tweens from.
     * @see [Tween]
     */
createjs.Tween.removeTweens = function (target) {  }

    /**
     * Registers or unregisters a tween with the ticking system.
     *
     * @param {(Tween|null)} tween The tween instance to register or unregister.
     * @param {(boolean|null)} value If `true`, the tween is registered. If `false` the tween is unregistered.
     * @see [Tween]
     */
createjs.Tween._register = function (tween, value) {  }

    /**
     * @param {(Object|null)} o 
     * @see [Tween]
     */
createjs.Tween.prototype._addAction = function (o) {  }

    /**
     * Queues a tween from the current values to the target properties. Set duration to 0 to jump to these value.
     * Numeric properties will be tweened from their current value in the tween to the target value. Non-numeric
     * properties will be set at the end of the specified duration.
     * <h4>Example</h4>
     * 
     * createjs.createjs.Tween.get(target).to({alpha:0}, 1000);
     *
     * @param {(Object|null)} props An object specifying property target values for this tween (Ex. `{x:300}` would tween the x property of the target to 300).
     * @param {number=} opt_duration The duration of the wait in milliseconds (or in ticks if `useTicks` is true).
     * @param {Function=} opt_ease The easing function to use for this tween. See the {{#crossLink "Ease"}}{{/crossLink}} class for a list of built-in ease functions.
     * @see [Tween]
     * @returns {(Tween|null)} This tween instance (for chaining calls).
     */
createjs.Tween.prototype.to = function (props, opt_duration, opt_ease) {  return null; }

    /**
     * Queues an action to call the specified function.
     * <h4>Example</h4>
     * 
     * //would call myFunction() after 1 second.
     * mycreatejs.Tween.wait(1000).call(myFunction);
     *
     * @param {(Function|null)} callback The function to call.
     * @param {Array=} opt_params . The parameters to call the function with. If this is omitted, then the function will be called with a single param pointing to this tween.
     * @param {Object=} opt_scope . The scope to call the function in. If omitted, it will be called in the target's scope.
     * @see [Tween]
     * @returns {(Tween|null)} This tween instance (for chaining calls).
     */
createjs.Tween.prototype.call = function (callback, opt_params, opt_scope) {  return null; }

    /**
     * @see [Tween]
     */
createjs.Tween.prototype.clone = function () {  }

    /**
     * @param {(Object|null)} o 
     * @see [Tween]
     */
createjs.Tween.prototype._appendQueueProps = function (o) {  }

    /**
     * @param {(number|null)} startPos 
     * @param {(number|null)} endPos 
     * @param {(boolean|null)} includeStart 
     * @see [Tween]
     */
createjs.Tween.prototype._runActions = function (startPos, endPos, includeStart) {  }

    /**
     * Queues an action to set the specified props on the specified target. If target is null, it will use this tween's
     * target.
     * <h4>Example</h4>
     * 
     * mycreatejs.Tween.wait(1000).set({visible:false},foo);
     *
     * @param {(Object|null)} props The properties to set (ex. `{visible:false}`).
     * @param {Object=} opt_target The target to set the properties on. If omitted, they will be set on the tween's target.
     * @see [Tween]
     * @returns {(Tween|null)} This tween instance (for chaining calls).
     */
createjs.Tween.prototype.set = function (props, opt_target) {  return null; }

    /**
     * Queues an action to play (unpause) the specified tween. This enables you to sequence multiple tweens.
     * <h4>Example</h4>
     * 
     * mycreatejs.Tween.to({x:100},500).play(otherTween);
     *
     * @param {(Tween|null)} tween The tween to play.
     * @see [Tween]
     * @returns {(Tween|null)} This tween instance (for chaining calls).
     */
createjs.Tween.prototype.play = function (tween) {  return null; }

    /**
     * Advances the tween to a specified position.
     *
     * @param {(number|null)} value The position to seek to in milliseconds (or ticks if useTicks is true).
     * @param {number=} opt_actionsMode Specifies how actions are handled (ie. call, set, play, pause): <ul> <li>{{#crossLink "Tween/NONE:property"}}{{/crossLink}} (0) - run no actions.</li> <li>{{#crossLink "Tween/LOOP:property"}}{{/crossLink}} (1) - if new position is less than old, then run all actions between old and duration, then all actions between 0 and new.</li> <li>{{#crossLink "Tween/REVERSE:property"}}{{/crossLink}} (2) - if new position is less than old, run all actions between them in reverse.</li> </ul>
     * @see [Tween]
     * @returns {(boolean|null)} Returns `true` if the tween is complete (ie. the full tween has run & {{#crossLink "Tween/loop:property"}}{{/crossLink}} is `false`).
     */
createjs.Tween.prototype.setPosition = function (value, opt_actionsMode) {  return null; }

    /**
     * @param {(Object|null)} props 
     * @param {(Object|null)} o 
     * @see [Tween]
     */
createjs.Tween.prototype._set = function (props, o) {  }

    /**
     * Queues a wait (essentially an empty tween).
     * <h4>Example</h4>
     * 
     * //This tween will wait 1s before alpha is faded to 0.
     * createjs.createjs.Tween.get(target).wait(1000).to({alpha:0}, 1000);
     *
     * @param {(number|null)} duration The duration of the wait in milliseconds (or in ticks if `useTicks` is true).
     * @param {boolean=} opt_passive Tween properties will not be updated during a passive wait. This is mostly useful for use with {{#crossLink "Timeline"}}{{/crossLink}} instances that contain multiple tweens affecting the same target at different times.
     * @see [Tween]
     * @returns {(Tween|null)} This tween instance (for chaining calls).
     */
createjs.Tween.prototype.wait = function (duration, opt_passive) {  return null; }

    /**
     * Pauses or plays this tween.
     *
     * @param {boolean=} opt_value Indicates whether the tween should be paused (`true`) or played (`false`).
     * @see [Tween]
     * @returns {(Tween|null)} This tween instance (for chaining calls)
     */
createjs.Tween.prototype.setPaused = function (opt_value) {  return null; }

    /**
     * Queues an action to pause the specified tween.
     *
     * @param {(Tween|null)} tween The tween to pause. If null, it pauses this tween.
     * @see [Tween]
     * @returns {(Tween|null)} This tween instance (for chaining calls)
     */
createjs.Tween.prototype.pause = function (tween) {  return null; }

    /**
     * @param {(Object|null)} step 
     * @param {(number|null)} ratio 
     * @see [Tween]
     */
createjs.Tween.prototype._updateTargetProps = function (step, ratio) {  }

    /**
     * Advances this tween by the specified amount of time in milliseconds (or ticks if`useTicks` is `true`).
     * This is normally called automatically by the Tween engine (via {{#crossLink "Tween/tick"}}{{/crossLink}}), but is
     * exposed for advanced uses.
     *
     * @param {(number|null)} delta The time to advance in milliseconds (or ticks if `useTicks` is `true`).
     * @see [Tween]
     */
createjs.Tween.prototype.tick = function (delta) {  }

    /**
     * @param {(Object|null)} props 
     * @see [Tween]
     */
createjs.Tween.prototype._cloneProps = function (props) {  }


    /**
     * @param {(Object|null)} o 
     * @see [Tween]
     */
createjs.Tween.prototype._addStep = function (o) {  }

