/** @fileoverview Auto-generated Externs files
 * @externs
 */
/**
 * The Timeline class synchronizes multiple tweens and allows them to be controlled as a group. Please note that if a
 * timeline is looping, the tweens on it may appear to loop even if the "loop" property of the tween is false.
 *
 * @see [Timeline]
 * @param {(Array|null)} tweens An array of Tweens to add to this timeline. See {{#crossLink "Timeline/addTween"}}{{/crossLink}} for more info.
 * @param {(Object|null)} labels An object defining labels for using {{#crossLink "Timeline/gotoAndPlay"}}{{/crossLink}}/{{#crossLink "Timeline/gotoAndStop"}}{{/crossLink}}. See {{#crossLink "Timeline/setLabels"}}{{/crossLink}} for details.
 * @param {(Object|null)} props The configuration properties to apply to this tween instance (ex. `{loop:true}`). All properties default to false. Supported props are:<UL> <LI> loop: sets the loop property on this tween.</LI> <LI> useTicks: uses ticks for all durations instead of milliseconds.</LI> <LI> ignoreGlobalPause: sets the ignoreGlobalPause property on this tween.</LI> <LI> paused: indicates whether to start the tween paused.</LI> <LI> position: indicates the initial position for this timeline.</LI> <LI> onChange: specifies a listener to add for the {{#crossLink "Timeline/change:event"}}{{/crossLink}} event.</LI> </UL>
 * @constructor
 * @extends createjs.EventDispatcher
 */
createjs.Timeline = function (tweens, labels, props) {}

    /**
     * @see [Timeline]
     */
createjs.Timeline.prototype.clone = function () {  }

    /**
     * If a numeric position is passed, it is returned unchanged. If a string is passed, the position of the
     * corresponding frame label will be returned, or `null` if a matching label is not defined.
     *
     * @param {(number|string|null)} positionOrLabel A numeric position value or label string.
     * @see [Timeline]
     */
createjs.Timeline.prototype.resolve = function (positionOrLabel) {  }

    /**
     * Adds a label that can be used with {{#crossLink "Timeline/gotoAndPlay"}}{{/crossLink}}/{{#crossLink "Timeline/gotoAndStop"}}{{/crossLink}}.
     *
     * @param {(string|null)} label The label name.
     * @param {(number|null)} position The position this label represents.
     * @see [Timeline]
     */
createjs.Timeline.prototype.addLabel = function (label, position) {  }

    /**
     * @param {(number|null)} value 
     * @see [Timeline]
     * @returns {(number|null)} 
     */
createjs.Timeline.prototype._calcPosition = function (value) { return 0; }

    /**
     * Pauses this timeline and jumps to the specified position or label.
     *
     * @param {(number|string|null)} positionOrLabel The position in milliseconds (or ticks if `useTicks` is `true`) or label to jump to.
     * @see [Timeline]
     */
createjs.Timeline.prototype.gotoAndStop = function (positionOrLabel) {  }

    /**
     * Removes one or more tweens from this timeline.
     *
     * @see [Timeline]
     * @returns {?} Boolean Returns `true` if all of the tweens were successfully removed.
     */
createjs.Timeline.prototype.removeTween = function (tween) {  return null; }

    /**
     * Returns the name of the label on or immediately before the current position. For example, given a timeline with
     * two labels, "first" on frame index 4, and "second" on frame 8, getCurrentLabel would return:
     * <UL>
     * <LI>null if the current position is 2.</LI>
     * <LI>"first" if the current position is 4.</LI>
     * <LI>"first" if the current position is 7.</LI>
     * <LI>"second" if the current position is 15.</LI>
     * </UL>
     *
     * @see [Timeline]
     * @returns {(string|null)} The name of the current label or null if there is no label
     */
createjs.Timeline.prototype.getCurrentLabel = function () { return ''; }

    /**
     * Advances the timeline to the specified position.
     *
     * @param {(number|null)} value The position to seek to in milliseconds (or ticks if `useTicks` is `true`).
     * @param {number=} opt_actionsMode parameter specifying how actions are handled. See the Tween {{#crossLink "Tween/setPosition"}}{{/crossLink}} method for more details.
     * @see [Timeline]
     * @returns {(boolean|null)} Returns `true` if the timeline is complete (ie. the full timeline has run & {{#crossLink "Timeline/loop:property"}}{{/crossLink}} is `false`).
     */
createjs.Timeline.prototype.setPosition = function (value, opt_actionsMode) {  return null; }

    /**
     * Pauses or plays this timeline.
     *
     * @param {(boolean|null)} value Indicates whether the tween should be paused (`true`) or played (`false`).
     * @see [Timeline]
     */
createjs.Timeline.prototype.setPaused = function (value) {  }

    /**
     * Advances this timeline by the specified amount of time in milliseconds (or ticks if `useTicks` is `true`).
     * This is normally called automatically by the Tween engine (via the {{#crossLink "Tween/tick:event"}}{{/crossLink}}
     * event), but is exposed for advanced uses.
     *
     * @param {(number|null)} delta The time to advance in milliseconds (or ticks if useTicks is true).
     * @see [Timeline]
     */
createjs.Timeline.prototype.tick = function (delta) {  }

    /**
     * @param {(number|string|null)} positionOrLabel 
     * @see [Timeline]
     */
createjs.Timeline.prototype._goto = function (positionOrLabel) {  }

    /**
     * Returns a sorted list of the labels defined on this timeline.
     *
     * @see [Timeline]
     * @returns {(Array|null)} Object]} A sorted array of objects with label and position properties.
     */
createjs.Timeline.prototype.getLabels = function () {  return null; }

    /**
     * Recalculates the duration of the timeline. The duration is automatically updated when tweens are added or removed,
     * but this method is useful if you modify a tween after it was added to the timeline.
     *
     * @see [Timeline]
     */
createjs.Timeline.prototype.updateDuration = function () {  }

    /**
     * Adds one or more tweens (or timelines) to this timeline. The tweens will be paused (to remove them from the
     * normal ticking system) and managed by this timeline. Adding a tween to multiple timelines will result in
     * unexpected behaviour.
     *
     * @see [Timeline]
     * @returns {(Tween|null)} The first tween that was passed in.
     */
createjs.Timeline.prototype.addTween = function (tween) {  return null; }


    /**
     * Defines labels for use with gotoAndPlay/Stop. Overwrites any previously set labels.
     *
     * @param {(Object|null)} o An object defining labels for using {{#crossLink "Timeline/gotoAndPlay"}}{{/crossLink}}/{{#crossLink "Timeline/gotoAndStop"}}{{/crossLink}} in the form `{labelName:time}` where time is in milliseconds (or ticks if `useTicks` is `true`).
     * @see [Timeline]
     */
createjs.Timeline.prototype.setLabels = function (o) {  }

    /**
     * Unpauses this timeline and jumps to the specified position or label.
     *
     * @param {(number|string|null)} positionOrLabel The position in milliseconds (or ticks if `useTicks` is `true`) or label to jump to.
     * @see [Timeline]
     */
createjs.Timeline.prototype.gotoAndPlay = function (positionOrLabel) {  }

