/** @fileoverview Auto-generated Externs files
 * @externs
 */
/**
 * The Ease class provides a collection of easing functions for use with TweenJS. It does not use the standard 4 param
 * easing signature. Instead it uses a single param which indicates the current linear ratio (0 to 1) of the tween.
 * 
 * Most methods on Ease can be passed directly as easing functions:
 * 
 * Tween.get(target).to({x:100}, 500, createjs.Ease.linear);
 * 
 * However, methods beginning with "get" will return an easing function based on parameter values:
 * 
 * Tween.get(target).to({y:200}, 500, createjs.Ease.getPowIn(2.2));
 * 
 * Please see the <a href="http://www.createjs.com/Demos/TweenJS/Tween_SparkTable">spark table demo</a> for an
 * overview of the different ease types on <a href="http://tweenjs.com">TweenJS.com</a>.
 * 
 * <em>Equations derived from work by Robert Penner.</em>
 *
 * @see [Ease]
 * @constructor
 */
createjs.Ease = function () {}

    /**
     * Configurable elastic ease.
     *
     * @param {(number|null)} amplitude 
     * @param {(number|null)} period 
     * @see [Ease]
     * @returns {(Function|null)} 
     */
createjs.Ease.getElasticIn = function (amplitude, period) {  return null; }

    /**
     * @param {(number|null)} t 
     * @see [Ease]
     * @returns {(number|null)} 
     */
createjs.Ease.circOut = function (t) { return 0; }

    /**
     * @param {(number|null)} t 
     * @see [Ease]
     * @returns {(number|null)} 
     */
createjs.Ease.linear = function (t) { return 0; }

    /**
     * @param {(number|null)} t 
     * @see [Ease]
     * @returns {(number|null)} 
     */
createjs.Ease.sineIn = function (t) { return 0; }

    /**
     * @param {(number|null)} t 
     * @see [Ease]
     * @returns {(number|null)} 
     */
createjs.Ease.sineOut = function (t) { return 0; }

    /**
     * Mimics the simple -100 to 100 easing in Flash Pro.
     *
     * @param {(number|null)} amount A value from -1 (ease in) to 1 (ease out) indicating the strength and direction of the ease.
     * @see [Ease]
     * @returns {(Function|null)} 
     */
createjs.Ease.get = function (amount) {  return null; }

    /**
     * Configurable "back in" ease.
     *
     * @param {(number|null)} amount The strength of the ease.
     * @see [Ease]
     * @returns {(Function|null)} 
     */
createjs.Ease.getBackIn = function (amount) {  return null; }

    /**
     * @param {(number|null)} t 
     * @see [Ease]
     * @returns {(number|null)} 
     */
createjs.Ease.circIn = function (t) { return 0; }

    /**
     * Configurable "back out" ease.
     *
     * @param {(number|null)} amount The strength of the ease.
     * @see [Ease]
     * @returns {(Function|null)} 
     */
createjs.Ease.getBackOut = function (amount) {  return null; }

    /**
     * Configurable elastic ease.
     *
     * @param {(number|null)} amplitude 
     * @param {(number|null)} period 
     * @see [Ease]
     * @returns {(Function|null)} 
     */
createjs.Ease.getElasticInOut = function (amplitude, period) {  return null; }

    /**
     * @param {(number|null)} t 
     * @see [Ease]
     * @returns {(number|null)} 
     */
createjs.Ease.bounceInOut = function (t) { return 0; }

    /**
     * @param {(number|null)} t 
     * @see [Ease]
     * @returns {(number|null)} 
     */
createjs.Ease.bounceIn = function (t) { return 0; }

    /**
     * @param {(number|null)} t 
     * @see [Ease]
     * @returns {(number|null)} 
     */
createjs.Ease.sineInOut = function (t) { return 0; }

    /**
     * @param {(number|null)} t 
     * @see [Ease]
     * @returns {(number|null)} 
     */
createjs.Ease.circInOut = function (t) { return 0; }

    /**
     * Configurable exponential ease.
     *
     * @param {(number|null)} pow The exponent to use (ex. 3 would return a cubic ease).
     * @see [Ease]
     * @returns {(Function|null)} 
     */
createjs.Ease.getPowOut = function (pow) {  return null; }

    /**
     * Configurable "back in out" ease.
     *
     * @param {(number|null)} amount The strength of the ease.
     * @see [Ease]
     * @returns {(Function|null)} 
     */
createjs.Ease.getBackInOut = function (amount) {  return null; }

    /**
     * Configurable exponential ease.
     *
     * @param {(number|null)} pow The exponent to use (ex. 3 would return a cubic ease).
     * @see [Ease]
     * @returns {(Function|null)} 
     */
createjs.Ease.getPowIn = function (pow) {  return null; }

    /**
     * Configurable exponential ease.
     *
     * @param {(number|null)} pow The exponent to use (ex. 3 would return a cubic ease).
     * @see [Ease]
     * @returns {(Function|null)} 
     */
createjs.Ease.getPowInOut = function (pow) {  return null; }

    /**
     * Configurable elastic ease.
     *
     * @param {(number|null)} amplitude 
     * @param {(number|null)} period 
     * @see [Ease]
     * @returns {(Function|null)} 
     */
createjs.Ease.getElasticOut = function (amplitude, period) {  return null; }

    /**
     * @param {(number|null)} t 
     * @see [Ease]
     * @returns {(number|null)} 
     */
createjs.Ease.bounceOut = function (t) { return 0; }

