/** @fileoverview Auto-generated Externs files
 * @externs
 */
/**
 * The SpriteSheetBuilder allows you to generate sprite sheets at run time from any display object. This can allow
 * you to maintain your assets as vector graphics (for low file size), and render them at run time as sprite sheets
 * for better performance.
 * 
 * Sprite sheets can be built either synchronously, or asynchronously, so that large sprite sheets can be generated
 * without locking the UI.
 * 
 * Note that the "images" used in the generated sprite sheet are actually canvas elements, and that they will be sized
 * to the nearest power of 2 up to the value of <code>maxWidth</code> or <code>maxHeight</code>.
 *
 * @see [SpriteSheetBuilder]
 * @constructor
 * @extends createjs.EventDispatcher
 */
createjs.SpriteSheetBuilder = function () {}

    /**
     * Stops the current asynchronous build.
     *
     * @see [SpriteSheetBuilder]
     */
createjs.SpriteSheetBuilder.prototype.stopAsync = function () {  }

    /**
     * SpriteSheetBuilder instances cannot be cloned.
     *
     * @see [SpriteSheetBuilder]
     */
createjs.SpriteSheetBuilder.prototype.clone = function () {  }

    /**
     * @see [SpriteSheetBuilder]
     */
createjs.SpriteSheetBuilder.prototype._endBuild = function () {  }

    /**
     * @see [SpriteSheetBuilder]
     */
createjs.SpriteSheetBuilder.prototype._run = function () {  }

    /**
     * @see [SpriteSheetBuilder]
     */
createjs.SpriteSheetBuilder.prototype._startBuild = function () {  }

    /**
     * Asynchronously builds a {{#crossLink "SpriteSheet"}}{{/crossLink}} instance based on the current frames. It will
     * run 20 times per second, using an amount of time defined by <code>timeSlice</code>. When it is complete it will
     * call the specified callback.
     *
     * @param {number=} opt_timeSlice Sets the timeSlice property on this instance.
     * @see [SpriteSheetBuilder]
     */
createjs.SpriteSheetBuilder.prototype.buildAsync = function (opt_timeSlice) {  }

    /**
     * Builds a SpriteSheet instance based on the current frames.
     *
     * @see [SpriteSheetBuilder]
     * @returns {(createjs.SpriteSheet|null)} The created SpriteSheet instance, or null if a build is already running or an error occurred.
     */
createjs.SpriteSheetBuilder.prototype.build = function () {  return null; }

    /**
     * Adds a frame to the {{#crossLink "SpriteSheet"}}{{/crossLink}}. Note that the frame will not be drawn until you
     * call {{#crossLink "SpriteSheetBuilder/build"}}{{/crossLink}} method. The optional setup params allow you to have
     * a function run immediately before the draw occurs. For example, this allows you to add a single source multiple
     * times, but manipulate it or its children to change it to generate different frames.
     * 
     * Note that the source's transformations (x, y, scale, rotate, alpha) will be ignored, except for regX/Y. To apply
     * transforms to a source object and have them captured in the sprite sheet, simply place it into a {{#crossLink "Container"}}{{/crossLink}}
     * and pass in the Container as the source.
     *
     * @param {(createjs.DisplayObject|null)} source The source {{#crossLink "DisplayObject"}}{{/crossLink}}  to draw as the frame.
     * @param {createjs.Rectangle=} opt_sourceRect A {{#crossLink "Rectangle"}}{{/crossLink}} defining the portion of the source to draw to the frame. If not specified, it will look for a <code>getBounds</code> method, bounds property, or <code>nominalBounds</code> property on the source to use. If one is not found, the frame will be skipped.
     * @param {number=} opt_scale Optional. The scale to draw this frame at. Default is 1.
     * @param {Function=} opt_setupFunction A function to call immediately before drawing this frame. It will be called with two parameters: the source, and setupData.
     * @param {Object=} opt_setupData Arbitrary setup data to pass to setupFunction as the second parameter.
     * @see [SpriteSheetBuilder]
     * @returns {(number|null)} The index of the frame that was just added, or null if a sourceRect could not be determined.
     */
createjs.SpriteSheetBuilder.prototype.addFrame = function (source, opt_sourceRect, opt_scale, opt_setupFunction, opt_setupData) { return 0; }

    /**
     * @see [SpriteSheetBuilder]
     * @returns {(number|null)} The width & height of the row.
     */
createjs.SpriteSheetBuilder.prototype._getSize = function (size, max) { return 0; }

    /**
     * @see [SpriteSheetBuilder]
     * @returns {(number|null)} The width & height of the row.
     */
createjs.SpriteSheetBuilder.prototype._setupMovieClipFrame = function (source, data) { return 0; }

    /**
     * Adds an animation that will be included in the created sprite sheet.
     *
     * @param {string} name The name for the animation.
     * @param {(Array|null)} frames An array of frame indexes that comprise the animation. Ex. [3,6,5] would describe an animation that played frame indexes 3, 6, and 5 in that order.
     * @param {string=} opt_next Specifies the name of the animation to continue to after this animation ends. You can also pass false to have the animation stop when it ends. By default it will loop to the start of the same animation.
     * @param {number=} opt_frequency Specifies a frame advance frequency for this animation. For example, a value of 2 would cause the animation to advance every second tick.
     * @see [SpriteSheetBuilder]
     */
createjs.SpriteSheetBuilder.prototype.addAnimation = function (name, frames, opt_next, opt_frequency) {  }


    /**
     * @param {(Array|null)} frames 
     * @param {(number|null)} y 
     * @param {(Image|null)} img 
     * @param {(Object|null)} dataFrames 
     * @param {(number|null)} pad 
     * @see [SpriteSheetBuilder]
     * @returns {(number|null)} The width & height of the row.
     */
createjs.SpriteSheetBuilder.prototype._fillRow = function (frames, y, img, dataFrames, pad) { return 0; }

    /**
     * This will take a MovieClip instance, and add its frames and labels to this builder. Labels will be added as an animation
     * running from the label index to the next label. For example, if there is a label named "foo" at frame 0 and a label
     * named "bar" at frame 10, in a MovieClip with 15 frames, it will add an animation named "foo" that runs from frame
     * index 0 to 9, and an animation named "bar" that runs from frame index 10 to 14.
     * 
     * Note that this will iterate through the full MovieClip with actionsEnabled set to false, ending on the last frame.
     *
     * @param {(createjs.MovieClip|null)} source The source MovieClip instance to add to the sprite sheet.
     * @param {createjs.Rectangle=} opt_sourceRect A {{#crossLink "Rectangle"}}{{/crossLink}} defining the portion of the source to draw to the frame. If not specified, it will look for a <code>getBounds</code> method, <code>frameBounds</code> Array, <code>bounds</code> property, or <code>nominalBounds</code> property on the source to use. If one is not found, the MovieClip will be skipped.
     * @param {number=} opt_scale The scale to draw the movie clip at.
     * @param {Function=} opt_setupFunction A function to call immediately before drawing each frame. It will be called with three parameters: the source, setupData, and the frame index.
     * @param {Object=} opt_setupData Arbitrary setup data to pass to setupFunction as the second parameter.
     * @param {Function=} opt_labelFunction This method will be called for each movieclip label that is added with four parameters: the label name, the source movieclip instance, the starting frame index (in the movieclip timeline) and the end index. It must return a new name for the label/animation, or false to exclude the label.
     * @see [SpriteSheetBuilder]
     */
createjs.SpriteSheetBuilder.prototype.addMovieClip = function (source, opt_sourceRect, opt_scale, opt_setupFunction, opt_setupData, opt_labelFunction) {  }

    /**
     * @see [SpriteSheetBuilder]
     * @returns {?} Boolean Returns false if this is the last draw.
     */
createjs.SpriteSheetBuilder.prototype._drawNext = function () {  return null; }

