/** @fileoverview Auto-generated Externs files
 * @externs
 */
/**
 * The ButtonHelper is a helper class to create interactive buttons from {{#crossLink "MovieClip"}}{{/crossLink}} or
 * {{#crossLink "Sprite"}}{{/crossLink}} instances. This class will intercept mouse events from an object, and
 * automatically call {{#crossLink "Sprite/gotoAndStop"}}{{/crossLink}} or {{#crossLink "Sprite/gotoAndPlay"}}{{/crossLink}},
 * to the respective animation labels, add a pointer cursor, and allows the user to define a hit state frame.
 * 
 * The ButtonHelper instance does not need to be added to the stage, but a reference should be maintained to prevent
 * garbage collection.
 * 
 * Note that over states will not work unless you call {{#crossLink "Stage/enableMouseOver"}}{{/crossLink}}.
 * 
 * <h4>Example</h4>
 * 
 * var helper = new createjs.ButtonHelper(myInstance, "out", "over", "down", false, myInstance, "hit");
 * myInstance.addEventListener("click", handleClick);
 * function handleClick(event) {
 * // Click Happened.
 * }
 *
 * @see [ButtonHelper]
 * @param {(Sprite|createjs.MovieClip|null)} target The instance to manage.
 * @param {string=} opt_outLabel The label or animation to go to when the user rolls out of the button.
 * @param {string=} opt_overLabel The label or animation to go to when the user rolls over the button.
 * @param {string=} opt_downLabel The label or animation to go to when the user presses the button.
 * @param {boolean=} opt_play If the helper should call "gotoAndPlay" or "gotoAndStop" on the button when changing states.
 * @param {createjs.DisplayObject=} opt_hitArea An optional item to use as the hit state for the button. If this is not defined, then the button's visible states will be used instead. Note that the same instance as the "target" argument can be used for the hitState.
 * @param {string=} opt_hitLabel The label or animation on the hitArea instance that defines the hitArea bounds. If this is null, then the default state of the hitArea will be used. *
 * @constructor
 */
createjs.ButtonHelper = function (target, opt_outLabel, opt_overLabel, opt_downLabel, opt_play, opt_hitArea, opt_hitLabel) {}

    /**
     * Enables or disables the button functionality on the target.
     *
     * @type {(boolean|null)} 
     * @see [ButtonHelper]
     */
createjs.ButtonHelper.prototype.enabled;

    /**
     * Use the {{#crossLink "ButtonHelper/enabled:property"}}{{/crossLink}} property instead.
     *
     * @see [ButtonHelper]
     * @returns {(boolean|null)} 
     */
createjs.ButtonHelper.prototype.getEnabled = function () {  return null; }

    /**
     * @param {(Object|null)} evt The mouse event to handle.
     * @see [ButtonHelper]
     */
createjs.ButtonHelper.prototype.handleEvent = function (evt) {  }

    /**
     * Use the {{#crossLink "ButtonHelper/enabled:property"}}{{/crossLink}} property instead.
     *
     * @param {(boolean|null)} value 
     * @see [ButtonHelper]
     */
createjs.ButtonHelper.prototype.setEnabled = function (value) {  }

    /**
     * Returns a string representation of this object.
     *
     * @see [ButtonHelper]
     * @returns {string} a string representation of the instance.
     */
createjs.ButtonHelper.prototype.toString = function () { return ''; }

