/** @fileoverview Auto-generated Externs files
 * @externs
 */
/**
 * Represents a rectangle as defined by the points (x, y) and (x+width, y+height).
 * 
 * <h4>Example</h4>
 * 
 * var rect = new createjs.Rectangle(0, 0, 100, 100);
 *
 * @see [Rectangle]
 * @param {number=} opt_x X position.
 * @param {number=} opt_y Y position.
 * @param {number=} opt_width The width of the createjs.Rectangle.
 * @param {number=} opt_height The height of the createjs.Rectangle.
 * @constructor
 */
createjs.Rectangle = function (opt_x, opt_y, opt_width, opt_height) {}

    /**
     * Returns a clone of the Rectangle instance.
     *
     * @see [Rectangle]
     * @returns {(createjs.Rectangle|null)} a clone of the Rectangle instance.
     */
createjs.Rectangle.prototype.clone = function () {  return null; }

    /**
     * Returns true if the width or height are equal or less than 0.
     *
     * @see [Rectangle]
     * @returns {(boolean|null)} True if the rectangle is empty.
     */
createjs.Rectangle.prototype.isEmpty = function () {  return null; }

    /**
     * Returns a new rectangle which describes the intersection (overlap) of this rectangle and the specified rectangle,
     * or null if they do not intersect.
     *
     * @param {(createjs.Rectangle|null)} rect The rectangle to calculate an intersection with.
     * @see [Rectangle]
     * @returns {(createjs.Rectangle|null)} A new rectangle describing the intersection or null.
     */
createjs.Rectangle.prototype.intersection = function (rect) {  return null; }

    /**
     * Adds the specified padding to the rectangle's bounds.
     *
     * @param {number=} opt_top 
     * @param {number=} opt_left 
     * @param {number=} opt_right 
     * @param {number=} opt_bottom 
     * @see [Rectangle]
     * @returns {(createjs.Rectangle|null)} This instance. Useful for chaining method calls.
     */
createjs.Rectangle.prototype.pad = function (opt_top, opt_left, opt_right, opt_bottom) {  return null; }

    /**
     * Extends the rectangle's bounds to include the described point or rectangle.
     *
     * @param {(number|null)} x X position of the point or rectangle.
     * @param {(number|null)} y Y position of the point or rectangle.
     * @param {number=} opt_width The width of the rectangle.
     * @param {number=} opt_height The height of the rectangle.
     * @see [Rectangle]
     * @returns {(createjs.Rectangle|null)} This instance. Useful for chaining method calls.
     */
createjs.Rectangle.prototype.extend = function (x, y, opt_width, opt_height) {  return null; }

    /**
     * Sets the specified values on this instance.
     *
     * @param {number=} opt_x X position.
     * @param {number=} opt_y Y position.
     * @param {number=} opt_width The width of the createjs.Rectangle.
     * @param {number=} opt_height The height of the createjs.Rectangle.
     * @see [Rectangle]
     * @returns {(createjs.Rectangle|null)} This instance. Useful for chaining method calls.
     */
createjs.Rectangle.prototype.setValues = function (opt_x, opt_y, opt_width, opt_height) {  return null; }

    /**
     * Returns true if the specified rectangle intersects (has any overlap) with this rectangle.
     *
     * @param {(createjs.Rectangle|null)} rect The rectangle to compare.
     * @see [Rectangle]
     * @returns {(boolean|null)} True if the rectangles intersect.
     */
createjs.Rectangle.prototype.intersects = function (rect) {  return null; }

    /**
     * Returns a new rectangle which contains this rectangle and the specified rectangle.
     *
     * @param {(createjs.Rectangle|null)} rect The rectangle to calculate a union with.
     * @see [Rectangle]
     * @returns {(createjs.Rectangle|null)} A new rectangle describing the union.
     */
createjs.Rectangle.prototype.union = function (rect) {  return null; }

    /**
     * Returns a string representation of this object.
     *
     * @see [Rectangle]
     * @returns {string} a string representation of the instance.
     */
createjs.Rectangle.prototype.toString = function () { return ''; }

    /**
     * Returns true if this rectangle fully encloses the described point or rectangle.
     *
     * @param {(number|null)} x X position of the point or rectangle.
     * @param {(number|null)} y Y position of the point or rectangle.
     * @param {number=} opt_width The width of the rectangle.
     * @param {number=} opt_height The height of the rectangle.
     * @see [Rectangle]
     * @returns {(boolean|null)} True if the described point or rectangle is contained within this rectangle.
     */
createjs.Rectangle.prototype.contains = function (x, y, opt_width, opt_height) {  return null; }

    /**
     * Copies all properties from the specified rectangle to this rectangle.
     *
     * @param {(createjs.Rectangle|null)} rectangle The rectangle to copy properties from.
     * @see [Rectangle]
     * @returns {(createjs.Rectangle|null)} This rectangle. Useful for chaining method calls.
     */
createjs.Rectangle.prototype.copy = function (rectangle) {  return null; }

