/** @fileoverview Auto-generated Externs files
 * @externs
 */
/**
 * Represents an affine transformation matrix, and provides tools for constructing and concatenating matrices.
 * 
 * This matrix can be visualized as:
 * 
 * [ a  c  tx
 * b  d  ty
 * 0  0  1  ]
 * 
 * Note the locations of b and c.
 *
 * @see [Matrix2D]
 * @param {number=} opt_a Specifies the a property for the new matrix.
 * @param {number=} opt_b Specifies the b property for the new matrix.
 * @param {number=} opt_c Specifies the c property for the new matrix.
 * @param {number=} opt_d Specifies the d property for the new matrix.
 * @param {number=} opt_tx Specifies the tx property for the new matrix.
 * @param {number=} opt_ty Specifies the ty property for the new matrix.
 * @constructor
 */
createjs.Matrix2D = function (opt_a, opt_b, opt_c, opt_d, opt_tx, opt_ty) {}

    /**
     * Returns a clone of the Matrix2D instance.
     *
     * @see [Matrix2D]
     * @returns {(createjs.Matrix2D|null)} a clone of the Matrix2D instance.
     */
createjs.Matrix2D.prototype.clone = function () {  return null; }

    /**
     * Appends the specified matrix properties to this matrix. All parameters are required.
     * This is the equivalent of multiplying `(this matrix) * (specified matrix)`.
     *
     * @param {(number|null)} a 
     * @param {(number|null)} b 
     * @param {(number|null)} c 
     * @param {(number|null)} d 
     * @param {(number|null)} tx 
     * @param {(number|null)} ty 
     * @see [Matrix2D]
     * @returns {(createjs.Matrix2D|null)} This matrix. Useful for chaining method calls.
     */
createjs.Matrix2D.prototype.append = function (a, b, c, d, tx, ty) {  return null; }

    /**
     * Applies a scale transformation to the matrix.
     *
     * @param {(number|null)} x The amount to scale horizontally. E.G. a value of 2 will double the size in the X direction, and 0.5 will halve it.
     * @param {(number|null)} y The amount to scale vertically.
     * @see [Matrix2D]
     * @returns {(createjs.Matrix2D|null)} This matrix. Useful for chaining method calls.
     */
createjs.Matrix2D.prototype.scale = function (x, y) {  return null; }

    /**
     * Decomposes the matrix into transform properties (x, y, scaleX, scaleY, and rotation). Note that these values
     * may not match the transform properties you used to generate the matrix, though they will produce the same visual
     * results.
     *
     * @param {(Object|null)} target The object to apply the transform properties to. If null, then a new object will be returned.
     * @see [Matrix2D]
     * @returns {(Object|null)} The target, or a new generic object with the transform properties applied.
     */
createjs.Matrix2D.prototype.decompose = function (target) {  return null; }

    /**
     * Applies a clockwise rotation transformation to the matrix.
     *
     * @param {(number|null)} angle The angle to rotate by, in degrees. To use a value in radians, multiply it by `180/Math.PI`.
     * @see [Matrix2D]
     * @returns {(createjs.Matrix2D|null)} This matrix. Useful for chaining method calls.
     */
createjs.Matrix2D.prototype.rotate = function (angle) {  return null; }

    /**
     * Returns true if this matrix is equal to the specified matrix (all property values are equal).
     *
     * @param {(createjs.Matrix2D|null)} matrix The matrix to compare.
     * @see [Matrix2D]
     * @returns {(boolean|null)} 
     */
createjs.Matrix2D.prototype.equals = function (matrix) {  return null; }

    /**
     * Prepends the specified matrix properties to this matrix.
     * This is the equivalent of multiplying `(specified matrix) * (this matrix)`.
     * All parameters are required.
     *
     * @param {(number|null)} a 
     * @param {(number|null)} b 
     * @param {(number|null)} c 
     * @param {(number|null)} d 
     * @param {(number|null)} tx 
     * @param {(number|null)} ty 
     * @see [Matrix2D]
     * @returns {(createjs.Matrix2D|null)} This matrix. Useful for chaining method calls.
     */
createjs.Matrix2D.prototype.prepend = function (a, b, c, d, tx, ty) {  return null; }

    /**
     * Generates matrix properties from the specified display object transform properties, and appends them to this matrix.
     * For example, you can use this to generate a matrix representing the transformations of a display object:
     * 
     * var mtx = new Matrix2D();
     * mtx.appendTransform(o.x, o.y, o.scaleX, o.scaleY, o.rotation);
     *
     * @param {(number|null)} x 
     * @param {(number|null)} y 
     * @param {(number|null)} scaleX 
     * @param {(number|null)} scaleY 
     * @param {(number|null)} rotation 
     * @param {(number|null)} skewX 
     * @param {(number|null)} skewY 
     * @param {(number|null)} regX Optional.
     * @param {(number|null)} regY Optional.
     * @see [Matrix2D]
     * @returns {(createjs.Matrix2D|null)} This matrix. Useful for chaining method calls.
     */
createjs.Matrix2D.prototype.appendTransform = function (x, y, scaleX, scaleY, rotation, skewX, skewY, regX, regY) {  return null; }

    /**
     * Inverts the matrix, causing it to perform the opposite transformation.
     *
     * @see [Matrix2D]
     * @returns {(createjs.Matrix2D|null)} This matrix. Useful for chaining method calls.
     */
createjs.Matrix2D.prototype.invert = function () {  return null; }

    /**
     * Sets the properties of the matrix to those of an identity matrix (one that applies a null transformation).
     *
     * @see [Matrix2D]
     * @returns {(createjs.Matrix2D|null)} This matrix. Useful for chaining method calls.
     */
createjs.Matrix2D.prototype.identity = function () {  return null; }

    /**
     * Prepends the specified matrix to this matrix.
     * This is the equivalent of multiplying `(specified matrix) * (this matrix)`.
     * For example, you could calculate the combined transformation for a child object using:
     * 
     * var o = myDisplayObject;
     * var mtx = o.getMatrix();
     * while (o = o.parent) {
     * // prepend each parent's transformation in turn:
     * o.prependMatrix(o.getMatrix());
     * }
     *
     * @param {(createjs.Matrix2D|null)} matrix 
     * @see [Matrix2D]
     * @returns {(createjs.Matrix2D|null)} This matrix. Useful for chaining method calls.
     */
createjs.Matrix2D.prototype.prependMatrix = function (matrix) {  return null; }

    /**
     * Transforms a point according to this matrix.
     *
     * @param {(number|null)} x The x component of the point to transform.
     * @param {(number|null)} y The y component of the point to transform.
     * @param {(Object|createjs.Point)=} opt_pt An object to copy the result into. If omitted a generic object with x/y properties will be returned.
     * @see [Matrix2D]
     * @returns {(createjs.Point|null)} This matrix. Useful for chaining method calls.
     */
createjs.Matrix2D.prototype.transformPoint = function (x, y, opt_pt) {  return null; }

    /**
     * Returns true if the matrix is an identity matrix.
     *
     * @see [Matrix2D]
     * @returns {(boolean|null)} 
     */
createjs.Matrix2D.prototype.isIdentity = function () {  return null; }

    /**
     * Sets the specified values on this instance.
     *
     * @param {number=} opt_a Specifies the a property for the new matrix.
     * @param {number=} opt_b Specifies the b property for the new matrix.
     * @param {number=} opt_c Specifies the c property for the new matrix.
     * @param {number=} opt_d Specifies the d property for the new matrix.
     * @param {number=} opt_tx Specifies the tx property for the new matrix.
     * @param {number=} opt_ty Specifies the ty property for the new matrix.
     * @see [Matrix2D]
     * @returns {(createjs.Matrix2D|null)} This instance. Useful for chaining method calls.
     */
createjs.Matrix2D.prototype.setValues = function (opt_a, opt_b, opt_c, opt_d, opt_tx, opt_ty) {  return null; }

    /**
     * Generates matrix properties from the specified display object transform properties, and prepends them to this matrix.
     * For example, you could calculate the combined transformation for a child object using:
     * 
     * var o = myDisplayObject;
     * var mtx = new createjs.Matrix2D();
     * do  {
     * // prepend each parent's transformation in turn:
     * mtx.prependTransform(o.x, o.y, o.scaleX, o.scaleY, o.rotation, o.skewX, o.skewY, o.regX, o.regY);
     * } while (o = o.parent);
     * 
     * Note that the above example would not account for {{#crossLink "DisplayObject/transformMatrix:property"}}{{/crossLink}}
     * values. See {{#crossLink "Matrix2D/prependMatrix"}}{{/crossLink}} for an example that does.
     *
     * @param {(number|null)} x 
     * @param {(number|null)} y 
     * @param {(number|null)} scaleX 
     * @param {(number|null)} scaleY 
     * @param {(number|null)} rotation 
     * @param {(number|null)} skewX 
     * @param {(number|null)} skewY 
     * @param {(number|null)} regX Optional.
     * @param {(number|null)} regY Optional.
     * @see [Matrix2D]
     * @returns {(createjs.Matrix2D|null)} This matrix. Useful for chaining method calls.
     */
createjs.Matrix2D.prototype.prependTransform = function (x, y, scaleX, scaleY, rotation, skewX, skewY, regX, regY) {  return null; }

    /**
     * Returns a string representation of this object.
     *
     * @see [Matrix2D]
     * @returns {string} a string representation of the instance.
     */
createjs.Matrix2D.prototype.toString = function () { return ''; }

    /**
     * Translates the matrix on the x and y axes.
     *
     * @param {(number|null)} x 
     * @param {(number|null)} y 
     * @see [Matrix2D]
     * @returns {(createjs.Matrix2D|null)} This matrix. Useful for chaining method calls.
     */
createjs.Matrix2D.prototype.translate = function (x, y) {  return null; }

    /**
     * Appends the specified matrix to this matrix.
     * This is the equivalent of multiplying `(this matrix) * (specified matrix)`.
     *
     * @param {(createjs.Matrix2D|null)} matrix 
     * @see [Matrix2D]
     * @returns {(createjs.Matrix2D|null)} This matrix. Useful for chaining method calls.
     */
createjs.Matrix2D.prototype.appendMatrix = function (matrix) {  return null; }

    /**
     * Applies a skew transformation to the matrix.
     *
     * @param {(number|null)} skewX The amount to skew horizontally in degrees. To use a value in radians, multiply it by `180/Math.PI`.
     * @param {(number|null)} skewY The amount to skew vertically in degrees.
     * @see [Matrix2D]
     * @returns {(createjs.Matrix2D|null)} This matrix. Useful for chaining method calls.
     */
createjs.Matrix2D.prototype.skew = function (skewX, skewY) {  return null; }

    /**
     * Copies all properties from the specified matrix to this matrix.
     *
     * @param {(createjs.Matrix2D|null)} matrix The matrix to copy properties from.
     * @see [Matrix2D]
     * @returns {(createjs.Matrix2D|null)} This matrix. Useful for chaining method calls.
     */
createjs.Matrix2D.prototype.copy = function (matrix) {  return null; }

