/** @fileoverview Auto-generated Externs files
 * @externs
 */
/**
 * Used for calculating and encapsulating display related properties.
 *
 * @see [DisplayProps]
 * @param {number=} opt_visible Visible value.
 * @param {number=} opt_alpha Alpha value.
 * @param {number=} opt_shadow A Shadow instance or null.
 * @param {number=} opt_compositeOperation A compositeOperation value or null.
 * @param {number=} opt_matrix A transformation matrix. Defaults to a new identity matrix.
 * @constructor
 */
createjs.DisplayProps = function (opt_visible, opt_alpha, opt_shadow, opt_compositeOperation, opt_matrix) {}

    /**
     * Returns a clone of the DisplayProps instance. Clones the associated matrix.
     *
     * @see [DisplayProps]
     * @returns {(createjs.DisplayProps|null)} a clone of the DisplayProps instance.
     */
createjs.DisplayProps.prototype.clone = function () {  return null; }

    /**
     * Resets this instance and its matrix to default values.
     *
     * @see [DisplayProps]
     * @returns {(createjs.DisplayProps|null)} This instance. Useful for chaining method calls.
     */
createjs.DisplayProps.prototype.identity = function () {  return null; }

    /**
     * Appends the specified display properties. This is generally used to apply a child's properties its parent's.
     *
     * @param {(boolean|null)} visible desired visible value
     * @param {(number|null)} alpha desired alpha value
     * @param {(createjs.Shadow|null)} shadow desired shadow value
     * @param {string} compositeOperation desired composite operation value
     * @param {createjs.Matrix2D=} opt_matrix a Matrix2D instance
     * @see [DisplayProps]
     * @returns {(createjs.DisplayProps|null)} This instance. Useful for chaining method calls.
     */
createjs.DisplayProps.prototype.append = function (visible, alpha, shadow, compositeOperation, opt_matrix) {  return null; }

    /**
     * Prepends the specified display properties. This is generally used to apply a parent's properties to a child's.
     * For example, to get the combined display properties that would be applied to a child, you could use:
     * 
     * var o = myDisplayObject;
     * var props = new createjs.DisplayProps();
     * do {
     * // prepend each parent's props in turn:
     * props.prepend(o.visible, o.alpha, o.shadow, o.compositeOperation, o.getMatrix());
     * } while (o = o.parent);
     *
     * @param {(boolean|null)} visible desired visible value
     * @param {(number|null)} alpha desired alpha value
     * @param {(createjs.Shadow|null)} shadow desired shadow value
     * @param {string} compositeOperation desired composite operation value
     * @param {createjs.Matrix2D=} opt_matrix a Matrix2D instance
     * @see [DisplayProps]
     * @returns {(createjs.DisplayProps|null)} This instance. Useful for chaining method calls.
     */
createjs.DisplayProps.prototype.prepend = function (visible, alpha, shadow, compositeOperation, opt_matrix) {  return null; }

    /**
     * Reinitializes the instance with the specified values.
     *
     * @param {number=} opt_visible Visible value.
     * @param {number=} opt_alpha Alpha value.
     * @param {number=} opt_shadow A Shadow instance or null.
     * @param {number=} opt_compositeOperation A compositeOperation value or null.
     * @param {number=} opt_matrix A transformation matrix. Defaults to an identity matrix.
     * @see [DisplayProps]
     * @returns {(createjs.DisplayProps|null)} This instance. Useful for chaining method calls.
     */
createjs.DisplayProps.prototype.setValues = function (opt_visible, opt_alpha, opt_shadow, opt_compositeOperation, opt_matrix) {  return null; }

