/** @fileoverview Auto-generated Externs files
 * @externs
 */
/**
 * Base class that all filters should inherit from. Filters need to be applied to objects that have been cached using
 * the {{#crossLink "DisplayObject/cache"}}{{/crossLink}} method. If an object changes, please cache it again, or use
 * {{#crossLink "DisplayObject/updateCache"}}{{/crossLink}}. Note that the filters must be applied before caching.
 * 
 * <h4>Example</h4>
 * 
 * myInstance.filters = [
 * new createjs.ColorFilter(0, 0, 0, 1, 255, 0, 0),
 * new createjs.BlurFilter(5, 5, 10)
 * ];
 * myInstance.cache(0,0, 100, 100);
 * 
 * Note that each filter can implement a {{#crossLink "Filter/getBounds"}}{{/crossLink}} method, which returns the
 * margins that need to be applied in order to fully display the filter. For example, the {{#crossLink "BlurFilter"}}{{/crossLink}}
 * will cause an object to feather outwards, resulting in a margin around the shape.
 * 
 * <h4>EaselJS Filters</h4>
 * EaselJS comes with a number of pre-built filters. Note that individual filters are not compiled into the minified
 * version of EaselJS. To use them, you must include them manually in the HTML.
 * <ul><li>{{#crossLink "AlphaMapFilter"}}{{/crossLink}} : Map a greyscale image to the alpha channel of a display object</li>
 * <li>{{#crossLink "AlphaMaskFilter"}}{{/crossLink}}: Map an image's alpha channel to the alpha channel of a display object</li>
 * <li>{{#crossLink "BlurFilter"}}{{/crossLink}}: Apply vertical and horizontal blur to a display object</li>
 * <li>{{#crossLink "ColorFilter"}}{{/crossLink}}: Color transform a display object</li>
 * <li>{{#crossLink "ColorMatrixFilter"}}{{/crossLink}}: Transform an image using a {{#crossLink "ColorMatrix"}}{{/crossLink}}</li>
 * </ul>
 *
 * @see [Filter]
 * @constructor
 */
createjs.Filter = function () {}

    /**
     * Returns a clone of this Filter instance.
     *
     * @see [Filter]
     * @returns {(createjs.Filter|null)} A clone of the current Filter instance.
     */
createjs.Filter.prototype.clone = function () {  return null; }

    /**
     * @param {(ImageData|null)} imageData Target ImageData instance.
     * @see [Filter]
     * @returns {(boolean|null)} 
     */
createjs.Filter.prototype._applyFilter = function (imageData) {  return null; }

    /**
     * Applies the filter to the specified context.
     *
     * @param {(CanvasRenderingContext2D|null)} ctx The 2D context to use as the source.
     * @param {(number|null)} x The x position to use for the source rect.
     * @param {(number|null)} y The y position to use for the source rect.
     * @param {(number|null)} width The width to use for the source rect.
     * @param {(number|null)} height The height to use for the source rect.
     * @param {CanvasRenderingContext2D=} opt_targetCtx The 2D context to draw the result to. Defaults to the context passed to ctx.
     * @param {number=} opt_targetX The x position to draw the result to. Defaults to the value passed to x.
     * @param {number=} opt_targetY The y position to draw the result to. Defaults to the value passed to y.
     * @see [Filter]
     * @returns {(boolean|null)} If the filter was applied successfully.
     */
createjs.Filter.prototype.applyFilter = function (ctx, x, y, width, height, opt_targetCtx, opt_targetX, opt_targetY) {  return null; }

    /**
     * Provides padding values for this filter. That is, how much the filter will extend the visual bounds of an object it is applied to.
     *
     * @param {createjs.Rectangle=} opt_rect If specified, the provided Rectangle instance will be expanded by the padding amounts and returned.
     * @see [Filter]
     * @returns {(createjs.Rectangle|null)} If a `rect` param was provided, it is returned. If not, either a new rectangle with the padding values, or null if no padding is required for this filter.
     */
createjs.Filter.prototype.getBounds = function (opt_rect) {  return null; }

    /**
     * Returns a string representation of this object.
     *
     * @see [Filter]
     * @returns {string} a string representation of the instance.
     */
createjs.Filter.prototype.toString = function () { return ''; }

