/** @fileoverview Auto-generated Externs files
 * @externs
 */
/**
 * Provides helper functions for assembling a matrix for use with the {{#crossLink "ColorMatrixFilter"}}{{/crossLink}}.
 * Most methods return the instance to facilitate chained calls.
 * 
 * <h4>Example</h4>
 * 
 * mycreatejs.ColorMatrix.adjustHue(20).adjustBrightness(50);
 * 
 * See {{#crossLink "Filter"}}{{/crossLink}} for an example of how to apply filters, or {{#crossLink "ColorMatrixFilter"}}{{/crossLink}}
 * for an example of how to use ColorMatrix to change a DisplayObject's color.
 *
 * @see [ColorMatrix]
 * @param {(number|null)} brightness 
 * @param {(number|null)} contrast 
 * @param {(number|null)} saturation 
 * @param {(number|null)} hue 
 * @constructor
 */
createjs.ColorMatrix = function (brightness, contrast, saturation, hue) {}

    /**
     * Returns a clone of this createjs.ColorMatrix.
     *
     * @see [ColorMatrix]
     * @returns {(createjs.ColorMatrix|null)} A clone of this createjs.ColorMatrix.
     */
createjs.ColorMatrix.prototype.clone = function () {  return null; }

    /**
     * Makes sure matrixes are 5x5 (25 long).
     *
     * @param {(Array|null)} matrix 
     * @see [ColorMatrix]
     */
createjs.ColorMatrix.prototype._fixMatrix = function (matrix) {  }

    /**
     * Return a length 25 (5x5) array instance containing this matrix's values.
     *
     * @see [ColorMatrix]
     * @returns {(Array|null)} An array holding this matrix's values.
     */
createjs.ColorMatrix.prototype.toArray = function () {  return null; }

    /**
     * Adjusts the contrast of pixel color.
     * Positive values will increase contrast, negative values will decrease contrast.
     *
     * @param {(number|null)} value A value between -100 & 100.
     * @see [ColorMatrix]
     * @returns {(createjs.ColorMatrix|null)} The ColorMatrix instance the method is called on (useful for chaining calls.)
     */
createjs.ColorMatrix.prototype.adjustContrast = function (value) {  return null; }

    /**
     * Adjusts the brightness of pixel color by adding the specified value to the red, green and blue channels.
     * Positive values will make the image brighter, negative values will make it darker.
     *
     * @param {(number|null)} value A value between -255 & 255 that will be added to the RGB channels.
     * @see [ColorMatrix]
     * @returns {(createjs.ColorMatrix|null)} The ColorMatrix instance the method is called on (useful for chaining calls.)
     */
createjs.ColorMatrix.prototype.adjustBrightness = function (value) {  return null; }

    /**
     * Adjusts the color saturation of the pixel.
     * Positive values will increase saturation, negative values will decrease saturation (trend towards greyscale).
     *
     * @param {(number|null)} value A value between -100 & 100.
     * @see [ColorMatrix]
     * @returns {(createjs.ColorMatrix|null)} The ColorMatrix instance the method is called on (useful for chaining calls.)
     */
createjs.ColorMatrix.prototype.adjustSaturation = function (value) {  return null; }

    /**
     * Make sure values are within the specified range, hue has a limit of 180, brightness is 255, others are 100.
     *
     * @param {(number|null)} value The raw number
     * @param {(number|null)} limit The maximum that the number can be. The minimum is the limit * -1.
     * @see [ColorMatrix]
     */
createjs.ColorMatrix.prototype._cleanValue = function (value, limit) {  }

    /**
     * Concatenates (multiplies) the specified matrix with this one.
     *
     * @param {(Array|null)} matrix An array or ColorMatrix instance.
     * @see [ColorMatrix]
     * @returns {(createjs.ColorMatrix|null)} The ColorMatrix instance the method is called on (useful for chaining calls.)
     */
createjs.ColorMatrix.prototype.concat = function (matrix) {  return null; }

    /**
     * Resets the instance with the specified values.
     *
     * @param {(number|null)} brightness 
     * @param {(number|null)} contrast 
     * @param {(number|null)} saturation 
     * @param {(number|null)} hue 
     * @see [ColorMatrix]
     * @returns {(createjs.ColorMatrix|null)} The ColorMatrix instance the method is called on (useful for chaining calls.)
     */
createjs.ColorMatrix.prototype.setColor = function (brightness, contrast, saturation, hue) {  return null; }

    /**
     * @param {(Array|null)} matrix 
     * @see [ColorMatrix]
     */
createjs.ColorMatrix.prototype._multiplyMatrix = function (matrix) {  }

    /**
     * Shortcut method to adjust brightness, contrast, saturation and hue.
     * Equivalent to calling adjustHue(hue), adjustContrast(contrast),
     * adjustBrightness(brightness), adjustSaturation(saturation), in that order.
     *
     * @param {(number|null)} brightness 
     * @param {(number|null)} contrast 
     * @param {(number|null)} saturation 
     * @param {(number|null)} hue 
     * @see [ColorMatrix]
     * @returns {(createjs.ColorMatrix|null)} The ColorMatrix instance the method is called on (useful for chaining calls.)
     */
createjs.ColorMatrix.prototype.adjustColor = function (brightness, contrast, saturation, hue) {  return null; }

    /**
     * Resets the matrix to identity values.
     *
     * @see [ColorMatrix]
     * @returns {(createjs.ColorMatrix|null)} The ColorMatrix instance the method is called on (useful for chaining calls.)
     */
createjs.ColorMatrix.prototype.reset = function () {  return null; }

    /**
     * Adjusts the hue of the pixel color.
     *
     * @param {(number|null)} value A value between -180 & 180.
     * @see [ColorMatrix]
     * @returns {(createjs.ColorMatrix|null)} The ColorMatrix instance the method is called on (useful for chaining calls.)
     */
createjs.ColorMatrix.prototype.adjustHue = function (value) {  return null; }

    /**
     * Returns a string representation of this object.
     *
     * @see [ColorMatrix]
     * @returns {string} a string representation of the instance.
     */
createjs.ColorMatrix.prototype.toString = function () { return ''; }

    /**
     * Copy the specified matrix's values to this matrix.
     *
     * @param {(Array|null)} matrix An array or ColorMatrix instance.
     * @see [ColorMatrix]
     * @returns {(createjs.ColorMatrix|null)} The ColorMatrix instance the method is called on (useful for chaining calls.)
     */
createjs.ColorMatrix.prototype.copy = function (matrix) {  return null; }

