/** @fileoverview Auto-generated Externs files
 * @externs
 */
/**
 * Applies a color transform to DisplayObjects.
 * 
 * <h4>Example</h4>
 * This example draws a red circle, and then transforms it to Blue. This is accomplished by multiplying all the channels
 * to 0 (except alpha, which is set to 1), and then adding 255 to the blue channel.
 * 
 * var shape = new createjs.Shape().set({x:100,y:100});
 * shape.graphics.beginFill("#ff0000").drawCircle(0,0,50);
 * 
 * shape.filters = [
 * new createjs.ColorFilter(0,0,0,1, 0,0,255,0)
 * ];
 * shape.cache(-50, -50, 100, 100);
 * 
 * See {{#crossLink "Filter"}}{{/crossLink}} for an more information on applying filters.
 *
 * @see [ColorFilter]
 * @param {number=} opt_redMultiplier The amount to multiply against the red channel. This is a range between 0 and 1.
 * @param {number=} opt_greenMultiplier The amount to multiply against the green channel. This is a range between 0 and 1.
 * @param {number=} opt_blueMultiplier The amount to multiply against the blue channel. This is a range between 0 and 1.
 * @param {number=} opt_alphaMultiplier The amount to multiply against the alpha channel. This is a range between 0 and 1.
 * @param {number=} opt_redOffset The amount to add to the red channel after it has been multiplied. This is a range between -255 and 255.
 * @param {number=} opt_greenOffset The amount to add to the green channel after it has been multiplied. This is a range between -255 and 255.
 * @param {number=} opt_blueOffset The amount to add to the blue channel after it has been multiplied. This is a range between -255 and 255.
 * @param {number=} opt_alphaOffset The amount to add to the alpha channel after it has been multiplied. This is a range between -255 and 255.
 * @constructor
 * @extends createjs.Filter
 */
createjs.ColorFilter = function (opt_redMultiplier, opt_greenMultiplier, opt_blueMultiplier, opt_alphaMultiplier, opt_redOffset, opt_greenOffset, opt_blueOffset, opt_alphaOffset) {}




