/** @fileoverview Auto-generated Externs files
 * @externs
 */
/**
 * Passed as the parameter to all mouse/pointer/touch related events. For a listing of mouse events and their properties,
 * see the {{#crossLink "DisplayObject"}}{{/crossLink}} and {{#crossLink "Stage"}}{{/crossLink}} event listings.
 *
 * @see [MouseEvent]
 * @param {string} type The event type.
 * @param {(boolean|null)} bubbles Indicates whether the event will bubble through the display list.
 * @param {(boolean|null)} cancelable Indicates whether the default behaviour of this event can be cancelled.
 * @param {(number|null)} stageX The normalized x position relative to the stage.
 * @param {(number|null)} stageY The normalized y position relative to the stage.
 * @param {(MouseEvent|null)} nativeEvent The native DOM event related to this mouse event.
 * @param {(number|null)} pointerID The unique id for the pointer.
 * @param {(boolean|null)} primary Indicates whether this is the primary pointer in a multitouch environment.
 * @param {(number|null)} rawX The raw x position relative to the stage.
 * @param {(number|null)} rawY The raw y position relative to the stage.
 * @constructor
 * @extends createjs.Event
 */
createjs.MouseEvent = function (type, bubbles, cancelable, stageX, stageY, nativeEvent, pointerID, primary, rawX, rawY) {}


    /**
     * Returns the y position of the mouse in the local coordinate system of the current target (ie. the dispatcher).
     *
     * @see [MouseEvent]
     */
createjs.MouseEvent.prototype._get_localY = function () {  }

    /**
     * Returns the x position of the mouse in the local coordinate system of the current target (ie. the dispatcher).
     *
     * @see [MouseEvent]
     */
createjs.MouseEvent.prototype._get_localX = function () {  }


    /**
     * Indicates whether the event was generated by a touch input (versus a mouse input).
     *
     * @see [MouseEvent]
     */
createjs.MouseEvent.prototype._get_isTouch = function () {  }

