/** @fileoverview Auto-generated Externs files
 * @externs
 */
/**
 * Display one or more lines of dynamic text (not user editable) in the display list. Line wrapping support (using the
 * lineWidth) is very basic, wrapping on spaces and tabs only. Note that as an alternative to Text, you can position HTML
 * text above or below the canvas relative to items in the display list using the {{#crossLink "DisplayObject/localToGlobal"}}{{/crossLink}}
 * method, or using {{#crossLink "DOMElement"}}{{/crossLink}}.
 * 
 * <b>Please note that Text does not support HTML text, and can only display one font style at a time.</b> To use
 * multiple font styles, you will need to create multiple text instances, and position them manually.
 * 
 * <h4>Example</h4>
 * 
 * var text = new createjs.Text("Hello World", "20px Arial", "#ff7700");
 * text.x = 100;
 * text.textBaseline = "alphabetic";
 * 
 * CreateJS Text supports web fonts (the same rules as Canvas). The font must be loaded and supported by the browser
 * before it can be displayed.
 * 
 * <strong>Note:</strong> Text can be expensive to generate, so cache instances where possible. Be aware that not all
 * browsers will render Text exactly the same.
 *
 * @see [Text]
 * @param {string=} opt_text The text to display.
 * @param {string=} opt_font The font style to use. Any valid value for the CSS font attribute is acceptable (ex. "bold 36px Arial").
 * @param {string=} opt_color The color to draw the text in. Any valid value for the CSS color attribute is acceptable (ex. "#F00", "red", or "#FF0000").
 * @constructor
 * @extends createjs.DisplayObject
 */
createjs.Text = function (opt_text, opt_font, opt_color) {}

    /**
     * @type {string} 
     * @see [missing]
     */
createjs.Text.prototype.text;

    /**
     * @type {string} 
     * @see [missing]
     */
createjs.Text.prototype.textAlign;

    /**
     * @type {string} 
     * @see [missing]
     */
createjs.Text.prototype.textBaseline;

    /**
     * @param {(CanvasRenderingContext2D|null)} ctx 
     * @see [Text]
     * @returns {(CanvasRenderingContext2D|null)} 
     */
createjs.Text.prototype._prepContext = function (ctx) {  return null; }

    /**
     * Returns the measured, untransformed width of the text without wrapping. Use getBounds for a more robust value.
     *
     * @see [Text]
     * @returns {(number|null)} The measured, untransformed width of the text.
     */
createjs.Text.prototype.getMeasuredWidth = function () { return 0; }


    /**
     * @param {(CanvasRenderingContext2D|null)} ctx 
     * @param {string} text 
     * @param {(number|null)} y 
     * @see [Text]
     */
createjs.Text.prototype._drawTextLine = function (ctx, text, y) {  }

    /**
     * Returns an object with width, height, and lines properties. The width and height are the visual width and height
     * of the drawn text. The lines property contains an array of strings, one for
     * each line of text that will be drawn, accounting for line breaks and wrapping. These strings have trailing
     * whitespace removed.
     *
     * @see [Text]
     * @returns {(Object|null)} An object with width, height, and lines properties.
     */
createjs.Text.prototype.getMetrics = function () {  return null; }

    /**
     * Returns an approximate line height of the text, ignoring the lineHeight property. This is based on the measured
     * width of a "M" character multiplied by 1.2, which provides an approximate line height for most fonts.
     *
     * @see [Text]
     * @returns {(number|null)} an approximate line height of the text, ignoring the lineHeight property. This is based on the measured width of a "M" character multiplied by 1.2, which approximates em for most fonts.
     */
createjs.Text.prototype.getMeasuredLineHeight = function () { return 0; }

    /**
     * Draws multiline text.
     *
     * @param {(CanvasRenderingContext2D|null)} ctx 
     * @param {(Object|null)} o 
     * @param {(Array|null)} lines 
     * @see [Text]
     * @returns {(Object|null)} 
     */
createjs.Text.prototype._drawText = function (ctx, o, lines) {  return null; }




    /**
     * @param {string} text 
     * @see [Text]
     */
createjs.Text.prototype._getMeasuredWidth = function (text) {  }

    /**
     * Returns the approximate height of multi-line text by multiplying the number of lines against either the
     * <code>lineHeight</code> (if specified) or {{#crossLink "Text/getMeasuredLineHeight"}}{{/crossLink}}. Note that
     * this operation requires the text flowing logic to run, which has an associated CPU cost.
     *
     * @see [Text]
     * @returns {(number|null)} The approximate height of the untransformed multi-line text.
     */
createjs.Text.prototype.getMeasuredHeight = function () { return 0; }



