/** @fileoverview Auto-generated Externs files
 * @externs
 */
/**
 * A stage is the root level {{#crossLink "Container"}}{{/crossLink}} for a display list. Each time its {{#crossLink "Stage/tick"}}{{/crossLink}}
 * method is called, it will render its display list to its target canvas.
 * 
 * <h4>Example</h4>
 * This example creates a stage, adds a child to it, then uses {{#crossLink "Ticker"}}{{/crossLink}} to update the child
 * and redraw the stage using {{#crossLink "Stage/update"}}{{/crossLink}}.
 * 
 * var stage = new createjs.Stage("canvasElementId");
 * var image = new createjs.Bitmap("imagePath.png");
 * stage.addChild(image);
 * createjs.Ticker.addEventListener("tick", handleTick);
 * function handleTick(event) {
 * image.x += 10;
 * stage.update();
 * }
 *
 * @see [Stage]
 * @param {(HTMLCanvasElement|Object|null)} canvas A canvas object that the Stage will render to, or the string id of a canvas object in the current document.
 * @constructor
 * @extends createjs.Container
 */
createjs.Stage = function (canvas) {}

    /**
     * Generated doc for missing field JSDoc.
     *
     * @see [Stage]
     */
createjs.Stage.prototype.nextStage;

    /**
     * Each time the update method is called, the stage will call {{#crossLink "Stage/tick"}}{{/crossLink}}
     * unless {{#crossLink "Stage/tickOnUpdate:property"}}{{/crossLink}} is set to false,
     * and then render the display list to the canvas.
     *
     * @param {Object=} opt_props Props object to pass to `tick()`. Should usually be a {{#crossLink "Ticker"}}{{/crossLink}} event object, or similar object with a delta property.
     * @see [Stage]
     */
createjs.Stage.prototype.update = function (opt_props) {  }

    /**
     * @param {(number|null)} id 
     * @param {(Event|null)} e 
     * @param {(number|null)} pageX 
     * @param {(number|null)} pageY 
     * @param {(createjs.Stage|null)} owner Indicates that the event has already been captured & handled by the indicated stage.
     * @see [Stage]
     */
createjs.Stage.prototype._handlePointerDown = function (id, e, pageX, pageY, owner) {  }


    /**
     * @param {(boolean|null)} clear If true, clears the mouseover / rollover (ie. no target)
     * @param {(createjs.Stage|null)} owner Indicates that the event has already been captured & handled by the indicated stage.
     * @param {(createjs.Stage|null)} eventTarget The stage that the cursor is actively over.
     * @see [Stage]
     */
createjs.Stage.prototype._testMouseOver = function (clear, owner, eventTarget) {  }

    /**
     * Default event handler that calls the Stage {{#crossLink "Stage/update"}}{{/crossLink}} method when a {{#crossLink "DisplayObject/tick:event"}}{{/crossLink}}
     * event is received. This allows you to register a Stage instance as a event listener on {{#crossLink "Ticker"}}{{/crossLink}}
     * directly, using:
     * 
     * Ticker.addEventListener("tick", myStage");
     * 
     * Note that if you subscribe to ticks using this pattern, then the tick event object will be passed through to
     * display object tick handlers, instead of <code>delta</code> and <code>paused</code> parameters.
     *
     * @see [Stage]
     */
createjs.Stage.prototype.handleEvent = function (evt) {  }

    /**
     * @param {(HTMLElement|null)} e 
     * @see [Stage]
     */
createjs.Stage.prototype._getElementRect = function (e) {  }

    /**
     * Enables or disables (by passing a frequency of 0) mouse over ({{#crossLink "DisplayObject/mouseover:event"}}{{/crossLink}}
     * and {{#crossLink "DisplayObject/mouseout:event"}}{{/crossLink}}) and roll over events ({{#crossLink "DisplayObject/rollover:event"}}{{/crossLink}}
     * and {{#crossLink "DisplayObject/rollout:event"}}{{/crossLink}}) for this stage's display list. These events can
     * be expensive to generate, so they are disabled by default. The frequency of the events can be controlled
     * independently of mouse move events via the optional `frequency` parameter.
     * 
     * <h4>Example</h4>
     * 
     * var stage = new createjs.Stage("canvasId");
     * stage.enableMouseOver(10); // 10 updates per second
     *
     * @param {number=} opt_frequency Optional param specifying the maximum number of times per second to broadcast mouse over/out events. Set to 0 to disable mouse over events completely. Maximum is 50. A lower frequency is less responsive, but uses less CPU.
     * @see [Stage]
     */
createjs.Stage.prototype.enableMouseOver = function (opt_frequency) {  }

    /**
     * Returns a data url that contains a Base64-encoded image of the contents of the stage. The returned data url can
     * be specified as the src value of an image element.
     *
     * @param {string=} opt_backgroundColor The background color to be used for the generated image. Any valid CSS color value is allowed. The default value is a transparent background.
     * @param {string=} opt_mimeType The MIME type of the image format to be create. The default is "image/png". If an unknown MIME type is passed in, or if the browser does not support the specified MIME type, the default value will be used.
     * @see [Stage]
     * @returns {string} a Base64 encoded image.
     */
createjs.Stage.prototype.toDataURL = function (opt_backgroundColor, opt_mimeType) { return ''; }

    /**
     * Enables or disables the event listeners that stage adds to DOM elements (window, document and canvas). It is good
     * practice to disable events when disposing of a Stage instance, otherwise the stage will continue to receive
     * events from the page.
     * 
     * When changing the canvas property you must disable the events on the old canvas, and enable events on the
     * new canvas or mouse events will not work as expected. For example:
     * 
     * mycreatejs.Stage.enableDOMEvents(false);
     * mycreatejs.Stage.canvas = anotherCanvas;
     * mycreatejs.Stage.enableDOMEvents(true);
     *
     * @param {boolean=} opt_enable Indicates whether to enable or disable the events. Default is true.
     * @see [Stage]
     */
createjs.Stage.prototype.enableDOMEvents = function (opt_enable) {  }

    /**
     * @param {(createjs.DisplayObject|null)} target 
     * @param {string} type 
     * @param {(boolean|null)} bubbles 
     * @param {(number|null)} pointerId 
     * @param {(Object|null)} o 
     * @param {MouseEvent=} opt_nativeEvent 
     * @see [Stage]
     */
createjs.Stage.prototype._dispatchMouseEvent = function (target, type, bubbles, pointerId, o, opt_nativeEvent) {  }

    /**
     * Specifies a target stage that will have mouse / touch interactions relayed to it after this stage handles them.
     * This can be useful in cases where you have multiple layered canvases and want user interactions
     * events to pass through. For example, this would relay mouse events from topStage to bottomStage:
     * 
     * topcreatejs.Stage.nextStage = bottomStage;
     * 
     * To disable relaying, set nextStage to null.
     * 
     * MouseOver, MouseOut, RollOver, and RollOut interactions are also passed through using the mouse over settings
     * of the top-most stage, but are only processed if the target stage has mouse over interactions enabled.
     * Considerations when using roll over in relay targets:<OL>
     * <LI> The top-most (first) stage must have mouse over interactions enabled (via enableMouseOver)</LI>
     * <LI> All stages that wish to participate in mouse over interaction must enable them via enableMouseOver</LI>
     * <LI> All relay targets will share the frequency value of the top-most stage</LI>
     * </OL>
     * To illustrate, in this example the targetStage would process mouse over interactions at 10hz (despite passing
     * 30 as it's desired frequency):
     * topcreatejs.Stage.nextStage = targetStage;
     * topcreatejs.Stage.enableMouseOver(10);
     * targetcreatejs.Stage.enableMouseOver(30);
     * 
     * If the target stage's canvas is completely covered by this stage's canvas, you may also want to disable its
     * DOM events using:
     * 
     * targetcreatejs.Stage.enableDOMEvents(false);
     *
     * @see [Stage]
     */
createjs.Stage.prototype._get_nextStage = function () {  }

    /**
     * @param {(MouseEvent|null)} e 
     * @param {(createjs.Stage|null)} owner Indicates that the event has already been captured & handled by the indicated stage.
     * @see [Stage]
     */
createjs.Stage.prototype._handleDoubleClick = function (e, owner) {  }

    /**
     * Clears the target canvas. Useful if {{#crossLink "Stage/autoClear:property"}}{{/crossLink}} is set to `false`.
     *
     * @see [Stage]
     */
createjs.Stage.prototype.clear = function () {  }

    /**
     * Propagates a tick event through the display list. This is automatically called by {{#crossLink "Stage/update"}}{{/crossLink}}
     * unless {{#crossLink "Stage/tickOnUpdate:property"}}{{/crossLink}} is set to false.
     * 
     * If a props object is passed to `tick()`, then all of its properties will be copied to the event object that is
     * propagated to listeners.
     * 
     * Some time-based features in EaselJS (for example {{#crossLink "Sprite/framerate"}}{{/crossLink}} require that
     * a {{#crossLink "Ticker/tick:event"}}{{/crossLink}} event object (or equivalent object with a delta property) be
     * passed as the `props` parameter to `tick()`. For example:
     * 
     * Ticker.on("tick", handleTick);
     * function handleTick(evtObj) {
     * // clone the event object from Ticker, and add some custom data to it:
     * var evt = evtObj.clone().set({greeting:"hello", name:"world"});
     * 
     * // pass it to stage.update():
     * mycreatejs.Stage.update(evt); // subsequently calls tick() with the same param
     * }
     * 
     * // ...
     * myDisplayObject.on("tick", handleDisplayObjectTick);
     * function handleDisplayObjectTick(evt) {
     * console.log(evt.delta); // the delta property from the Ticker tick event object
     * console.log(evt.greeting, evt.name); // custom data: "hello world"
     * }
     *
     * @param {Object=} opt_props An object with properties that should be copied to the event object. Should usually be a Ticker event object, or similar object with a delta property.
     * @see [Stage]
     */
createjs.Stage.prototype.tick = function (opt_props) {  }

    /**
     * @param {(MouseEvent|null)} e 
     * @see [Stage]
     */
createjs.Stage.prototype._handleMouseUp = function (e) {  }

    /**
     * @param {(MouseEvent|null)} e 
     * @see [Stage]
     */
createjs.Stage.prototype._handleMouseMove = function (e) {  }

    /**
     * @param {(number|null)} id 
     * @param {(Event|null)} e 
     * @param {(number|null)} pageX 
     * @param {(number|null)} pageY 
     * @param {(createjs.Stage|null)} owner Indicates that the event has already been captured & handled by the indicated stage.
     * @see [Stage]
     */
createjs.Stage.prototype._handlePointerMove = function (id, e, pageX, pageY, owner) {  }

    /**
     * @param {(number|null)} id 
     * @param {(Event|null)} e 
     * @param {(boolean|null)} clear 
     * @param {(createjs.Stage|null)} owner Indicates that the event has already been captured & handled by the indicated stage.
     * @see [Stage]
     */
createjs.Stage.prototype._handlePointerUp = function (id, e, clear, owner) {  }


    /**
     * @param {(number|null)} id 
     * @see [Stage]
     */
createjs.Stage.prototype._getPointerData = function (id) {  }

    /**
     * Generated doc for missing method JSDoc.
     *
     * @see [Stage]
     */
createjs.Stage.prototype._set_nextStage = function (value) {  }

    /**
     * @param {(MouseEvent|null)} e 
     * @see [Stage]
     */
createjs.Stage.prototype._handleMouseDown = function (e) {  }

    /**
     * @param {(number|null)} id 
     * @param {(Event|null)} e 
     * @param {(number|null)} pageX 
     * @param {(number|null)} pageY 
     * @see [Stage]
     */
createjs.Stage.prototype._updatePointerPosition = function (id, e, pageX, pageY) {  }

