/** @fileoverview Auto-generated Externs files
 * @externs
 */
/**
 * A sprite stage is the root level {{#crossLink "Container"}}{{/crossLink}} for an aggressively optimized display list. Each time its {{#crossLink "Stage/tick"}}{{/crossLink}}
 * method is called, it will render its display list to its target canvas. WebGL content is fully compatible with the existing Context2D renderer.
 * On devices or browsers that don't support WebGL, content will automatically be rendered via canvas 2D.
 * 
 * Restrictions:
 * - only Sprite, SpriteContainer, BitmapText, Bitmap and DOMElement are allowed to be added to the display list.
 * - a child being added (with the exception of DOMElement) MUST have an image or spriteSheet defined on it.
 * - a child's image/spriteSheet MUST never change while being on the display list.
 * 
 * <h4>Example</h4>
 * This example creates a sprite stage, adds a child to it, then uses {{#crossLink "Ticker"}}{{/crossLink}} to update the child
 * and redraw the stage using {{#crossLink "SpriteStage/update"}}{{/crossLink}}.
 * 
 * var stage = new createjs.SpriteStage("canvasElementId", false, false);
 * stage.updateViewport(800, 600);
 * var image = new createjs.Bitmap("imagePath.png");
 * stage.addChild(image);
 * createjs.Ticker.addEventListener("tick", handleTick);
 * function handleTick(event) {
 * image.x += 10;
 * stage.update();
 * }
 * 
 * <strong>Note:</strong> SpriteStage is not included in the minified version of EaselJS.
 *
 * @see [SpriteStage]
 * @param {(HTMLCanvasElement|Object|null)} canvas A canvas object that the SpriteStage will render to, or the string id of a canvas object in the current document.
 * @param {(boolean|null)} preserveDrawingBuffer If true, the canvas is NOT auto-cleared by WebGL (spec discourages true). Useful if you want to usecreatejs.SpriteStage.prototype.autoClear = false.
 * @param {(boolean|null)} antialias Specifies whether or not the browser's WebGL implementation should try to perform antialiasing.
 * @constructor
 * @extends createjs.Stage
 */
createjs.SpriteStage = function (canvas, preserveDrawingBuffer, antialias) {}

    /**
     * Generated doc for missing field JSDoc.
     *
     * @see [SpriteStage]
     */
createjs.SpriteStage.prototype.isWebGL;


    /**
     * Sets up a kid's WebGL texture.
     *
     * @param {(WebGLRenderingContext|null)} ctx The canvas WebGL context object to draw into.
     * @param {(Object|null)} kid The list of kids to draw.
     * @see [SpriteStage]
     * @returns {(WebGLTexture|null)} 
     */
createjs.SpriteStage.prototype._setUpKidTexture = function (ctx, kid) {  return null; }

    /**
     * Updates the maximum total number of boxes points that can be defined per draw call,
     * and updates the buffers with the new array length sizes.
     *
     * @param {(WebGLRenderingContext|null)} ctx 
     * @param {(number|null)} value The new this._maxBoxesPointsPerDraw value.
     * @see [SpriteStage]
     */
createjs.SpriteStage.prototype._setMaxBoxesPoints = function (ctx, value) {  }

    /**
     * Clears an image's texture to free it up for garbage collection.
     *
     * @param {(Image|null)} image 
     * @see [SpriteStage]
     */
createjs.SpriteStage.prototype.clearImageTexture = function (image) {  }




    /**
     * Indicates whether WebGL is being used for rendering. For example, this would be false if WebGL is not
     * supported in the browser.
     *
     * @see [SpriteStage]
     */
createjs.SpriteStage.prototype._get_isWebGL = function () {  }

    /**
     * Sets up the WebGL context for rendering.
     *
     * @see [SpriteStage]
     */
createjs.SpriteStage.prototype._initializeWebGLContext = function () {  }

    /**
     * Draws all the currently defined boxes to the GPU.
     *
     * @param {(WebGLRenderingContext|null)} ctx The canvas WebGL context object to draw into.
     * @see [SpriteStage]
     */
createjs.SpriteStage.prototype._drawToGPU = function (ctx) {  }

    /**
     * Creates the shader program that's going to be used to draw everything.
     *
     * @param {(WebGLRenderingContext|null)} ctx 
     * @see [SpriteStage]
     */
createjs.SpriteStage.prototype._createShaderProgram = function (ctx) {  }

    /**
     * Update the WebGL viewport. Note that this does NOT update the canvas element's width/height.
     *
     * @param {(number|null)} width 
     * @param {(number|null)} height 
     * @see [SpriteStage]
     */
createjs.SpriteStage.prototype.updateViewport = function (width, height) {  }

    /**
     * Sets the color to use when the WebGL canvas has been cleared.
     *
     * @param {(number|null)} r A number between 0 and 1.
     * @param {(number|null)} g A number between 0 and 1.
     * @param {(number|null)} b A number between 0 and 1.
     * @param {(number|null)} a A number between 0 and 1.
     * @see [SpriteStage]
     */
createjs.SpriteStage.prototype._setClearColor = function (r, g, b, a) {  }

    /**
     * Creates a shader from the specified string.
     *
     * @param {(WebGLRenderingContext|null)} ctx 
     * @param {(number|null)} type The type of shader to create.
     * @param {string} str The definition for the shader.
     * @see [SpriteStage]
     * @returns {(WebGLShader|null)} 
     */
createjs.SpriteStage.prototype._createShader = function (ctx, type, str) {  return null; }

    /**
     * Draw all the kids into the WebGL context.
     *
     * @param {(Array|null)} kids The list of kids to draw.
     * @param {(WebGLRenderingContext|null)} ctx The canvas WebGL context object to draw into.
     * @param {(createjs.Matrix2D|null)} parentMVMatrix The parent's global transformation matrix.
     * @see [SpriteStage]
     */
createjs.SpriteStage.prototype._drawWebGLKids = function (kids, ctx, parentMVMatrix) {  }

    /**
     * Sets the WebGL context to use for future draws.
     *
     * @see [SpriteStage]
     * @returns {(WebGLRenderingContext|null)} The newly created context.
     */
createjs.SpriteStage.prototype._setWebGLContext = function () {  return null; }


    /**
     * Initializes rendering with WebGL using the current canvas element.
     *
     * @see [SpriteStage]
     */
createjs.SpriteStage.prototype._initializeWebGL = function () {  }

    /**
     * Sets up the necessary vertices and indices buffers.
     *
     * @param {(WebGLRenderingContext|null)} ctx 
     * @see [SpriteStage]
     */
createjs.SpriteStage.prototype._createBuffers = function (ctx) {  }


