/** @fileoverview Auto-generated Externs files
 * @externs
 */
/**
 * A SpriteContainer is a nestable display list that enables aggressively optimized rendering of bitmap content.
 * In order to accomplish these optimizations, SpriteContainer enforces a few restrictions on its content.
 * 
 * Restrictions:
 * - only Sprite, SpriteContainer, BitmapText and DOMElement are allowed to be added as children.
 * - a spriteSheet MUST be either be passed into the constructor or defined on the first child added.
 * - all children (with the exception of DOMElement) MUST use the same spriteSheet.
 * 
 * <h4>Example</h4>
 * 
 * var data = {
 * images: ["sprites.jpg"],
 * frames: {width:50, height:50},
 * animations: {run:[0,4], jump:[5,8,"run"]}
 * };
 * var spriteSheet = new createjs.SpriteSheet(data);
 * var container = new createjs.SpriteContainer(spriteSheet);
 * container.addChild(spriteInstance, spriteInstance2);
 * container.x = 100;
 * 
 * <strong>Note:</strong> SpriteContainer is not included in the minified version of EaselJS.
 *
 * @see [SpriteContainer]
 * @param {createjs.SpriteSheet=} opt_spriteSheet The spriteSheet to use for this SpriteContainer and its children.
 * @constructor
 * @extends createjs.Container
 */
createjs.SpriteContainer = function (opt_spriteSheet) {}




