/** @fileoverview Auto-generated Externs files
 * @externs
 */
/**
 * Displays a frame or sequence of frames (ie. an animation) from a SpriteSheet instance. A sprite sheet is a series of
 * images (usually animation frames) combined into a single image. For example, an animation consisting of 8 100x100
 * images could be combined into a 400x200 sprite sheet (4 frames across by 2 high). You can display individual frames,
 * play frames as an animation, and even sequence animations together.
 * 
 * See the {{#crossLink "SpriteSheet"}}{{/crossLink}} class for more information on setting up frames and animations.
 * 
 * <h4>Example</h4>
 * 
 * var instance = new createjs.Sprite(spriteSheet);
 * instance.gotoAndStop("frameName");
 * 
 * Until {{#crossLink "Sprite/gotoAndStop"}}{{/crossLink}} or {{#crossLink "Sprite/gotoAndPlay"}}{{/crossLink}} is called,
 * only the first defined frame defined in the sprite sheet will be displayed.
 *
 * @see [Sprite]
 * @param {(createjs.SpriteSheet|null)} spriteSheet The SpriteSheet instance to play back. This includes the source image(s), frame dimensions, and frame data. See {{#crossLink "SpriteSheet"}}{{/crossLink}} for more information.
 * @param {(number|string)=} opt_frameOrAnimation The frame number or animation to play initially.
 * @constructor
 * @extends createjs.DisplayObject
 */
createjs.Sprite = function (spriteSheet, opt_frameOrAnimation) {}

    /**
     * Stop playing a running animation. The Sprite will be playing if {{#crossLink "Sprite/gotoAndPlay"}}{{/crossLink}}
     * is called. Note that calling {{#crossLink "Sprite/gotoAndPlay"}}{{/crossLink}} or {{#crossLink "Sprite/play"}}{{/crossLink}}
     * will resume playback.
     *
     * @see [Sprite]
     */
createjs.Sprite.prototype.stop = function () {  }


    /**
     * Normalizes the current frame, advancing animations and dispatching callbacks as appropriate.
     *
     * @see [Sprite]
     */
createjs.Sprite.prototype._normalizeFrame = function (frameDelta) {  }

    /**
     * Dispatches the "animationend" event. Returns true if a handler changed the animation (ex. calling {{#crossLink "Sprite/stop"}}{{/crossLink}},
     * {{#crossLink "Sprite/gotoAndPlay"}}{{/crossLink}}, etc.)
     *
     * @see [Sprite]
     */
createjs.Sprite.prototype._dispatchAnimationEnd = function (animation, frame, paused, next, end) {  }

    /**
     * Sets paused to true and seeks to the specified animation name, named frame, or frame number.
     *
     * @param {(number|string|null)} frameOrAnimation The frame number or animation name that the playhead should move to and stop.
     * @see [Sprite]
     */
createjs.Sprite.prototype.gotoAndStop = function (frameOrAnimation) {  }

    /**
     * Play (unpause) the current animation. The Sprite will be paused if either {{#crossLink "Sprite/stop"}}{{/crossLink}}
     * or {{#crossLink "Sprite/gotoAndStop"}}{{/crossLink}} is called. Single frame animations will remain
     * unchanged.
     *
     * @see [Sprite]
     */
createjs.Sprite.prototype.play = function () {  }





    /**
     * Moves the playhead to the specified frame number or animation.
     *
     * @param {(number|string|null)} frameOrAnimation The frame number or animation that the playhead should move to.
     * @param {boolean=} opt_frame The frame of the animation to go to. Defaults to 0.
     * @see [Sprite]
     */
createjs.Sprite.prototype._goto = function (frameOrAnimation, opt_frame) {  }



    /**
     * Sets paused to false and plays the specified animation name, named frame, or frame number.
     *
     * @param {(number|string|null)} frameOrAnimation The frame number or animation name that the playhead should move to and begin playing.
     * @see [Sprite]
     */
createjs.Sprite.prototype.gotoAndPlay = function (frameOrAnimation) {  }

    /**
     * Advances the playhead. This occurs automatically each tick by default.
     *
     * @param {(number|null)} time The amount of time in ms to advance by. Only applicable if framerate is set on the Sprite or its SpriteSheet.
     * @see [Sprite]
     */
createjs.Sprite.prototype.advance = function (time) {  }

