/** @fileoverview Auto-generated Externs files
 * @externs
 */
/**
 * The MovieClip class associates a TweenJS Timeline with an EaselJS {{#crossLink "Container"}}{{/crossLink}}. It allows
 * you to create objects which encapsulate timeline animations, state changes, and synched actions. Due to the
 * complexities inherent in correctly setting up a MovieClip, it is largely intended for tool output and is not included
 * in the main EaselJS library.
 * 
 * Currently MovieClip only works properly if it is tick based (as opposed to time based) though some concessions have
 * been made to support time-based timelines in the future.
 * 
 * <h4>Example</h4>
 * This example animates two shapes back and forth. The grey shape starts on the left, but we jump to a mid-point in
 * the animation using {{#crossLink "MovieClip/gotoAndPlay"}}{{/crossLink}}.
 * 
 * var stage = new createjs.Stage("canvas");
 * createjs.Ticker.addEventListener("tick", stage);
 * 
 * var mc = new createjs.MovieClip(null, 0, true, {start:20});
 * stage.addChild(mc);
 * 
 * var child1 = new createjs.Shape(
 * new createjs.Graphics().beginFill("#999999")
 * .drawCircle(30,30,30));
 * var child2 = new createjs.Shape(
 * new createjs.Graphics().beginFill("#5a9cfb")
 * .drawCircle(30,30,30));
 * 
 * mc.timeline.addTween(
 * createjs.Tween.get(child1)
 * .to({x:0}).to({x:60}, 50).to({x:0}, 50));
 * mc.timeline.addTween(
 * createjs.Tween.get(child2)
 * .to({x:60}).to({x:0}, 50).to({x:60}, 50));
 * 
 * mc.gotoAndPlay("start");
 * 
 * It is recommended to use <code>tween.to()</code> to animate and set properties (use no duration to have it set
 * immediately), and the <code>tween.wait()</code> method to create delays between animations. Note that using the
 * <code>tween.set()</code> method to affect properties will likely not provide the desired result.
 *
 * @see [MovieClip]
 * @param {string=} opt_mode Initial value for the mode property. One of createjs.MovieClip.INDEPENDENT, createjs.MovieClip.SINGLE_FRAME, or createjs.MovieClip.SYNCHED. The default is createjs.MovieClip.INDEPENDENT.
 * @param {number=} opt_startPosition Initial value for the startPosition property.
 * @param {boolean=} opt_loop Initial value for the loop property. The default is true.
 * @param {Object=} opt_labels A hash of labels to pass to the timeline instance associated with this createjs.MovieClip. Labels only need to be passed if they need to be used.
 * @constructor
 * @extends createjs.Container
 */
createjs.MovieClip = function (opt_mode, opt_startPosition, opt_loop, opt_labels) {}

    /**
     * Sets paused to true.
     *
     * @see [MovieClip]
     */
createjs.MovieClip.prototype.stop = function () {  }


    /**
     * Advances this movie clip to the specified position or label and sets paused to true.
     *
     * @param {(number|string|null)} positionOrLabel The animation or frame name to go to.
     * @see [MovieClip]
     */
createjs.MovieClip.prototype.gotoAndStop = function (positionOrLabel) {  }

    /**
     * Use the {{#crossLink "MovieClip/currentLabel:property"}}{{/crossLink}} property instead.
     *
     * @see [MovieClip]
     * @returns {string} 
     */
createjs.MovieClip.prototype.getCurrentLabel = function () { return ''; }

    /**
     * Sets paused to false.
     *
     * @see [MovieClip]
     */
createjs.MovieClip.prototype.play = function () {  }

    /**
     * @param {(Array|null)} state 
     * @param {(number|null)} offset 
     * @see [MovieClip]
     */
createjs.MovieClip.prototype._setState = function (state, offset) {  }

    /**
     * @see [MovieClip]
     */
createjs.MovieClip.prototype._reset = function () {  }


    /**
     * Adds a child to the timeline, and sets it up as a managed child.
     *
     * @param {(createjs.MovieClip|null)} child The child MovieClip to manage
     * @param {(number|null)} offset 
     * @see [MovieClip]
     */
createjs.MovieClip.prototype._addManagedChild = function (child, offset) {  }




    /**
     * @param {(number|string|null)} positionOrLabel The animation name or frame number to go to.
     * @see [MovieClip]
     */
createjs.MovieClip.prototype._goto = function (positionOrLabel) {  }

    /**
     * Use the {{#crossLink "MovieClip/labels:property"}}{{/crossLink}} property instead.
     *
     * @see [MovieClip]
     * @returns {(Array|null)} 
     */
createjs.MovieClip.prototype.getLabels = function () {  return null; }

    /**
     * @see [MovieClip]
     */
createjs.MovieClip.prototype._updateTimeline = function () {  }


    /**
     * Advances this movie clip to the specified position or label and sets paused to false.
     *
     * @param {(number|string|null)} positionOrLabel The animation name or frame number to go to.
     * @see [MovieClip]
     */
createjs.MovieClip.prototype.gotoAndPlay = function (positionOrLabel) {  }

    /**
     * Advances the playhead. This occurs automatically each tick by default.
     *
     * @param {(number|null)} time The amount of time in ms to advance by. Only applicable if framerate is set.
     * @see [MovieClip]
     */
createjs.MovieClip.prototype.advance = function (time) {  }

