/** @fileoverview Auto-generated Externs files
 * @externs
 */
/**
 * DisplayObject is an abstract class that should not be constructed directly. Instead construct subclasses such as
 * {{#crossLink "Container"}}{{/crossLink}}, {{#crossLink "Bitmap"}}{{/crossLink}}, and {{#crossLink "Shape"}}{{/crossLink}}.
 * DisplayObject is the base class for all display classes in the EaselJS library. It defines the core properties and
 * methods that are shared between all display objects, such as transformation properties (x, y, scaleX, scaleY, etc),
 * caching, and mouse handlers.
 *
 * @see [DisplayObject]
 * @constructor
 * @extends createjs.EventDispatcher
 */
createjs.DisplayObject = function () {}

    /**
     * @type {number} 
     * @see [missing]
     */
createjs.DisplayObject.prototype.height;

    /**
     * @type {boolean} 
     * @see [missing]
     */
createjs.DisplayObject.prototype.visible;

    /**
     * @type {number} 
     * @see [missing]
     */
createjs.DisplayObject.prototype.alpha;

    /**
     * @type {string} 
     * @see [missing]
     */
createjs.DisplayObject.prototype.name;

    /**
     * @type {number} 
     * @see [missing]
     */
createjs.DisplayObject.prototype.width;

    /**
     * @type {(createjs.Graphics|null)} 
     * @see [missing]
     */
createjs.DisplayObject.prototype.graphics;

    /**
     * Returns the Stage instance that this display object will be rendered on, or null if it has not been added to one.
     *
     * @type {(createjs.Stage|null)} 
     * @see [DisplayObject]
     */
createjs.DisplayObject.prototype.stage;

    /**
     * @type {number} 
     * @see [missing]
     */
createjs.DisplayObject.prototype.y;

    /**
     * @type {number} 
     * @see [missing]
     */
createjs.DisplayObject.prototype.x;

    /**
     * Applies this display object's transformation, alpha, globalCompositeOperation, clipping path (mask), and shadow
     * to the specified context. This is typically called prior to {{#crossLink "DisplayObject/draw"}}{{/crossLink}}.
     *
     * @param {(CanvasRenderingContext2D|null)} ctx The canvas 2D to update.
     * @see [DisplayObject]
     */
createjs.DisplayObject.prototype.updateContext = function (ctx) {  }

    /**
     * Provides a chainable shortcut method for setting a number of properties on the instance.
     * 
     * <h4>Example</h4>
     * 
     * var myGraphics = new createjs.Graphics().beginFill("#ff0000").drawCircle(0, 0, 25);
     * var shape = stage.addChild(new Shape()).set({graphics:myGraphics, x:100, y:100, alpha:0.5});
     *
     * @param {(Object|null)} props A generic object containing properties to copy to the DisplayObject instance.
     * @see [DisplayObject]
     * @returns {(createjs.DisplayObject|null)} Returns the instance the method is called on (useful for chaining calls.)
     */
createjs.DisplayObject.prototype.set = function (props) {  return null; }

    /**
     * Transforms the specified x and y position from the coordinate space of the display object
     * to the global (stage) coordinate space. For example, this could be used to position an HTML label
     * over a specific point on a nested display object. Returns a Point instance with x and y properties
     * correlating to the transformed coordinates on the stage.
     * 
     * <h4>Example</h4>
     * 
     * displayObject.x = 300;
     * displayObject.y = 200;
     * stage.addChild(displayObject);
     * var point = mycreatejs.DisplayObject.localToGlobal(100, 100);
     * // Results in x=400, y=300
     *
     * @param {(number|null)} x The x position in the source display object to transform.
     * @param {(number|null)} y The y position in the source display object to transform.
     * @param {(Object|createjs.Point)=} opt_pt An object to copy the result into. If omitted a new Point object with x/y properties will be returned.
     * @see [DisplayObject]
     * @returns {(createjs.Point|null)} A Point instance with x and y properties correlating to the transformed coordinates on the stage.
     */
createjs.DisplayObject.prototype.localToGlobal = function (x, y, opt_pt) {  return null; }

    /**
     * @param {(CanvasRenderingContext2D|null)} ctx 
     * @see [DisplayObject]
     * @returns {(boolean|null)} 
     */
createjs.DisplayObject.prototype._testHit = function (ctx) {  return null; }

    /**
     * @see [DisplayObject]
     * @returns {(createjs.Rectangle|null)} 
     */
createjs.DisplayObject.prototype._getFilterBounds = function (rect) {  return null; }

    /**
     * Indicates whether the display object has any mouse event listeners or a cursor.
     *
     * @see [DisplayObject]
     * @returns {(boolean|null)} 
     */
createjs.DisplayObject.prototype._hasMouseEventListener = function () {  return null; }

    /**
     * @param {(createjs.Matrix2D|null)} matrix 
     * @param {(boolean|null)} ignoreTransform If true, does not apply this object's transform.
     * @see [DisplayObject]
     * @returns {(createjs.Rectangle|null)} 
     */
createjs.DisplayObject.prototype._getBounds = function (matrix, ignoreTransform) {  return null; }

    /**
     * @param {(createjs.Rectangle|null)} bounds 
     * @param {(createjs.Matrix2D|null)} matrix 
     * @param {(boolean|null)} ignoreTransform 
     * @see [DisplayObject]
     * @returns {(createjs.Rectangle|null)} 
     */
createjs.DisplayObject.prototype._transformBounds = function (bounds, matrix, ignoreTransform) {  return null; }

    /**
     * Draws the display object into the specified context ignoring its visible, alpha, shadow, and transform.
     * Returns <code>true</code> if the draw was handled (useful for overriding functionality).
     * 
     * NOTE: This method is mainly for internal use, though it may be useful for advanced uses.
     *
     * @param {(CanvasRenderingContext2D|null)} ctx The canvas 2D context object to draw into.
     * @param {boolean=} opt_ignoreCache Indicates whether the draw operation should ignore any current cache. For example, used for drawing the cache (to prevent it from simply drawing an existing cache back into itself).
     * @see [DisplayObject]
     * @returns {(boolean|null)} 
     */
createjs.DisplayObject.prototype.draw = function (ctx, opt_ignoreCache) {  return null; }

    /**
     * @param {(Object|null)} evtObj An event object that will be dispatched to all tick listeners. This object is reused between dispatchers to reduce construction & GC costs.
     * @see [DisplayObject]
     */
createjs.DisplayObject.prototype._tick = function (evtObj) {  }

    /**
     * Tests whether the display object intersects the specified point in local coordinates (ie. draws a pixel with alpha > 0 at
     * the specified position). This ignores the alpha, shadow, hitArea, mask, and compositeOperation of the display object.
     * 
     * <h4>Example</h4>
     * 
     * stage.addEventListener("stagemousedown", handleMouseDown);
     * function handleMouseDown(event) {
     * var hit = myShape.hitTest(event.stageX, event.stageY);
     * }
     * 
     * Please note that shape-to-shape collision is not currently supported by EaselJS.
     *
     * @param {(number|null)} x The x position to check in the display object's local coordinates.
     * @param {(number|null)} y The y position to check in the display object's local coordinates.
     * @see [DisplayObject]
     * @returns {(boolean|null)} A Boolean indicating whether a visible portion of the DisplayObject intersect the specified local Point.
     */
createjs.DisplayObject.prototype.hitTest = function (x, y) {  return null; }

    /**
     * Returns true or false indicating whether the display object would be visible if drawn to a canvas.
     * This does not account for whether it would be visible within the boundaries of the stage.
     * 
     * NOTE: This method is mainly for internal use, though it may be useful for advanced uses.
     *
     * @see [DisplayObject]
     * @returns {(boolean|null)} Boolean indicating whether the display object would be visible if drawn to a canvas
     */
createjs.DisplayObject.prototype.isVisible = function () {  return null; }

    /**
     * @see [DisplayObject]
     */
createjs.DisplayObject.prototype._applyFilters = function () {  }

    /**
     * Redraws the display object to its cache. Calling updateCache without an active cache will throw an error.
     * If compositeOperation is null the current cache will be cleared prior to drawing. Otherwise the display object
     * will be drawn over the existing cache using the specified compositeOperation.
     * 
     * <h4>Example</h4>
     * Clear the current graphics of a cached shape, draw some new instructions, and then update the cache. The new line
     * will be drawn on top of the old one.
     * 
     * // Not shown: Creating the shape, and caching it.
     * shapeInstance.clear();
     * shapeInstance.setStrokeStyle(3).beginStroke("#ff0000").moveTo(100, 100).lineTo(200,200);
     * shapeInstance.updateCache();
     *
     * @param {string} compositeOperation The compositeOperation to use, or null to clear the cache and redraw it. <a href="http://www.whatwg.org/specs/web-apps/current-work/multipage/the-canvas-element.html#compositing"> whatwg spec on compositing</a>.
     * @see [DisplayObject]
     */
createjs.DisplayObject.prototype.updateCache = function (compositeOperation) {  }

    /**
     * Returns a rectangle representing this object's bounds in its local coordinate system (ie. with no transformation).
     * Objects that have been cached will return the bounds of the cache.
     * 
     * Not all display objects can calculate their own bounds (ex. Shape). For these objects, you can use
     * {{#crossLink "DisplayObject/setBounds"}}{{/crossLink}} so that they are included when calculating Container
     * bounds.
     * 
     * <table>
     * <tr><td><b>All</b></td><td>
     * All display objects support setting bounds manually using setBounds(). Likewise, display objects that
     * have been cached using cache() will return the bounds of their cache. Manual and cache bounds will override
     * the automatic calculations listed below.
     * </td></tr>
     * <tr><td><b>Bitmap</b></td><td>
     * Returns the width and height of the sourceRect (if specified) or image, extending from (x=0,y=0).
     * </td></tr>
     * <tr><td><b>Sprite</b></td><td>
     * Returns the bounds of the current frame. May have non-zero x/y if a frame registration point was specified
     * in the spritesheet data. See also {{#crossLink "SpriteSheet/getFrameBounds"}}{{/crossLink}}
     * </td></tr>
     * <tr><td><b>Container</b></td><td>
     * Returns the aggregate (combined) bounds of all children that return a non-null value from getBounds().
     * </td></tr>
     * <tr><td><b>Shape</b></td><td>
     * Does not currently support automatic bounds calculations. Use setBounds() to manually define bounds.
     * </td></tr>
     * <tr><td><b>Text</b></td><td>
     * Returns approximate bounds. Horizontal values (x/width) are quite accurate, but vertical values (y/height) are
     * not, especially when using textBaseline values other than "top".
     * </td></tr>
     * <tr><td><b>BitmapText</b></td><td>
     * Returns approximate bounds. Values will be more accurate if spritesheet frame registration points are close
     * to (x=0,y=0).
     * </td></tr>
     * </table>
     * 
     * Bounds can be expensive to calculate for some objects (ex. text, or containers with many children), and
     * are recalculated each time you call getBounds(). You can prevent recalculation on static objects by setting the
     * bounds explicitly:
     * 
     * var bounds = obj.getBounds();
     * obj.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
     * // getBounds will now use the set values, instead of recalculating
     * 
     * To reduce memory impact, the returned Rectangle instance may be reused internally; clone the instance or copy its
     * values if you need to retain it.
     * 
     * var myBounds = obj.getBounds().clone();
     * // OR:
     * myRect.copy(obj.getBounds());
     *
     * @see [DisplayObject]
     * @returns {(createjs.Rectangle|null)} A Rectangle instance representing the bounds, or null if bounds are not available for this object.
     */
createjs.DisplayObject.prototype.getBounds = function () {  return null; }

    /**
     * Clears the current cache. See {{#crossLink "DisplayObject/cache"}}{{/crossLink}} for more information.
     *
     * @see [DisplayObject]
     */
createjs.DisplayObject.prototype.uncache = function () {  }

    /**
     * Transforms the specified x and y position from the global (stage) coordinate space to the
     * coordinate space of the display object. For example, this could be used to determine
     * the current mouse position within the display object. Returns a Point instance with x and y properties
     * correlating to the transformed position in the display object's coordinate space.
     * 
     * <h4>Example</h4>
     * 
     * displayObject.x = 300;
     * displayObject.y = 200;
     * stage.addChild(displayObject);
     * var point = mycreatejs.DisplayObject.globalToLocal(100, 100);
     * // Results in x=-200, y=-100
     *
     * @param {(number|null)} x The x position on the stage to transform.
     * @param {(number|null)} y The y position on the stage to transform.
     * @param {(Object|createjs.Point)=} opt_pt An object to copy the result into. If omitted a new Point object with x/y properties will be returned.
     * @see [DisplayObject]
     * @returns {(createjs.Point|null)} A Point instance with x and y properties correlating to the transformed position in the display object's coordinate space.
     */
createjs.DisplayObject.prototype.globalToLocal = function (x, y, opt_pt) {  return null; }

    /**
     * @param {(CanvasRenderingContext2D|null)} ctx 
     * @param {(createjs.Shadow|null)} shadow 
     * @see [DisplayObject]
     */
createjs.DisplayObject.prototype._applyShadow = function (ctx, shadow) {  }

    /**
     * Returns a clone of this createjs.DisplayObject. Some properties that are specific to this instance's current context are
     * reverted to their defaults (for example .parent). Caches are not maintained across clones, and some elements
     * are copied by reference (masks, individual filter instances, hit area)
     *
     * @see [DisplayObject]
     * @returns {(createjs.DisplayObject|null)} A clone of the current DisplayObject instance.
     */
createjs.DisplayObject.prototype.clone = function () {  return null; }

    /**
     * Draws the display object into a new canvas, which is then used for subsequent draws. For complex content
     * that does not change frequently (ex. a Container with many children that do not move, or a complex vector Shape),
     * this can provide for much faster rendering because the content does not need to be re-rendered each tick. The
     * cached display object can be moved, rotated, faded, etc freely, however if its content changes, you must
     * manually update the cache by calling <code>updateCache()</code> or <code>cache()</code> again. You must specify
     * the cache area via the x, y, w, and h parameters. This defines the rectangle that will be rendered and cached
     * using this display object's coordinates.
     * 
     * <h4>Example</h4>
     * For example if you defined a Shape that drew a circle at 0, 0 with a radius of 25:
     * 
     * var shape = new createjs.Shape();
     * shape.graphics.beginFill("#ff0000").drawCircle(0, 0, 25);
     * myShape.cache(-25, -25, 50, 50);
     * 
     * Note that filters need to be defined <em>before</em> the cache is applied. Check out the {{#crossLink "Filter"}}{{/crossLink}}
     * class for more information. Some filters (ex. BlurFilter) will not work as expected in conjunction with the scale param.
     * 
     * Usually, the resulting cacheCanvas will have the dimensions width*scale by height*scale, however some filters (ex. BlurFilter)
     * will add padding to the canvas dimensions.
     *
     * @param {(number|null)} x The x coordinate origin for the cache region.
     * @param {(number|null)} y The y coordinate origin for the cache region.
     * @param {(number|null)} width The width of the cache region.
     * @param {(number|null)} height The height of the cache region.
     * @param {number=} opt_scale The scale at which the cache will be created. For example, if you cache a vector shape using myShape.cache(0,0,100,100,2) then the resulting cacheCanvas will be 200x200 px. This lets you scale and rotate cached elements with greater fidelity. Default is 1.
     * @see [DisplayObject]
     */
createjs.DisplayObject.prototype.cache = function (x, y, width, height, opt_scale) {  }

    /**
     * Returns a rectangle representing this object's bounds in its parent's coordinate system (ie. with transformations applied).
     * Objects that have been cached will return the transformed bounds of the cache.
     * 
     * Not all display objects can calculate their own bounds (ex. Shape). For these objects, you can use
     * {{#crossLink "DisplayObject/setBounds"}}{{/crossLink}} so that they are included when calculating Container
     * bounds.
     * 
     * To reduce memory impact, the returned Rectangle instance may be reused internally; clone the instance or copy its
     * values if you need to retain it.
     * 
     * Container instances calculate aggregate bounds for all children that return bounds via getBounds.
     *
     * @see [DisplayObject]
     * @returns {(createjs.Rectangle|null)} A Rectangle instance representing the bounds, or null if bounds are not available for this object.
     */
createjs.DisplayObject.prototype.getTransformedBounds = function () {  return null; }

    /**
     * Shortcut method to quickly set the transform properties on the display object. All parameters are optional.
     * Omitted parameters will have the default value set.
     * 
     * <h4>Example</h4>
     * 
     * displayObject.setTransform(100, 100, 2, 2);
     *
     * @param {number=} opt_x The horizontal translation (x position) in pixels
     * @param {number=} opt_y The vertical translation (y position) in pixels
     * @param {number=} opt_scaleX The horizontal scale, as a percentage of 1
     * @param {number=} opt_scaleY the vertical scale, as a percentage of 1
     * @param {number=} opt_rotation The rotation, in degrees
     * @param {number=} opt_skewX The horizontal skew factor
     * @param {number=} opt_skewY The vertical skew factor
     * @param {number=} opt_regX The horizontal registration point in pixels
     * @param {number=} opt_regY The vertical registration point in pixels
     * @see [DisplayObject]
     * @returns {(createjs.DisplayObject|null)} Returns this instance. Useful for chaining commands.
     */
createjs.DisplayObject.prototype.setTransform = function (opt_x, opt_y, opt_scaleX, opt_scaleY, opt_rotation, opt_skewX, opt_skewY, opt_regX, opt_regY) {  return null; }

    /**
     * Generates a Matrix2D object representing the combined transform of the display object and all of its
     * parent Containers up to the highest level ancestor (usually the {{#crossLink "Stage"}}{{/crossLink}}). This can
     * be used to transform positions between coordinate spaces, such as with {{#crossLink "DisplayObject/localToGlobal"}}{{/crossLink}}
     * and {{#crossLink "DisplayObject/globalToLocal"}}{{/crossLink}}.
     *
     * @param {createjs.Matrix2D=} opt_matrix A {{#crossLink "Matrix2D"}}{{/crossLink}} object to populate with the calculated values. If null, a new Matrix2D object is returned.
     * @see [DisplayObject]
     * @returns {(createjs.Matrix2D|null)} The combined matrix.
     */
createjs.DisplayObject.prototype.getConcatenatedMatrix = function (opt_matrix) {  return null; }

    /**
     * Transforms the specified x and y position from the coordinate space of this display object to the coordinate
     * space of the target display object. Returns a Point instance with x and y properties correlating to the
     * transformed position in the target's coordinate space. Effectively the same as using the following code with
     * {{#crossLink "DisplayObject/localToGlobal"}}{{/crossLink}} and {{#crossLink "DisplayObject/globalToLocal"}}{{/crossLink}}.
     * 
     * var pt = this.localToGlobal(x, y);
     * pt = target.globalToLocal(pt.x, pt.y);
     *
     * @param {(number|null)} x The x position in the source display object to transform.
     * @param {(number|null)} y The y position on the source display object to transform.
     * @param {(createjs.DisplayObject|null)} target The target display object to which the coordinates will be transformed.
     * @param {(Object|createjs.Point)=} opt_pt An object to copy the result into. If omitted a new Point object with x/y properties will be returned.
     * @see [DisplayObject]
     * @returns {(createjs.Point|null)} Returns a Point instance with x and y properties correlating to the transformed position in the target's coordinate space.
     */
createjs.DisplayObject.prototype.localToLocal = function (x, y, target, opt_pt) {  return null; }

    /**
     * Allows you to manually specify the bounds of an object that either cannot calculate their own bounds (ex. Shape &
     * Text) for future reference, or so the object can be included in Container bounds. Manually set bounds will always
     * override calculated bounds.
     * 
     * The bounds should be specified in the object's local (untransformed) coordinates. For example, a Shape instance
     * with a 25px radius circle centered at 0,0 would have bounds of (-25, -25, 50, 50).
     *
     * @param {(number|null)} x The x origin of the bounds. Pass null to remove the manual bounds.
     * @param {(number|null)} y The y origin of the bounds.
     * @param {(number|null)} width The width of the bounds.
     * @param {(number|null)} height The height of the bounds.
     * @see [DisplayObject]
     */
createjs.DisplayObject.prototype.setBounds = function (x, y, width, height) {  }

    /**
     * Use the {{#crossLink "DisplayObject/stage:property"}}{{/crossLink}} property instead.
     *
     * @see [DisplayObject]
     * @returns {(createjs.Stage|null)} 
     */
createjs.DisplayObject.prototype.getStage = function () {  return null; }

    /**
     * Returns a data URL for the cache, or null if this display object is not cached.
     * Uses cacheID to ensure a new data URL is not generated if the cache has not changed.
     *
     * @see [DisplayObject]
     * @returns {string} The image data url for the cache.
     */
createjs.DisplayObject.prototype.getCacheDataURL = function () { return ''; }

    /**
     * @param {(createjs.DisplayObject|null)} o The DisplayObject instance which will have properties from the current DisplayObject instance copied into.
     * @see [DisplayObject]
     * @returns {(createjs.DisplayObject|null)} o
     */
createjs.DisplayObject.prototype._cloneProps = function (o) {  return null; }

    /**
     * Generates a DisplayProps object representing the combined display properties of the  object and all of its
     * parent Containers up to the highest level ancestor (usually the {{#crossLink "Stage"}}{{/crossLink}}).
     *
     * @param {createjs.DisplayProps=} opt_props A {{#crossLink "DisplayProps"}}{{/crossLink}} object to populate with the calculated values. If null, a new DisplayProps object is returned.
     * @see [DisplayObject]
     * @returns {(createjs.DisplayProps|null)} The combined display properties.
     */
createjs.DisplayObject.prototype.getConcatenatedDisplayProps = function (opt_props) {  return null; }

    /**
     * Returns a matrix based on this object's current transform.
     *
     * @param {(createjs.Matrix2D|null)} matrix Optional. A Matrix2D object to populate with the calculated values. If null, a new Matrix object is returned.
     * @see [DisplayObject]
     * @returns {(createjs.Matrix2D|null)} A matrix representing this display object's transform.
     */
createjs.DisplayObject.prototype.getMatrix = function (matrix) {  return null; }


