/** @fileoverview Auto-generated Externs files
 * @externs
 */
/**
 * A Container is a nestable display list that allows you to work with compound display elements. For  example you could
 * group arm, leg, torso and head {{#crossLink "Bitmap"}}{{/crossLink}} instances together into a Person Container, and
 * transform them as a group, while still being able to move the individual parts relative to each other. Children of
 * containers have their <code>transform</code> and <code>alpha</code> properties concatenated with their parent
 * createjs.Container.
 * 
 * For example, a {{#crossLink "Shape"}}{{/crossLink}} with x=100 and alpha=0.5, placed in a Container with <code>x=50</code>
 * and <code>alpha=0.7</code> will be rendered to the canvas at <code>x=150</code> and <code>alpha=0.35</code>.
 * Containers have some overhead, so you generally shouldn't create a Container to hold a single child.
 * 
 * <h4>Example</h4>
 * 
 * var container = new createjs.Container();
 * container.addChild(bitmapInstance, shapeInstance);
 * container.x = 100;
 *
 * @see [Container]
 * @constructor
 * @extends createjs.DisplayObject
 */
createjs.Container = function () {}

    /**
     * @type {(Function|null)} 
     * @see [missing]
     */
createjs.Container.prototype.onClick;

    /**
     * Returns the number of children in the container.
     *
     * @type {(number|null)} 
     * @see [Container]
     */
createjs.Container.prototype.numChildren;

    /**
     * Performs an array sort operation on the child list.
     * 
     * <h4>Example: Display children with a higher y in front.</h4>
     * 
     * var sortFunction = function(obj1, obj2, options) {
     * if (obj1.y > obj2.y) { return 1; }
     * if (obj1.y < obj2.y) { return -1; }
     * return 0;
     * }
     * container.sortChildren(sortFunction);
     *
     * @param {(Function|null)} sortFunction the function to use to sort the child list. See JavaScript's <code>Array.sort</code> documentation for details.
     * @see [Container]
     */
createjs.Container.prototype.sortChildren = function (sortFunction) {  }

    /**
     * Returns the index of the specified child in the display list, or -1 if it is not in the display list.
     * 
     * <h4>Example</h4>
     * 
     * var index = container.getChildIndex(child);
     *
     * @param {(createjs.DisplayObject|null)} child The child to return the index of.
     * @see [Container]
     * @returns {(number|null)} The index of the specified child. -1 if the child is not found.
     */
createjs.Container.prototype.getChildIndex = function (child) { return 0; }

    /**
     * Returns true if the specified display object either is this container or is a descendent (child, grandchild, etc)
     * of this container.
     *
     * @param {(createjs.DisplayObject|null)} child The DisplayObject to be checked.
     * @see [Container]
     * @returns {(boolean|null)} true if the specified display object either is this container or is a descendent.
     */
createjs.Container.prototype.contains = function (child) {  return null; }


    /**
     * Adds a child to the display list at the specified index, bumping children at equal or greater indexes up one, and
     * setting its parent to this createjs.Container.
     * 
     * <h4>Example</h4>
     * 
     * addChildAt(child1, index);
     * 
     * You can also add multiple children, such as:
     * 
     * addChildAt(child1, child2, ..., index);
     * 
     * The index must be between 0 and numChildren. For example, to add myShape under otherShape in the display list,
     * you could use:
     * 
     * container.addChildAt(myShape, container.getChildIndex(otherShape));
     * 
     * This would also bump otherShape's index up by one. Fails silently if the index is out of range.
     *
     * @param {(createjs.DisplayObject|null)} child The display object to add.
     * @param {(number|null)} index The index to add the child at.
     * @see [Container]
     * @returns {(createjs.DisplayObject|null)} Returns the last child that was added, or the last child if multiple children were added.
     */
createjs.Container.prototype.addChildAt = function (child, index) {  return null; }

    /**
     * Removes all children from the display list.
     * 
     * <h4>Example</h4>
     * 
     * container.removeAlLChildren();
     *
     * @see [Container]
     */
createjs.Container.prototype.removeAllChildren = function () {  }

    /**
     * Removes the child at the specified index from the display list, and sets its parent to null.
     * 
     * <h4>Example</h4>
     * 
     * container.removeChildAt(2);
     * 
     * You can also remove multiple children:
     * 
     * container.removeChild(2, 7, ...)
     * 
     * Returns true if the child (or children) was removed, or false if any index was out of range.
     *
     * @param {(number|null)} index The index of the child to remove.
     * @see [Container]
     * @returns {(boolean|null)} true if the child (or children) was removed, or false if any index was out of range.
     */
createjs.Container.prototype.removeChildAt = function (index) {  return null; }


    /**
     * Use the {{#crossLink "Container/numChildren:property"}}{{/crossLink}} property instead.
     *
     * @see [Container]
     * @returns {(number|null)} 
     */
createjs.Container.prototype.getNumChildren = function () { return 0; }

    /**
     * Swaps the children at the specified indexes. Fails silently if either index is out of range.
     *
     * @param {(number|null)} index1 
     * @param {(number|null)} index2 
     * @see [Container]
     */
createjs.Container.prototype.swapChildrenAt = function (index1, index2) {  }




    /**
     * Returns the child with the specified name.
     *
     * @param {string} name The name of the child to return.
     * @see [Container]
     * @returns {(createjs.DisplayObject|null)} The child with the specified name.
     */
createjs.Container.prototype.getChildByName = function (name) {  return null; }


    /**
     * Returns the child at the specified index.
     * 
     * <h4>Example</h4>
     * 
     * container.getChildAt(2);
     *
     * @param {(number|null)} index The index of the child to return.
     * @see [Container]
     * @returns {(createjs.DisplayObject|null)} The child at the specified index. Returns null if there is no child at the index.
     */
createjs.Container.prototype.getChildAt = function (index) {  return null; }

    /**
     * Swaps the specified children's depth in the display list. Fails silently if either child is not a child of this
     * createjs.Container.
     *
     * @param {(createjs.DisplayObject|null)} child1 
     * @param {(createjs.DisplayObject|null)} child2 
     * @see [Container]
     */
createjs.Container.prototype.swapChildren = function (child1, child2) {  }

    /**
     * Similar to {{#crossLink "Container/getObjectsUnderPoint"}}{{/crossLink}}, but returns only the top-most display
     * object. This runs significantly faster than <code>getObjectsUnderPoint()</code>, but is still potentially an expensive
     * operation. See {{#crossLink "Container/getObjectsUnderPoint"}}{{/crossLink}} for more information.
     *
     * @param {(number|null)} x The x position in the container to test.
     * @param {(number|null)} y The y position in the container to test.
     * @param {(number|null)} mode The mode to use to determine which display objects to include.  0-all, 1-respect mouseEnabled/mouseChildren, 2-only mouse opaque objects.
     * @see [Container]
     * @returns {(createjs.DisplayObject|null)} The top-most display object under the specified coordinates.
     */
createjs.Container.prototype.getObjectUnderPoint = function (x, y, mode) {  return null; }



    /**
     * Changes the depth of the specified child. Fails silently if the child is not a child of this container, or the index is out of range.
     *
     * @param {(createjs.DisplayObject|null)} child 
     * @param {(number|null)} index 
     * @see [Container]
     */
createjs.Container.prototype.setChildIndex = function (child, index) {  }

    /**
     * Returns an array of all display objects under the specified coordinates that are in this container's display
     * list. This routine ignores any display objects with {{#crossLink "DisplayObject/mouseEnabled:property"}}{{/crossLink}}
     * set to `false`. The array will be sorted in order of visual depth, with the top-most display object at index 0.
     * This uses shape based hit detection, and can be an expensive operation to run, so it is best to use it carefully.
     * For example, if testing for objects under the mouse, test on tick (instead of on {{#crossLink "DisplayObject/mousemove:event"}}{{/crossLink}}),
     * and only if the mouse's position has changed.
     * 
     * <ul>
     * <li>By default (mode=0) this method evaluates all display objects.</li>
     * <li>By setting the `mode` parameter to `1`, the {{#crossLink "DisplayObject/mouseEnabled:property"}}{{/crossLink}}
     * and {{#crossLink "mouseChildren:property"}}{{/crossLink}} properties will be respected.</li>
     * <li>Setting the `mode` to `2` additionally excludes display objects that do not have active mouse event
     * listeners or a {{#crossLink "DisplayObject:cursor:property"}}{{/crossLink}} property. That is, only objects
     * that would normally intercept mouse interaction will be included. This can significantly improve performance
     * in some cases by reducing the number of display objects that need to be tested.</li>
     * </li>
     * 
     * This method accounts for both {{#crossLink "DisplayObject/hitArea:property"}}{{/crossLink}} and {{#crossLink "DisplayObject/mask:property"}}{{/crossLink}}.
     *
     * @param {(number|null)} x The x position in the container to test.
     * @param {(number|null)} y The y position in the container to test.
     * @param {number=} opt_mode The mode to use to determine which display objects to include. 0-all, 1-respect mouseEnabled/mouseChildren, 2-only mouse opaque objects.
     * @see [Container]
     * @returns {(Array|null)} An Array of DisplayObjects under the specified coordinates.
     */
createjs.Container.prototype.getObjectsUnderPoint = function (x, y, opt_mode) {  return null; }

    /**
     * Removes the specified child from the display list. Note that it is faster to use removeChildAt() if the index is
     * already known.
     * 
     * <h4>Example</h4>
     * 
     * container.removeChild(child);
     * 
     * You can also remove multiple children:
     * 
     * removeChild(child1, child2, ...);
     * 
     * Returns true if the child (or children) was removed, or false if it was not in the display list.
     *
     * @param {(createjs.DisplayObject|null)} child The child to remove.
     * @see [Container]
     * @returns {(boolean|null)} true if the child (or children) was removed, or false if it was not in the display list.
     */
createjs.Container.prototype.removeChild = function (child) {  return null; }

    /**
     * @param {(number|null)} x 
     * @param {(number|null)} y 
     * @param {(Array|null)} arr 
     * @param {(boolean|null)} mouse If true, it will respect mouse interaction properties like mouseEnabled, mouseChildren, and active listeners.
     * @param {(boolean|null)} activeListener If true, there is an active mouse event listener on a parent object.
     * @param {(number|null)} currentDepth Indicates the current depth of the search.
     * @see [Container]
     * @returns {(createjs.DisplayObject|null)} 
     */
createjs.Container.prototype._getObjectsUnderPoint = function (x, y, arr, mouse, activeListener, currentDepth) {  return null; }

    /**
     * @param {(createjs.DisplayObject|null)} target 
     * @param {(number|null)} x 
     * @param {(number|null)} y 
     * @see [Container]
     * @returns {(boolean|null)} Indicates whether the x/y is within the masked region.
     */
createjs.Container.prototype._testMask = function (target, x, y) {  return null; }

    /**
     * Adds a child to the top of the display list.
     * 
     * <h4>Example</h4>
     * 
     * container.addChild(bitmapInstance);
     * 
     * You can also add multiple children at once:
     * 
     * container.addChild(bitmapInstance, shapeInstance, textInstance);
     *
     * @param {(createjs.DisplayObject|null)} child The display object to add.
     * @see [Container]
     * @returns {(createjs.DisplayObject|null)} The child that was added, or the last child if multiple children were added.
     */
createjs.Container.prototype.addChild = function (child) {  return null; }


    /**
     * Recursively clones all children of this container, and adds them to the target container.
     *
     * @param {(createjs.Container|null)} o The target container.
     * @see [Container]
     */
createjs.Container.prototype._cloneChildren = function (o) {  }

