/** @fileoverview Auto-generated Externs files
 * @externs
 */
/**
 * Displays text using bitmap glyphs defined in a sprite sheet. Multi-line text is supported
 * using new line characters, but automatic wrapping is not supported. See the
 * {{#crossLink "BitmapText/spriteSheet:property"}}{{/crossLink}}
 * property for more information on defining glyphs.
 * 
 * <strong>Important:</strong> BitmapText extends Container, but is not designed to be used as one.
 * As such, methods like addChild and removeChild are disabled.
 *
 * @see [BitmapText]
 * @param {string=} opt_text The text to display.
 * @param {createjs.SpriteSheet=} opt_spriteSheet The spritesheet that defines the character glyphs.
 * @constructor
 * @extends createjs.DisplayObject
 */
createjs.BitmapText = function (opt_text, opt_spriteSheet) {}

    /**
     * @param {(createjs.SpriteSheet|null)} ss 
     * @see [BitmapText]
     * @returns {(number|null)} 
     */
createjs.BitmapText.prototype._getLineHeight = function (ss) { return 0; }




    /**
     * @param {(createjs.SpriteSheet|null)} ss 
     * @see [BitmapText]
     * @returns {(number|null)} 
     */
createjs.BitmapText.prototype._getSpaceWidth = function (ss) { return 0; }


    /**
     * @param {string} character 
     * @param {(createjs.SpriteSheet|null)} spriteSheet 
     * @see [BitmapText]
     * @returns {(number|null)} 
     */
createjs.BitmapText.prototype._getFrameIndex = function (character, spriteSheet) { return 0; }


    /**
     * @param {string} character 
     * @param {(createjs.SpriteSheet|null)} spriteSheet 
     * @see [BitmapText]
     * @returns {(Object|null)} 
     */
createjs.BitmapText.prototype._getFrame = function (character, spriteSheet) {  return null; }

    /**
     * @see [BitmapText]
     */
createjs.BitmapText.prototype._updateText = function () {  }

