/** @fileoverview Auto-generated Externs files
 * @externs
 */
/**
 * A Bitmap represents an Image, Canvas, or Video in the display list. A Bitmap can be instantiated using an existing
 * HTML element, or a string.
 * 
 * <h4>Example</h4>
 * 
 * var bitmap = new createjs.Bitmap("imagePath.jpg");
 * 
 * <strong>Notes:</strong>
 * <ol>
 * <li>When a string path or image tag that is not yet loaded is used, the stage may need to be redrawn before it
 * will be displayed.</li>
 * <li>Bitmaps with an SVG source currently will not respect an alpha value other than 0 or 1. To get around this,
 * the Bitmap can be cached.</li>
 * <li>Bitmaps with an SVG source will taint the canvas with cross-origin data, which prevents interactivity. This
 * happens in all browsers except recent Firefox builds.</li>
 * <li>Images loaded cross-origin will throw cross-origin security errors when interacted with using a mouse, using
 * methods such as `getObjectUnderPoint`, or using filters, or caching. You can get around this by setting
 * `crossOrigin` flags on your images before passing them to EaselJS, eg: `img.crossOrigin="Anonymous";`</li>
 * </ol>
 *
 * @see [Bitmap]
 * @param {(HTMLCanvasElement|HTMLVideoElement|Image|string|null)} imageOrUri The source object or URI to an image to display. This can be either an Image, Canvas, or Video object, or a string URI to an image file to load and use. If it is a URI, a new Image object will be constructed and assigned to the .image property.
 * @constructor
 * @extends createjs.DisplayObject
 */
createjs.Bitmap = function (imageOrUri) {}






