/** @fileoverview Auto-generated Externs files
 * @externs
 */
/**
 * The Ticker provides a centralized tick or heartbeat broadcast at a set interval. Listeners can subscribe to the tick
 * event to be notified when a set time interval has elapsed.
 * 
 * Note that the interval that the tick event is called is a target interval, and may be broadcast at a slower interval
 * when under high CPU load. The Ticker class uses a static interface (ex. `createjs.Ticker.framerate = 30;`) and
 * can not be instantiated.
 * 
 * <h4>Example</h4>
 * 
 * createjs.createjs.Ticker.addEventListener("tick", handleTick);
 * function handleTick(event) {
 * // Actions carried out each tick (aka frame)
 * if (!event.paused) {
 * // Actions carried out when the Ticker is not paused.
 * }
 * }
 *
 * @see [Ticker]
 * @constructor
 */
createjs.Ticker = function () {}

    /**
     * Use the {{#crossLink "Ticker/framerate:property"}}{{/crossLink}} property instead.
     *
     * @param {(number|null)} value 
     * @see [Ticker]
     */
createjs.Ticker.setFPS = function (value) {  }

    /**
     * @see [Ticker]
     */
createjs.Ticker._setupTick = function () {  }

    /**
     * Generated doc for missing method JSDoc.
     *
     * @see [Ticker]
     */
createjs.Ticker.addEventListener = function (type, handler) {  }

    /**
     * @see [Ticker]
     */
createjs.Ticker._handleRAF = function () {  }

    /**
     * Starts the tick. This is called automatically when the first listener is added.
     *
     * @see [Ticker]
     */
createjs.Ticker.init = function () {  }

    /**
     * @see [Ticker]
     */
createjs.Ticker._handleTimeout = function () {  }

    /**
     * Similar to getTime(), but returns the time on the most recent tick event object.
     *
     * @param runTime {Boolean} [runTime=false] If true, the runTime property will be returned instead of time.
     * @see [Ticker]
     * @returns {number} The time or runTime property from the most recent tick event or -1.
     */
createjs.Ticker.getEventTime = function (runTime) { return 0; }

    /**
     * Use the {{#crossLink "Ticker/paused:property"}}{{/crossLink}} property instead.
     *
     * @param {(boolean|null)} value 
     * @see [Ticker]
     */
createjs.Ticker.setPaused = function (value) {  }

    /**
     * Use the {{#crossLink "Ticker/framerate:property"}}{{/crossLink}} property instead.
     *
     * @see [Ticker]
     * @returns {(number|null)} 
     */
createjs.Ticker.getInterval = function () { return 0; }

    /**
     * Use the {{#crossLink "Ticker/paused:property"}}{{/crossLink}} property instead.
     *
     * @see [Ticker]
     * @returns {(boolean|null)} 
     */
createjs.Ticker.getPaused = function () {  return null; }

    /**
     * @see [Ticker]
     */
createjs.Ticker._handleSynch = function () {  }

    /**
     * @see [Ticker]
     */
createjs.Ticker._tick = function () {  }

    /**
     * Returns the actual frames / ticks per second.
     *
     * @param {number=} opt_ticks The number of previous ticks over which to measure the actual frames / ticks per second. Defaults to the number of ticks per second.
     * @see [Ticker]
     * @returns {(number|null)} The actual frames / ticks per second. Depending on performance, this may differ from the target frames per second.
     */
createjs.Ticker.getMeasuredFPS = function (opt_ticks) { return 0; }

    /**
     * Returns the number of milliseconds that have elapsed since Ticker was initialized via {{#crossLink "Ticker/init"}}.
     * Returns -1 if Ticker has not been initialized. For example, you could use
     * this in a time synchronized animation to determine the exact amount of time that has elapsed.
     *
     * @param {boolean=} opt_runTime If true only time elapsed while Ticker was not paused will be returned. If false, the value returned will be total time elapsed since the first tick event listener was added.
     * @see [Ticker]
     * @returns {(number|null)} Number of milliseconds that have elapsed since Ticker was initialized or -1.
     */
createjs.Ticker.getTime = function (opt_runTime) { return 0; }

    /**
     * Returns the average time spent within a tick. This can vary significantly from the value provided by getMeasuredFPS
     * because it only measures the time spent within the tick execution stack.
     * 
     * Example 1: With a target FPS of 20, getMeasuredFPS() returns 20fps, which indicates an average of 50ms between
     * the end of one tick and the end of the next. However, getMeasuredTickTime() returns 15ms. This indicates that
     * there may be up to 35ms of "idle" time between the end of one tick and the start of the next.
     * 
     * Example 2: With a target FPS of 30, getFPS() returns 10fps, which indicates an average of 100ms between the end of
     * one tick and the end of the next. However, getMeasuredTickTime() returns 20ms. This would indicate that something
     * other than the tick is using ~80ms (another script, DOM rendering, etc).
     *
     * @param {number=} opt_ticks The number of previous ticks over which to measure the average time spent in a tick. Defaults to the number of ticks per second. To get only the last tick's time, pass in 1.
     * @see [Ticker]
     * @returns {(number|null)} The average time spent in a tick in milliseconds.
     */
createjs.Ticker.getMeasuredTickTime = function (opt_ticks) { return 0; }

    /**
     * Generated doc for missing method JSDoc.
     *
     * @see [Ticker]
     */
createjs.Ticker._getTime = function () {  }

    /**
     * Stops the Ticker and removes all listeners. Use init() to restart the createjs.Ticker.
     *
     * @see [Ticker]
     */
createjs.Ticker.reset = function () {  }

    /**
     * Returns the number of ticks that have been broadcast by createjs.Ticker.
     *
     * @param {(boolean|null)} pauseable Indicates whether to include ticks that would have been broadcast while Ticker was paused. If true only tick events broadcast while Ticker is not paused will be returned. If false, tick events that would have been broadcast while Ticker was paused will be included in the return value. The default value is false.
     * @see [Ticker]
     * @returns {(number|null)} of ticks that have been broadcast.
     */
createjs.Ticker.getTicks = function (pauseable) { return 0; }

    /**
     * Use the {{#crossLink "Ticker/interval:property"}}{{/crossLink}} property instead.
     *
     * @see [Ticker]
     * @returns {(number|null)} 
     */
createjs.Ticker.getFPS = function () { return 0; }

    /**
     * Use the {{#crossLink "Ticker/interval:property"}}{{/crossLink}} property instead.
     *
     * @param {(number|null)} interval 
     * @see [Ticker]
     */
createjs.Ticker.setInterval = function (interval) {  }

